/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseSaleTaskInstBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseShipTaskInstBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocInspOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocInspOrderModifyRemainInspCountReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocInspOrderModifyRemainInspCountRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderItemBO;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UocInspOrderModifyRemainInspCountTransaction {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    private static final Integer CHNG_TYPE_ADD = 1;
    private static final Integer CHNG_TYPE_SUBTRACT = 2;
    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final Integer OP_FLAG_REFUSE = 0;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocInspOrderModifyRemainInspCountRspBo modifyCount(UocInspOrderModifyRemainInspCountReqBo reqBo) {
        UocInspOrderModifyRemainInspCountRspBo rspBo = UocRu.success(UocInspOrderModifyRemainInspCountRspBo.class);
        String operId = reqBo.getUserId().toString();
        Date now = new Date();
        List<UocChngOrderItemObj> uocChngOrderItemObjList = this.getListChngOrderItemObj(reqBo);
        Map<Integer, List<UocChngOrderItemObj>> chngItems = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getChngType));
        List<UocChngOrderItemObj> uocChngNums = chngItems.get(UocConstant.BUSI_TYPE.NUM);
        List<UocChngOrderItemObj> uocChngState = chngItems.get(UocConstant.BUSI_TYPE.STATE);
        if (!CollectionUtil.isEmpty(uocChngNums)) {
            if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
                this.confirm(reqBo, operId, now, uocChngNums);
            }
            if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
                this.refuse(reqBo, operId, now, uocChngNums);
            }
        }
        if (!CollectionUtil.isEmpty(uocChngState)) {
            if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
                this.confirmStat(reqBo, operId, now, uocChngState);
                this.getShipTaskInsts(reqBo, rspBo);
                this.getSaleOrderInfo(reqBo, rspBo);
            }
            if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
                this.refuseState(reqBo, operId, now, uocChngState);
            }
        }
        this.buildSyncRsp(reqBo, rspBo, uocChngOrderItemObjList);
        return rspBo;
    }

    private void confirmStat(UocInspOrderModifyRemainInspCountReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo;
        UocShipOrderDo uocShipOrderDo;
        Map<String, List<UocChngOrderItemObj>> chngOrderItemMaps = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getOtherChngValue));
        List<UocChngOrderItemObj> uocChngOrderItemObjsJS = chngOrderItemMaps.get("1");
        List<UocChngOrderItemObj> uocChngOrderItemObjsTT = chngOrderItemMaps.get("2");
        if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsJS)) {
            uocShipOrderDo = this.convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjsJS);
            uocSaleOrderDo = this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjsJS);
            this.iUocSaleOrderModel.modifyItemRefuseCountConfirm(uocSaleOrderDo);
            this.iUocShipOrderModel.modifyItemRefuseCountConfirm(uocShipOrderDo);
        }
        if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsTT)) {
            uocShipOrderDo = this.convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjsTT);
            uocSaleOrderDo = this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjsTT);
            this.iUocSaleOrderModel.modifyItemArriveCountConfirm(uocSaleOrderDo);
            this.iUocShipOrderModel.modifyItemArriveCountConfirm(uocShipOrderDo);
        }
        List<Long> shipItemIdList = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).distinct().collect(Collectors.toList());
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipItemIdList);
        List<UocShipOrderItem> shipOrderItemList = this.iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
        if (CollectionUtil.isNotEmpty(shipOrderItemList)) {
            Map<Long, Long> shipItemToShipIdMaps = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, UocShipOrderItem::getShipOrderId));
            uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
                UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
                Long shipOrderItemId = uocChngOrderItemObj.getShipOrderItemId();
                Long shipOrderId = (Long)shipItemToShipIdMaps.get(shipOrderItemId);
                uocShipOrderDo.setOrderId(uocChngOrderItemObj.getOrderId());
                uocShipOrderDo.setShipOrderId(shipOrderId);
                this.iUocShipOrderModel.modifyStatChngShipStatus(uocShipOrderDo);
            });
        }
    }

    private void getShipTaskInsts(UocInspOrderModifyRemainInspCountReqBo reqBo, UocInspOrderModifyRemainInspCountRspBo rsp) {
        ArrayList shipTaskInstBoList = new ArrayList();
        List<Long> chngOrderIds = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIds);
        List<UocChngOrderObj> listChngOrderObjWithOutItem = this.iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
        listChngOrderObjWithOutItem.forEach(x -> {
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            uocOrderTaskInst.setOrderId(x.getOrderId());
            uocOrderTaskInst.setObjId(x.getShipOrderId());
            uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
            if (CollectionUtil.isEmpty(uocOrderTaskInsts)) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u53d1\u8d27\u5355\u4efb\u52a1\u4fe1\u606f\u4e3a\u7a7a");
            }
            UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
            String taskInstId = uocOrderTaskInst1.getTaskInstId();
            String procState = uocOrderTaskInst1.getProcState();
            UocChngOrderConfirmOrRefuseShipTaskInstBo uocChngOrderConfirmOrRefuseShipTaskInstBo = new UocChngOrderConfirmOrRefuseShipTaskInstBo();
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setShipOrderId(x.getShipOrderId());
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setTaskId(taskInstId);
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setStepId(procState);
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setChngOrderId(x.getChngOrderId());
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setOrderId(x.getOrderId());
            shipTaskInstBoList.add(uocChngOrderConfirmOrRefuseShipTaskInstBo);
        });
        rsp.setShipTaskInstList(shipTaskInstBoList);
    }

    private void getSaleOrderInfo(UocInspOrderModifyRemainInspCountReqBo reqBo, UocInspOrderModifyRemainInspCountRspBo rsp) {
        ArrayList<UocChngOrderConfirmOrRefuseSaleTaskInstBo> saleOrderTaskInstBoList = new ArrayList<UocChngOrderConfirmOrRefuseSaleTaskInstBo>();
        List<Long> chngOrderIds = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIds);
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        uocChngOrderItemObjQryBo.setChngOrderIdList(chngOrderIds);
        List<UocChngOrderItemObj> listChngOrderItemObj = this.iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        Map<Long, List<UocChngOrderItemObj>> chngOrderItemMaps = listChngOrderItemObj.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getChngOrderId));
        List<UocChngOrderObj> listChngOrderObjWithOutItem = this.iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
        if (CollectionUtil.isEmpty(listChngOrderObjWithOutItem)) {
            throw new BaseBusinessException("101008", "\u67e5\u8be2\u53d8\u66f4\u5bf9\u8c61\u4e3a\u7a7a");
        }
        for (UocChngOrderObj uocChngOrderObj : listChngOrderObjWithOutItem) {
            String procState;
            Long saleOrderId = uocChngOrderObj.getSaleOrderId();
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderId(saleOrderId);
            uocSaleOrderDo.setOrderId(uocChngOrderObj.getOrderId());
            UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
            if (!UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderMain.getOrderSource()) || !UocConstant.BUSI_TYPE.STATE.equals(uocChngOrderObj.getChngType())) continue;
            Boolean flag = null;
            UocOrderTaskInst uocSaleOrderTaskInst = new UocOrderTaskInst();
            uocSaleOrderTaskInst.setOrderId(uocChngOrderObj.getOrderId());
            uocSaleOrderTaskInst.setObjId(saleOrderId);
            uocSaleOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            uocSaleOrderTaskInst.setFinishTag(0);
            List<UocOrderTaskInst> uocSaleOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(uocSaleOrderTaskInst);
            if (CollectionUtil.isEmpty(uocSaleOrderTaskInsts)) {
                return;
            }
            UocOrderTaskInst uocSaleOrderTaskInst1 = uocSaleOrderTaskInsts.get(0);
            List<UocChngOrderItemObj> uocChngOrderItemObjs = chngOrderItemMaps.get(uocChngOrderObj.getChngOrderId());
            if (CollectionUtil.isEmpty(uocChngOrderItemObjs)) break;
            if ("1".equals(uocChngOrderItemObjs.get(0).getOtherChngValue())) {
                UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
                uocShipOrderQryBo.setSaleOrderId(saleOrderId);
                uocShipOrderQryBo.setOrderId(uocChngOrderObj.getOrderId());
                List<UocShipOrderDo> listShipOrder = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
                if (CollectionUtil.isEmpty(listShipOrder)) {
                    throw new BaseBusinessException("100001", "\u901a\u8fc7\u9500\u552e\u5355\u67e5\u8be2\u53d1\u8d27\u5355\u5217\u8868\u4e3a\u7a7a");
                }
                for (UocShipOrderDo uocShipOrderDo : listShipOrder) {
                    UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
                    uocOrderTaskInst.setOrderId(uocChngOrderObj.getOrderId());
                    uocOrderTaskInst.setObjId(uocShipOrderDo.getShipOrderId());
                    uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                    uocOrderTaskInst.setFinishTag(0);
                    List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
                    if (CollectionUtil.isEmpty(uocOrderTaskInsts)) {
                        return;
                    }
                    UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
                    String procState2 = uocOrderTaskInst1.getProcState();
                    if ("XS_YS_YS".equals(procState2)) {
                        flag = true;
                        continue;
                    }
                    flag = false;
                    break;
                }
                if ((flag = (Boolean)Optional.ofNullable(flag).orElse(Boolean.FALSE)).booleanValue()) {
                    String taskId = uocSaleOrderTaskInst1.getTaskInstId();
                    UocChngOrderConfirmOrRefuseSaleTaskInstBo saleTaskinfo = new UocChngOrderConfirmOrRefuseSaleTaskInstBo();
                    saleTaskinfo.setTaskId(taskId);
                    saleTaskinfo.setStepId(uocSaleOrderTaskInst1.getProcState());
                    saleTaskinfo.setSaleOrderId(saleOrderId);
                    saleTaskinfo.setOrderId(uocChngOrderObj.getOrderId());
                    saleOrderTaskInstBoList.add(saleTaskinfo);
                }
            }
            if (!"2".equals(uocChngOrderItemObjs.get(0).getOtherChngValue()) || !"XS_DH_JS".equals(procState = uocSaleOrderTaskInst1.getProcState())) continue;
            String taskId = uocSaleOrderTaskInst1.getTaskInstId();
            UocChngOrderConfirmOrRefuseSaleTaskInstBo saleTaskinfo = new UocChngOrderConfirmOrRefuseSaleTaskInstBo();
            saleTaskinfo.setTaskId(taskId);
            saleTaskinfo.setStepId(uocSaleOrderTaskInst1.getProcState());
            saleTaskinfo.setSaleOrderId(saleOrderId);
            saleTaskinfo.setOrderId(uocChngOrderObj.getOrderId());
            saleOrderTaskInstBoList.add(saleTaskinfo);
        }
        rsp.setSaleOrderTaskInstList(saleOrderTaskInstBoList);
    }

    private void refuseState(UocInspOrderModifyRemainInspCountReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        this.iUocShipOrderModel.modifyItemChngCountRefuse(this.convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        this.iUocSaleOrderModel.modifyBatchItemChngCountRefuse(this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }

    private void confirm(UocInspOrderModifyRemainInspCountReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        for (UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList) {
            if (uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_ADD)) {
                this.iUocInspOrderModel.modifyItemChngCountConfirmAdd(this.convertInspOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
                this.iUocSaleOrderModel.modifyItemChngCountConfirmAdd(this.convertSaleOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
                this.iUocChngOrderModel.modifyItemChngCountConfirm(uocChngOrderItemObj);
                continue;
            }
            if (!uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_SUBTRACT)) continue;
            this.iUocInspOrderModel.modifyItemChngCountConfirmReduce(this.convertInspOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
            this.iUocSaleOrderModel.modifyItemChngCountConfirmReduce(this.convertSaleOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
            this.iUocChngOrderModel.modifyItemChngCountConfirm(uocChngOrderItemObj);
        }
        this.chngInspFee(uocChngOrderItemObjList, reqBo);
    }

    private void refuse(UocInspOrderModifyRemainInspCountReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        this.iUocSaleOrderModel.modifyItemChngCountRefuse(this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        this.iUocInspOrderModel.modifyItemChngCountRefuse(this.convertInspOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }

    private UocSaleOrderDo convertSaleOrderDoForSingle(UocInspOrderModifyRemainInspCountReqBo reqBo, Date now, String operId, UocChngOrderItemObj uocChngOrderItemObj) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setChngingCount(uocChngOrderItemObj.getChngNum());
        uocSaleOrderDo.setOrderIdList(Collections.singletonList(uocChngOrderItemObj.getOrderId()));
        uocSaleOrderDo.setSaleOrderItemsIdList(Collections.singletonList(uocChngOrderItemObj.getSaleOrderItemId()));
        return uocSaleOrderDo;
    }

    private UocInspOrderDo convertInspOrderDo(UocInspOrderModifyRemainInspCountReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setInspOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList()));
        uocInspOrderDo.setOrderIdList(orderIdList);
        uocInspOrderDo.setUpdateTime(now);
        uocInspOrderDo.setUpdateOperId(operId);
        return uocInspOrderDo;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocInspOrderModifyRemainInspCountReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList()));
        uocSaleOrderDo.setSaleOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList()));
        return uocSaleOrderDo;
    }

    private void modifyCount(UocInspOrderModifyRemainInspCountReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        for (UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList) {
            if (uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_ADD)) {
                this.iUocInspOrderModel.modifyItemRemainCountReduce(this.convertInspOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
                continue;
            }
            if (!uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_SUBTRACT)) continue;
            this.iUocInspOrderModel.modifyItemRemainCountAdd(this.convertInspOrderDoForSingle(reqBo, now, operId, uocChngOrderItemObj));
        }
        this.chngInspFee(uocChngOrderItemObjList, reqBo);
    }

    private void chngInspFee(List<UocChngOrderItemObj> uocChngOrderItemObjList, UocInspOrderModifyRemainInspCountReqBo reqBO) {
        List<Long> inspItemIdList = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).distinct().collect(Collectors.toList());
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderItemIdList(inspItemIdList);
        UocInspOrderDo uocInspOrderDo = this.iUocInspOrderModel.getInspOrderItemList(uocInspOrderItemQryBo);
        if (null == uocInspOrderDo || CollectionUtils.isEmpty(uocInspOrderDo.getUocInspOrderItemList())) {
            throw new ZTBusinessException("\u67e5\u8be2\u9a8c\u6536\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
        Map<Long, List<UocChngOrderItemObj>> inspItemMap = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getInspOrderItemId));
        Map<Long, List<UocInspOrderItem>> inspOrderMap = uocInspOrderDo.getUocInspOrderItemList().stream().collect(Collectors.groupingBy(UocInspOrderItem::getInspOrderId));
        inspOrderMap.forEach((k, v) -> {
            BigDecimal totalAddSaleFee = BigDecimal.ZERO;
            BigDecimal totalAddPurchaseFee = BigDecimal.ZERO;
            BigDecimal totalReduceSaleFee = BigDecimal.ZERO;
            BigDecimal totalReducePurchaseFee = BigDecimal.ZERO;
            for (UocInspOrderItem item : v) {
                UocChngOrderItemObj uocChngOrderItemObj = (UocChngOrderItemObj)((List)inspItemMap.get(item.getInspOrderItemId())).get(0);
                if (uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_ADD)) {
                    totalAddSaleFee = totalAddSaleFee.add(uocChngOrderItemObj.getChngFee());
                    totalAddPurchaseFee = totalAddPurchaseFee.add(uocChngOrderItemObj.getChngPurchaseFee());
                    continue;
                }
                if (!uocChngOrderItemObj.getAddOrSubtractType().equals(CHNG_TYPE_SUBTRACT)) continue;
                totalReduceSaleFee = totalReduceSaleFee.add(uocChngOrderItemObj.getChngFee());
                totalReducePurchaseFee = totalReducePurchaseFee.add(uocChngOrderItemObj.getChngPurchaseFee());
            }
            BigDecimal totalSaleChngFee = totalReduceSaleFee.subtract(totalAddSaleFee);
            BigDecimal totalPurchaseChngFee = totalReducePurchaseFee.subtract(totalAddPurchaseFee);
            UocInspOrderDo orderDo = new UocInspOrderDo();
            orderDo.setInspOrderId((Long)k);
            orderDo.setTotalSaleFee(totalSaleChngFee);
            orderDo.setTotalPurchaseFee(totalPurchaseChngFee);
            orderDo.setUpdateOperId(reqBO.getUserId().toString());
            orderDo.setUpdateTime(new Date());
            this.iUocInspOrderModel.modifyInsporderChngTotalFeeConfirm(orderDo);
        });
    }

    private UocInspOrderDo convertInspOrderDoForSingle(UocInspOrderModifyRemainInspCountReqBo reqBo, Date now, String operId, UocChngOrderItemObj uocChngOrderItemObj) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setInspOrderItemsIdList(Arrays.asList(uocChngOrderItemObj.getInspOrderItemId()));
        uocInspOrderDo.setOrderIdList(Arrays.asList(uocChngOrderItemObj.getOrderId()));
        uocInspOrderDo.setInspCount(uocChngOrderItemObj.getChngNum());
        uocInspOrderDo.setUpdateTime(now);
        uocInspOrderDo.setUpdateOperId(operId);
        return uocInspOrderDo;
    }

    private List<UocChngOrderItemObj> getListChngOrderItemObj(UocInspOrderModifyRemainInspCountReqBo reqBo) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        uocChngOrderItemObjQryBo.setChngOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList()));
        uocChngOrderItemObjQryBo.setOrderIdList(orderIdList);
        List<UocChngOrderItemObj> uocChngOrderItemObjList = this.iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
            throw new BaseBusinessException("101008", "\u67e5\u8be2\u53d8\u66f4\u660e\u7ec6\u5bf9\u8c61\u4e3a\u7a7a");
        }
        return uocChngOrderItemObjList;
    }

    private void buildSyncRsp(UocInspOrderModifyRemainInspCountReqBo reqBo, UocInspOrderModifyRemainInspCountRspBo rspBo, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> saleOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList());
        List<Long> inspOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList());
        List<Long> shipOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        rspBo.setSaleOrderItemList(UocRu.jsl(saleOrderItemList, UocSaleOrderItemBO.class));
        rspBo.getSaleOrderIdList().addAll(saleOrderItemList.stream().map(x -> x.getSaleOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipOrderItemIds);
        List<UocShipOrderItem> shipOrderItemList = this.iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
        rspBo.getShipOrderIdList().addAll(shipOrderItemList.stream().map(x -> x.getShipOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderItemIdList(inspOrderItemIds);
        UocInspOrderDo uocInspOrderDo = this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
        Map<Long, List<UocInspOrderItem>> inspOrderMap = uocInspOrderDo.getUocInspOrderItemList().stream().collect(Collectors.groupingBy(UocInspOrderItem::getInspOrderId));
        rspBo.setInspOrderIdLists(uocInspOrderDo.getUocInspOrderItemList().stream().map(x -> x.getInspOrderId() + "").distinct().collect(Collectors.toList()));
        rspBo.getInspOrderIdList().addAll(uocInspOrderDo.getUocInspOrderItemList().stream().map(x -> x.getInspOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));
        reqBo.getChngOrderList().forEach(x -> rspBo.getChngOrderIdList().add(x.getChngOrderId() + "-" + x.getOrderId()));
        ArrayList<UocInspOrderDo> inspOrderDoList = new ArrayList<UocInspOrderDo>();
        List inspOrderIdList = uocInspOrderDo.getUocInspOrderItemList().stream().map(UocInspOrderItem::getInspOrderId).distinct().collect(Collectors.toList());
        for (Long inspOrderId : inspOrderIdList) {
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setInspOrderId((long)inspOrderId);
            uocInspOrderDo = this.iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
            uocInspOrderDo.setUocInspOrderItemList(inspOrderMap.get(inspOrderId));
            inspOrderDoList.add(uocInspOrderDo);
        }
        List saleOrderIdList = saleOrderItemList.stream().map(UocSaleOrderItem::getSaleOrderId).distinct().collect(Collectors.toList());
        ArrayList<UocSaleOrderDo> saleOrderDoList = new ArrayList<UocSaleOrderDo>();
        for (Long saleOrderId : saleOrderIdList) {
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setSaleOrderId((long)saleOrderId);
            UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
            saleOrderDoList.add(uocSaleOrderDo);
        }
        rspBo.setInspOrderBoList(UocRu.jsl(inspOrderDoList, UocInspOrderBo.class));
        rspBo.setSaleOrderBOList(UocRu.jsl(saleOrderDoList, UocSaleOrderBO.class));
    }

    private UocShipOrderDo convertShipOrderDo(UocInspOrderModifyRemainInspCountReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setShipOrderItemIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList()));
        uocShipOrderDo.setOrderIdList(orderIdList);
        uocShipOrderDo.setUpdateTime(now);
        uocShipOrderDo.setUpdateOperId(operId);
        return uocShipOrderDo;
    }
}

