/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UocEsSyncTransaction
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncTransaction.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    private static final String CHARGE_MONTH_SERVICE = "1";
    private static final String SALE = "1";
    private static final String INSP = "2";

    @Override
    public String indexName() {
        return this.uocIndexConfig.getTransactionIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        log.info("\u6210\u4ea4\u670d\u52a1\u8d39\u540c\u6b65\u5165\u53c2\uff1a" + reqBo);
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        Long orderId = reqBo.getOrderId();
        JSONObject supplierSignInfo = reqBo.getJsonObj();
        String supplierId = supplierSignInfo.getString("supplierId");
        String monthServiceFee = supplierSignInfo.getString("monthServiceFee");
        String monthReceiveNode = supplierSignInfo.getString("monthReceiveNode");
        JSONArray salesBOS = supplierSignInfo.getJSONArray("salesBOS");
        HashMap<String, String> serviceFeeRateMap = new HashMap<String, String>(salesBOS.size());
        for (int i = 0; i < salesBOS.size(); ++i) {
            JSONObject itemCat = salesBOS.getJSONObject(i);
            serviceFeeRateMap.put(supplierId + itemCat.getString("itemCatId"), itemCat.getString("serviceFeeRate"));
        }
        if (UocDicConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())) {
            if ("1".equals(monthReceiveNode)) {
                this.syncSaleTransaction(reqBo, rspBo, orderId, serviceFeeRateMap, monthServiceFee);
            } else {
                rspBo.setSyncFlag(false);
            }
        } else if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(reqBo.getObjType())) {
            Long inspOrderId = reqBo.getObjId();
            UocInspOrderDo inspOrderMain = this.getUocInspOrderDo(orderId, inspOrderId);
            UocSaleOrderDo saleOrderMain = this.getUocSaleOrderDo(orderId, inspOrderMain.getSaleOrderId());
            UocOrderRel uocOrderRel = this.getUocOrderRel(orderId, saleOrderMain.getSaleOrderId(), UocDicConstant.OBJ_TYPE.SALE);
            if (null == uocOrderRel) {
                this.syncInspTransaction(reqBo, rspBo, orderId, serviceFeeRateMap, monthServiceFee, inspOrderMain, saleOrderMain);
                String serMoney = rspBo.getJsonObj().getString("serPriceMoney");
                if (new BigDecimal(serMoney).compareTo(BigDecimal.ZERO) == 0) {
                    rspBo.setSyncFlag(false);
                }
            } else {
                rspBo.setSyncFlag(false);
            }
        }
        this.putReceiverAddressBo(rspBo.getJsonObj(), orderId);
        return rspBo;
    }

    private void putReceiverAddressBo(JSONObject jsonObj, Long orderId) {
        UocOrderDo qryBo = new UocOrderDo();
        qryBo.setOrderId(orderId);
        UocOrderDo uocOrderDo = this.iUocOrderModel.qryOrderBy(qryBo);
        if (null != uocOrderDo) {
            UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
            relaQryBo.setOrderId(uocOrderDo.getOrderId());
            relaQryBo.setContactId(uocOrderDo.getContactId());
            UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
            jsonObj.put("receiverAddressBO", (Object)uocOrdLogisticsRela);
        }
    }

    private void syncInspTransaction(IUocEsSyncQryReqBo reqBo, IUocEsSyncQryRspBo rspBo, Long orderId, Map<String, String> serviceFeeRateMap, String monthServiceFee, UocInspOrderDo inspOrderMain, UocSaleOrderDo saleOrderMain) {
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItemList(reqBo, saleOrderMain.getSaleOrderId());
        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocSaleStakeholder stakeholder = this.getStakeholder(saleOrderMain.getStakeholderId());
        UocOrderRel uocOrderRel = this.getUocOrderRel(orderId, inspOrderMain.getInspOrderId(), UocDicConstant.OBJ_TYPE.INSPECTION);
        List<UocInspOrderItem> uocInspOrderItemList = this.getUocInspOrderItems(orderId, inspOrderMain, saleOrderItemMap);
        Map<String, Map<String, String>> dic = this.getDic();
        Map<String, String> relTypeMap = dic.get("UOC_ORDER_REL_TYPE");
        Map<String, String> relStatusMap = dic.get("UOC_ORDER_REL_STATUS");
        JSONObject jsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)saleOrderMain)));
        jsonObj.putAll(BeanUtil.beanToMap((Object)stakeholder, (boolean)false, (boolean)true));
        jsonObj.put("inspOrderId", (Object)inspOrderMain.getInspOrderId());
        jsonObj.put("inspOrderNo", (Object)inspOrderMain.getInspOrderNo());
        log.info("\u6210\u4ea4\u670d\u52a1\u8d39jsonObj\uff1a" + jsonObj);
        log.info("\u6210\u4ea4\u670d\u52a1\u8d39stakeholder\uff1a" + stakeholder);
        log.info("\u6210\u4ea4\u670d\u52a1\u8d39serviceFeeRateMap\uff1a" + serviceFeeRateMap);
        JSONArray inspOrderItems = JSONArray.parseArray((String)JSON.toJSONString(uocInspOrderItemList));
        BigDecimal totalSerPriceMoney = BigDecimal.ZERO;
        BigDecimal totalSaleFee = BigDecimal.ZERO;
        BigDecimal totalPurchaseFee = BigDecimal.ZERO;
        for (int i = 0; i < inspOrderItems.size(); ++i) {
            JSONObject inspItem = inspOrderItems.getJSONObject(i);
            UocSaleOrderItem uocSaleOrderItem = saleOrderItemMap.get(inspItem.getLong("saleOrderItemId"));
            log.info("\u9500\u552e\u5355\u660e\u7ec6uocSaleOrderItem:" + (Object)((Object)uocSaleOrderItem) + "saleOrderItemId:" + inspItem.getLong("saleOrderItemId") + "\u9a8c\u6536\u660e\u7ec6\uff1a" + inspItem);
            inspItem.put("skuName", (Object)uocSaleOrderItem.getSkuName());
            inspItem.put("skuId", (Object)uocSaleOrderItem.getSkuId());
            inspItem.put("spec", (Object)uocSaleOrderItem.getSpec());
            inspItem.put("model", (Object)uocSaleOrderItem.getModel());
            inspItem.put("commodityTypeId", (Object)uocSaleOrderItem.getCommodityTypeId());
            inspItem.put("unitName", (Object)uocSaleOrderItem.getUnitName());
            inspItem.put("itemCount", inspItem.get((Object)"inspCount"));
            inspItem.put("salePrice", (Object)uocSaleOrderItem.getSalePrice());
            inspItem.put("purPrice", (Object)uocSaleOrderItem.getPurchasePrice());
            log.info("\u8bda\u4ea4\u670d\u52a1\u8d39inspItem debug\uff1a" + inspItem);
            String serviceFeeRate = serviceFeeRateMap.get(jsonObj.getString("supId") + inspItem.getString("commodityTypeId"));
            log.info("\u8bda\u4ea4\u670d\u52a1\u8d39serviceFeeRate debug\uff1a" + serviceFeeRate);
            BigDecimal serPriceMoney = new BigDecimal(inspItem.getString("itemCount")).multiply(new BigDecimal(inspItem.getString("purPrice"))).multiply(new BigDecimal(serviceFeeRate)).divide(new BigDecimal(100), RoundingMode.CEILING);
            serPriceMoney = serPriceMoney.setScale(6, RoundingMode.HALF_UP);
            inspItem.put("serPriceMoney", (Object)serPriceMoney);
            inspItem.put("serviceFeeRate", "1".equals(monthServiceFee) ? serviceFeeRate : BigDecimal.ZERO);
            totalSerPriceMoney = totalSerPriceMoney.add(serPriceMoney);
            totalPurchaseFee = totalPurchaseFee.add(uocSaleOrderItem.getPurchasePrice().multiply(new BigDecimal(inspItem.getString("inspCount"))));
            totalSaleFee = totalSaleFee.add(uocSaleOrderItem.getSalePrice().multiply(new BigDecimal(inspItem.getString("inspCount"))));
        }
        jsonObj.put("inspSaleFee", (Object)inspOrderMain.getInspOrderNo());
        jsonObj.put("orderItem", (Object)inspOrderItems);
        jsonObj.put("monthServiceFee", (Object)monthServiceFee);
        jsonObj.put("saleFee", (Object)totalSaleFee);
        jsonObj.put("purFee", (Object)totalPurchaseFee);
        jsonObj.put("serPriceMoney", (Object)("1".equals(monthServiceFee) ? totalSerPriceMoney : BigDecimal.ZERO));
        jsonObj.put("supNoRule", (Object)(jsonObj.getString("supId") + INSP));
        jsonObj.put("objType", (Object)UocDicConstant.OBJ_TYPE.INSPECTION);
        jsonObj.put("objTime", (Object)new Date());
        if (null != uocOrderRel) {
            jsonObj.put("relType", (Object)uocOrderRel.getRelType());
            jsonObj.put("relStatus", (Object)uocOrderRel.getRelStatus());
            jsonObj.put("relInfo", (Object)(uocOrderRel.getRelStatus() + "," + uocOrderRel.getRelType()));
            jsonObj.put("relId", (Object)uocOrderRel.getRelId());
            jsonObj.put("relStatusStr", (Object)relStatusMap.get(Convert.toStr((Object)uocOrderRel.getRelStatus())));
            jsonObj.put("relTypeStr", (Object)relTypeMap.get(Convert.toStr((Object)uocOrderRel.getRelType())));
        } else {
            jsonObj.put("relType", (Object)UocDicConstant.REL_TYPE.SERVICE_CHARGE);
            jsonObj.put("relStatus", (Object)UocDicConstant.REL_STATUS.UN_SUBMITTED);
            jsonObj.put("relInfo", (Object)(UocDicConstant.REL_STATUS.UN_SUBMITTED + "," + UocDicConstant.REL_TYPE.SERVICE_CHARGE));
            jsonObj.put("relStatusStr", (Object)relStatusMap.get(Convert.toStr((Object)UocDicConstant.REL_STATUS.UN_SUBMITTED)));
            jsonObj.put("relTypeStr", (Object)relTypeMap.get(Convert.toStr((Object)UocDicConstant.REL_TYPE.SERVICE_CHARGE)));
        }
        jsonObj.put("orderId", (Object)saleOrderMain.getSaleOrderId());
        log.info("\u540c\u6b65\u9a8c\u6536\u5355\u6210\u4ea4\u670d\u52a1\u8d39\uff1a" + jsonObj);
        rspBo.setJsonObj(jsonObj);
    }

    private void syncSaleTransaction(IUocEsSyncQryReqBo reqBo, IUocEsSyncQryRspBo rspBo, Long orderId, Map<String, String> serviceFeeRateMap, String monthServiceFee) {
        Long saleOrderId = reqBo.getObjId();
        UocSaleOrderDo saleOrderMain = this.getUocSaleOrderDo(orderId, saleOrderId);
        UocSaleStakeholder stakeholder = this.getStakeholder(saleOrderMain.getStakeholderId());
        UocOrderRel uocOrderRel = this.getUocOrderRel(orderId, saleOrderId, UocDicConstant.OBJ_TYPE.SALE);
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItemList(reqBo, saleOrderMain.getSaleOrderId());
        Map<String, Map<String, String>> dic = this.getDic();
        Map<String, String> relTypeMap = dic.get("UOC_ORDER_REL_TYPE");
        Map<String, String> relStatusMap = dic.get("UOC_ORDER_REL_STATUS");
        JSONObject jsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)saleOrderMain)));
        jsonObj.putAll(BeanUtil.beanToMap((Object)stakeholder, (boolean)false, (boolean)true));
        jsonObj.put("supNo", (Object)stakeholder.getSupId());
        jsonObj.put("supId", (Object)stakeholder.getSupId());
        JSONArray saleOrderItems = JSONArray.parseArray((String)JSON.toJSONString(saleOrderItemList));
        BigDecimal totalSerPriceMoney = BigDecimal.ZERO;
        BigDecimal totalSaleFee = BigDecimal.ZERO;
        BigDecimal totalPurchaseFee = BigDecimal.ZERO;
        for (int i = 0; i < saleOrderItems.size(); ++i) {
            JSONObject saleItem = saleOrderItems.getJSONObject(i);
            saleItem.put("itemCount", saleItem.get((Object)"purchaseCount"));
            String serviceFeeRate = serviceFeeRateMap.get(jsonObj.getString("supId") + saleItem.getString("commodityTypeId"));
            BigDecimal serPriceMoney = new BigDecimal(saleItem.getString("purchasePrice")).multiply(new BigDecimal(saleItem.getString("purchaseCount"))).multiply(new BigDecimal(serviceFeeRate)).divide(new BigDecimal(100), RoundingMode.CEILING);
            serPriceMoney = serPriceMoney.setScale(6, RoundingMode.HALF_UP);
            saleItem.put("serPriceMoney", (Object)("1".equals(monthServiceFee) ? serPriceMoney : BigDecimal.ZERO));
            saleItem.put("serviceFeeRate", (Object)serviceFeeRate);
            totalSerPriceMoney = totalSerPriceMoney.add(serPriceMoney);
            totalPurchaseFee = totalPurchaseFee.add(new BigDecimal(saleItem.getString("purchasePrice")).multiply(new BigDecimal(saleItem.getString("purchaseCount"))));
            totalSaleFee = totalSaleFee.add(new BigDecimal(saleItem.getString("salePrice")).multiply(new BigDecimal(saleItem.getString("purchaseCount"))));
        }
        jsonObj.put("orderItem", (Object)saleOrderItems);
        jsonObj.put("monthServiceFee", (Object)monthServiceFee);
        jsonObj.put("saleFee", (Object)totalSaleFee);
        jsonObj.put("purFee", (Object)totalPurchaseFee);
        jsonObj.put("serPriceMoney", (Object)("1".equals(monthServiceFee) ? totalSerPriceMoney : BigDecimal.ZERO));
        jsonObj.put("supNoRule", (Object)(jsonObj.getString("supId") + "1"));
        jsonObj.put("objType", (Object)UocDicConstant.OBJ_TYPE.SALE);
        jsonObj.put("objTime", (Object)new Date());
        if (null != uocOrderRel) {
            jsonObj.put("relType", (Object)uocOrderRel.getRelType());
            jsonObj.put("relStatus", (Object)uocOrderRel.getRelStatus());
            jsonObj.put("relInfo", (Object)(uocOrderRel.getRelStatus() + "," + uocOrderRel.getRelType()));
            jsonObj.put("relId", (Object)uocOrderRel.getRelId());
            jsonObj.put("relStatusStr", (Object)relStatusMap.get(Convert.toStr((Object)uocOrderRel.getRelStatus())));
            jsonObj.put("relTypeStr", (Object)relTypeMap.get(Convert.toStr((Object)uocOrderRel.getRelType())));
        } else {
            jsonObj.put("relType", (Object)UocDicConstant.REL_TYPE.SERVICE_CHARGE);
            jsonObj.put("relStatus", (Object)UocDicConstant.REL_STATUS.UN_SUBMITTED);
            jsonObj.put("relInfo", (Object)(UocDicConstant.REL_STATUS.UN_SUBMITTED + "," + UocDicConstant.REL_TYPE.SERVICE_CHARGE));
            jsonObj.put("relStatusStr", (Object)relStatusMap.get(Convert.toStr((Object)UocDicConstant.REL_STATUS.UN_SUBMITTED)));
            jsonObj.put("relTypeStr", (Object)relTypeMap.get(Convert.toStr((Object)UocDicConstant.REL_TYPE.SERVICE_CHARGE)));
        }
        jsonObj.put("orderId", (Object)saleOrderMain.getSaleOrderId());
        rspBo.setJsonObj(jsonObj);
    }

    private List<UocInspOrderItem> getUocInspOrderItems(Long orderId, UocInspOrderDo inspOrderMain, Map<Long, UocSaleOrderItem> saleOrderItemMap) {
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setOrderId(orderId);
        uocInspOrderItemQryBo.setInspOrderId(inspOrderMain.getInspOrderId());
        UocInspOrderDo inspOrderItem = this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
        List<UocInspOrderItem> uocInspOrderItemList = inspOrderItem.getUocInspOrderItemList();
        uocInspOrderItemList.forEach(obj -> {
            UocSaleOrderItem saleOrderItem = (UocSaleOrderItem)((Object)((Object)saleOrderItemMap.get(obj.getSaleOrderItemId())));
            if (null != saleOrderItem) {
                obj.setUnitDigit(saleOrderItem.getUnitDigit());
            }
        });
        return uocInspOrderItemList;
    }

    private UocInspOrderDo getUocInspOrderDo(Long orderId, Long inspOrderId) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(orderId);
        uocInspOrderQryBo.setInspOrderId(inspOrderId);
        return this.iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
    }

    private UocOrderRel getUocOrderRel(Long orderId, Long objId, Integer objType) {
        UocOrderRelQryBo uocOrderRelQryBo = new UocOrderRelQryBo();
        uocOrderRelQryBo.setRelType(UocDicConstant.REL_TYPE.SERVICE_CHARGE);
        uocOrderRelQryBo.setOrderId(orderId);
        uocOrderRelQryBo.setObjId(objId);
        uocOrderRelQryBo.setObjType(objType);
        return this.iUocOrderModel.qryRelInfo(uocOrderRelQryBo);
    }

    private UocSaleOrderDo getUocSaleOrderDo(Long orderId, Long saleOrderId) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(orderId);
        uocSaleOrderDo.setSaleOrderId(saleOrderId);
        return this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
    }

    private List<UocSaleOrderItem> getSaleOrderItemList(IUocEsSyncQryReqBo reqBo, Long saleOrderId) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderId);
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private UocSaleStakeholder getStakeholder(Long stakeholderId) {
        UocSaleStakeholderQryBo uocSaleStakeholderQryBo = new UocSaleStakeholderQryBo();
        uocSaleStakeholderQryBo.setStakeholderId(stakeholderId);
        List<UocSaleStakeholder> uocSaleStakeholders = this.iUocSaleOrderModel.qrySaleOrderStakeholder(uocSaleStakeholderQryBo);
        return uocSaleStakeholders.get(0);
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_ORDER_REL_TYPE");
        pCodes.add("UOC_ORDER_REL_STATUS");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}

