/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfEffectiveQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfEffective;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocCreateInspOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocItPlatformInspItemBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocCreateInspOrderService"})
public class UocCreateInspOrderServiceImpl
implements UocCreateInspOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocCreateInspOrderServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    private static final String EC_IMPORT = "2";
    private static final String SUP_NO = "0";

    @PostMapping(value={"createInspOrder"})
    public UocCreateInspOrderServiceRspBo createInspOrder(@RequestBody UocCreateInspOrderServiceReqBo reqBo) {
        UocCreateInspOrderServiceRspBo rspBo = UocRu.success(UocCreateInspOrderServiceRspBo.class);
        List<UocSaleOrderItem> saleOrderItemInfos = this.getSaleOrderItemInfos(reqBo, reqBo.getInspItemList().stream().map(UocItPlatformInspItemBO::getSaleOrderItemId).distinct().collect(Collectors.toList()));
        this.updateSaleOrderInfo(reqBo, saleOrderItemInfos);
        Long inspOrderId = this.createInspOrder(reqBo, saleOrderItemInfos);
        this.createOrderSettleRelInfo(reqBo, inspOrderId);
        this.updateSaleOrderState(reqBo, saleOrderItemInfos);
        this.submitSaleOrderTask(reqBo);
        return rspBo;
    }

    private void submitSaleOrderTask(UocCreateInspOrderServiceReqBo reqBo) {
        UocOrderTaskInst taskInst = new UocOrderTaskInst();
        taskInst.setObjId(reqBo.getSaleOrderId());
        taskInst.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        List<UocOrderTaskInst> taskInstList = this.iUocSaleOrderModel.qryTaskInstList(taskInst);
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(taskInstList.get(0).getTaskInstId());
        taskBo.setStepId(taskInstList.get(0).getProcState());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(taskInstList.get(0).getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    private void updateSaleOrderState(UocCreateInspOrderServiceReqBo reqBo, List<UocSaleOrderItem> saleOrderItemInfos) {
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(saleOrderItemInfos.get(0).getOrderId());
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateSaleOrderDo.setUpdateTime(new Date());
        updateSaleOrderDo.setUpdateOperName(reqBo.getName());
        BigDecimal purchaseCount = new BigDecimal(SUP_NO);
        BigDecimal acceptanceCount = new BigDecimal(SUP_NO);
        for (UocSaleOrderItem uocSaleOrderItem : saleOrderItemInfos) {
            purchaseCount = purchaseCount.add(uocSaleOrderItem.getPurchaseCount());
            acceptanceCount = acceptanceCount.add(uocSaleOrderItem.getAcceptanceCount());
        }
        BigDecimal outInspCount = new BigDecimal(SUP_NO);
        for (UocItPlatformInspItemBO each : reqBo.getInspItemList()) {
            outInspCount = outInspCount.add(each.getInspCount());
        }
        if (purchaseCount.add(acceptanceCount).compareTo(outInspCount) == 1) {
            updateSaleOrderDo.setSaleOrderState("XS_YS_BFYS");
        } else if (purchaseCount.add(acceptanceCount).compareTo(outInspCount) == 0) {
            updateSaleOrderDo.setSaleOrderState("XS_YS_YS");
        }
        if (StringUtils.isNotEmpty((CharSequence)updateSaleOrderDo.getSaleOrderState())) {
            this.iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleOrderDo);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createOrderSettleRelInfo(UocCreateInspOrderServiceReqBo reqBo, Long inspOrderId) {
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if (null == saleOrderMain) throw new BaseBusinessException("101004", "\u751f\u4ea7\u8ba2\u5355\u7ed3\u7b97\u5173\u8054\u6570\u636e\u5931\u8d25\uff1a\u67e5\u8be2\u9500\u552e\u5355\u5355\u4e3a\u7a7a");
        this.createRelInfo(saleOrderMain.getOrderId(), inspOrderId, UocDicConstant.REL_TYPE.SERVICE_CHARGE);
        if (UocConstant.ModelSettle.MY.equals(saleOrderMain.getModelSettle())) {
            this.createRelInfo(saleOrderMain.getOrderId(), inspOrderId, UocDicConstant.REL_TYPE.COMMON_INVOICE);
            this.createRelInfo(saleOrderMain.getOrderId(), inspOrderId, UocDicConstant.REL_TYPE.UP_INVOICE);
            return;
        } else {
            if (!UocConstant.ModelSettle.CH.equals(saleOrderMain.getModelSettle())) throw new BaseBusinessException("101004", "\u751f\u4ea7\u8ba2\u5355\u7ed3\u7b97\u5173\u8054\u6570\u636e\u5931\u8d25\uff1a\u9519\u8bef\u7684\u7ed3\u7b97\u6a21\u5f0f");
            this.createRelInfo(saleOrderMain.getOrderId(), inspOrderId, UocDicConstant.REL_TYPE.CH_INVOICE);
        }
    }

    private void createRelInfo(Long orderId, Long inspOrderId, Integer relType) {
        UocOrderRel createOrderRel = new UocOrderRel();
        createOrderRel.setId(IdUtil.nextId());
        createOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        createOrderRel.setRelType(relType);
        createOrderRel.setOrderId(orderId);
        createOrderRel.setObjId(inspOrderId);
        createOrderRel.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        this.iUocOrderModel.createRelInfo(createOrderRel);
    }

    private void updateSaleOrderInfo(UocCreateInspOrderServiceReqBo reqBo, List<UocSaleOrderItem> saleOrderItemInfos) {
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(saleOrderItemInfos.get(0).getOrderId());
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateSaleOrderDo.setUpdateOperName(reqBo.getName());
        updateSaleOrderDo.setUpdateTime(new Date());
        HashMap saleItemIdMap = new HashMap();
        Map<Long, UocItPlatformInspItemBO> inspItemBOMap = reqBo.getInspItemList().stream().collect(Collectors.toMap(UocItPlatformInspItemBO::getSaleOrderItemId, e -> e));
        saleOrderItemInfos.forEach(uocSaleOrderItem -> {
            uocSaleOrderItem.setAcceptanceCount(((UocItPlatformInspItemBO)inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId())).getInspCount());
            saleItemIdMap.put(uocSaleOrderItem.getSaleOrderItemId(), uocSaleOrderItem);
        });
        updateSaleOrderDo.setSaleOrderItems(new ArrayList<UocSaleOrderItem>(saleItemIdMap.values()));
        this.iUocSaleOrderModel.modifyBatchItemInspCount(updateSaleOrderDo);
        this.iUocSaleOrderModel.modifyInspSuper(updateSaleOrderDo);
    }

    private List<UocSaleOrderItem> getSaleOrderItemInfos(UocCreateInspOrderServiceReqBo reqBo, List<Long> saleOrderItemIdList) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIdList);
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            return uocSaleOrderDo.getSaleOrderItems();
        }
        throw new BaseBusinessException("101004", "\u83b7\u53d6\u9500\u552e\u660e\u7ec6\u4e3a\u7a7a");
    }

    private String getInspOrderNo(UocCreateInspOrderServiceReqBo reqBo) {
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if (null != saleOrderMain) {
            UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
            uocInspOrderDo.setOrderSource(saleOrderMain.getOrderSource());
            UocInspOrderDo inspOrderNo = this.iUocInspOrderModel.getInspOrderNo(uocInspOrderDo);
            if (null != inspOrderNo) {
                return inspOrderNo.getInspOrderNo();
            }
            throw new BaseBusinessException("101004", "\u751f\u6210\u9a8c\u6536\u5355\u7f16\u53f7\u5931\u8d25");
        }
        throw new BaseBusinessException("101004", "\u751f\u6210\u9a8c\u6536\u5355\u7f16\u53f7\u5931\u8d25\uff0c\u67e5\u8be2\u9500\u552e\u5355\u6570\u636e\u4e3a\u7a7a");
    }

    private Long createInspOrder(UocCreateInspOrderServiceReqBo reqBo, List<UocSaleOrderItem> saleOrderItems) {
        Map<Long, UocSaleOrderItem> uocSaleOrderItemMap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocInspOrderDo createInspOrderDo = new UocInspOrderDo();
        Long inspOrderId = IdUtil.nextId();
        createInspOrderDo.setOrderId(saleOrderItems.get(0).getOrderId());
        createInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        createInspOrderDo.setInspOrderId(inspOrderId);
        createInspOrderDo.setInspOrderNo(this.getInspOrderNo(reqBo));
        createInspOrderDo.setInspOrderState("YS_YS_YS");
        createInspOrderDo.setInspOper(reqBo.getName());
        createInspOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createInspOrderDo.setCreateTime(new Date());
        createInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
        createInspOrderDo.setInspOperPhone(reqBo.getCellphone());
        createInspOrderDo.setTenantId(reqBo.getTenantId());
        ArrayList<UocShipInspRel> uocShipInspRelList = new ArrayList<UocShipInspRel>();
        ArrayList<UocInspOrderItem> uocInspOrderItemList = new ArrayList<UocInspOrderItem>();
        Map<Long, UocItPlatformInspItemBO> inspItemBOMap = reqBo.getInspItemList().stream().collect(Collectors.toMap(UocItPlatformInspItemBO::getSaleOrderItemId, e -> e));
        saleOrderItems.forEach(uocSaleOrderItem -> {
            UocInspOrderItem createInspOrderItem = new UocInspOrderItem();
            createInspOrderItem.setOrderId(uocSaleOrderItem.getOrderId());
            createInspOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
            createInspOrderItem.setInspOrderId(createInspOrderDo.getInspOrderId());
            createInspOrderItem.setInspOrderItemId(IdUtil.nextId());
            createInspOrderItem.setInspCount(((UocItPlatformInspItemBO)inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId())).getInspCount());
            createInspOrderItem.setRemainInspCount(((UocItPlatformInspItemBO)inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId())).getInspCount());
            createInspOrderItem.setInitInspCount(((UocItPlatformInspItemBO)inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId())).getInspCount());
            createInspOrderItem.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
            createInspOrderItem.setUnitName(uocSaleOrderItem.getUnitName());
            createInspOrderItem.setCreateTime(new Date());
            createInspOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
            uocInspOrderItemList.add(createInspOrderItem);
        });
        createInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
        createInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        createInspOrderDo.setAllowChngTime(this.getInspAllowChngTime(reqBo, saleOrderItems.get(0).getOrderId()));
        ArrayList<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<UocOrderAccessory>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            reqBo.getOrderAccessoryBoList().forEach(obj -> {
                UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setOrderId(((UocSaleOrderItem)((Object)((Object)saleOrderItems.get(0)))).getOrderId());
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
                uocOrderAccessory.setObjId(inspOrderId);
                uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.ACCEPTANCE);
                uocOrderAccessory.setAccessoryUrl(obj.getAccessoryUrl());
                uocOrderAccessory.setAccessoryName(obj.getAccessoryName());
                uocOrderAccessoryList.add(uocOrderAccessory);
            });
        }
        createInspOrderDo.setUocOrderAccessoryList(uocOrderAccessoryList);
        BigDecimal inspSaleMoney = BigDecimal.ZERO;
        BigDecimal inspPurchaseMoney = BigDecimal.ZERO;
        for (UocInspOrderItem uocInspOrderItem : uocInspOrderItemList) {
            UocSaleOrderItem saleOrderItem = uocSaleOrderItemMap.get(uocInspOrderItem.getSaleOrderItemId());
            if (null != saleOrderItem.getSalePrice() && null != saleOrderItem.getPurchaseCount()) {
                BigDecimal inspSalFee = saleOrderItem.getSalePrice().multiply(uocInspOrderItem.getInspCount());
                inspSaleMoney = inspSaleMoney.add(inspSalFee);
            }
            if (null == saleOrderItem.getPurchasePrice() || null == saleOrderItem.getPurchaseCount()) continue;
            BigDecimal purSalFee = saleOrderItem.getPurchasePrice().multiply(uocInspOrderItem.getInspCount());
            inspPurchaseMoney = inspPurchaseMoney.add(purSalFee);
        }
        createInspOrderDo.setTotalSaleFee(inspSaleMoney);
        createInspOrderDo.setTotalPurchaseFee(inspPurchaseMoney);
        this.iUocInspOrderModel.createInspOrder(createInspOrderDo);
        return inspOrderId;
    }

    private Date getInspAllowChngTime(UocCreateInspOrderServiceReqBo reqBo, Long orderId) {
        UocSaleOrderQryBo saleOrderQryBo = new UocSaleOrderQryBo();
        saleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        saleOrderQryBo.setOrderId(orderId);
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.qrySaleOrder(saleOrderQryBo);
        UocConfEffectiveQryBo uocConfEffectiveQryBo = new UocConfEffectiveQryBo();
        uocConfEffectiveQryBo.setEffectiveCode("5");
        List rows = this.iUocOrderModel.qryListPageConfEffective(uocConfEffectiveQryBo).getRows();
        Date allowChngTime = null;
        if (ObjectUtil.isNotEmpty((Object)rows)) {
            Map confEffectiveMap = rows.stream().collect(Collectors.toMap(o -> o.getBusinessTypeCode() + o.getSupplierNo(), Function.identity()));
            if (null != saleOrderMain) {
                String key = null;
                key = null != saleOrderMain.getStakeholder() ? saleOrderMain.getOrderSource() + saleOrderMain.getStakeholder().getSupId() : String.valueOf(saleOrderMain.getOrderSource()) + reqBo.getSupId();
                allowChngTime = ObjectUtil.isNotNull(confEffectiveMap.get(key)) ? new Date(((UocConfEffective)confEffectiveMap.get(key)).getAging()) : new Date(((UocConfEffective)confEffectiveMap.get(saleOrderMain.getOrderSource() + SUP_NO)).getAging());
            } else {
                allowChngTime = new Date(((UocConfEffective)confEffectiveMap.get("20")).getAging());
            }
        }
        return allowChngTime;
    }
}

