/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocOrderSyncCheckStatusService;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSyncCheckStatusReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSyncCheckStatusRspBo;
import com.tydic.dyc.oc.transactionservice.UocOrderSyncCheckStatusTransaction;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocOrderSyncCheckStatusService"})
public class UocOrderSyncCheckStatusServiceImpl
implements UocOrderSyncCheckStatusService {
    private static final Logger log = LoggerFactory.getLogger(UocOrderSyncCheckStatusServiceImpl.class);
    @Autowired
    private UocOrderSyncCheckStatusTransaction uocOrderSyncCheckStatusTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealSyncCheckStatus"})
    public UocOrderSyncCheckStatusRspBo dealSyncCheckStatus(@RequestBody UocOrderSyncCheckStatusReqBo reqBo) {
        UocOrderSyncCheckStatusRspBo rspBo = this.uocOrderSyncCheckStatusTransaction.dealSyncCheckStatus(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return UocRu.success(UocOrderSyncCheckStatusRspBo.class);
    }

    private void syncEs(UocOrderSyncCheckStatusReqBo reqBo, UocOrderSyncCheckStatusRspBo rspBo) {
        log.info("\u8ba2\u5355{}\u5bf9\u8d26\u72b6\u6001\u66f4\u65b0\u540c\u6b65\u9a8c\u6536\u5355{},", (Object)rspBo.getOrderId(), (Object)reqBo.getObjId());
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
        inspBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
        inspBo.setOrderId(rspBo.getOrderId());
        inspBo.setObjId(reqBo.getObjId());
        inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(inspBo);
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

