/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.UocUpdateSaleOrderReturnPayResultService;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderReturnPayResultReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderReturnPayResultRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocUpdateSaleOrderReturnPayResultService"})
public class UocUpdateSaleOrderReturnPayResultServiceImpl
implements UocUpdateSaleOrderReturnPayResultService {
    private static final Logger log = LoggerFactory.getLogger(UocUpdateSaleOrderReturnPayResultServiceImpl.class);
    protected static final List<String> pCodeList = ListUtil.list((boolean)false);
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    public static final String CANCLE_RETURN = "1";
    @Autowired
    private IUocAfOrderModel afOrderModel;

    @PostMapping(value={"updateReturnPayResult"})
    public UocUpdateSaleOrderReturnPayResultRspBO updateReturnPayResult(@RequestBody UocUpdateSaleOrderReturnPayResultReqBO reqBO) {
        UocUpdateSaleOrderReturnPayResultRspBO rsp = UocRu.success(UocUpdateSaleOrderReturnPayResultRspBO.class);
        if (reqBO.getReturnPayResult().booleanValue()) {
            Integer payType = UocDicConstant.PAY_TYPE.PAY_BY_PERIOD;
            Long orderId = null;
            if (null != reqBO.getFscShouldPayId()) {
                UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
                uocOrderShouldPay.setFscShouldPayId(reqBO.getFscShouldPayId());
                UocOrderShouldPay result = this.iUocPayOrderModel.getOrderShouldPay(uocOrderShouldPay);
                if (null == result) {
                    throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u8be5\u5e94\u4ed8\u5355");
                }
                payType = result.getPayType();
                orderId = result.getOrderId();
                UocOrderShouldPay set = new UocOrderShouldPay();
                set.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.PAY_COMPLETED);
                if (null == result.getBackAmount()) {
                    result.setBackAmount(BigDecimal.ZERO);
                }
                if (null != reqBO.getPayBackAmount()) {
                    set.setBackAmount(reqBO.getPayBackAmount().add(result.getBackAmount()));
                }
                if (set.getBackAmount().compareTo(result.getPaidAmount()) > 0) {
                    throw new BaseBusinessException("100001", "\u9000\u6b3e\u603b\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u603b\u91d1\u989d");
                }
                set.setUpdateTime(new Date());
                UocOrderShouldPay where = new UocOrderShouldPay();
                where.setFscShouldPayId(reqBO.getFscShouldPayId());
                this.iUocPayOrderModel.modifyOrderShouldPayMain(set, where);
            }
            Integer saleOrderPayState = this.jargeSaleOrderPayState(reqBO.getSaleOrderId(), payType, orderId);
            if (CANCLE_RETURN.equals(reqBO.getRefundNode()) && !reqBO.getRealPayResult().booleanValue()) {
                saleOrderPayState = UocDicConstant.PAY_STATE.FAILED;
            }
            String payStateStr = null;
            Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE")) && ObjectUtil.isNotEmpty((Object)saleOrderPayState)) {
                payStateStr = dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE").get(saleOrderPayState.toString());
            }
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
            log.info("\u8ba2\u5355\u72b6\u6001\uff1a" + saleOrderPayState);
            uocSaleOrderDo.setPayState(saleOrderPayState);
            this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
            if (null != reqBO.getRefundObjId() && 3 == reqBO.getRefundObjType()) {
                this.doModifyAfOrderPayState(reqBO.getSaleOrderId(), reqBO.getRefundObjId(), dictionaryMap);
            }
            this.syncEs(reqBO.getSaleOrderId(), saleOrderPayState, payStateStr);
        }
        return rsp;
    }

    private void doModifyAfOrderPayState(Long saleOrderId, Long refundObjId, Map<String, Map<String, String>> dictionaryMap) {
        Integer payState = UocDicConstant.PAY_AFTER_STATE.ALL_REFUNDED;
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrderId);
        uocSaleOrderPayConfQryBo.setUserType(UocDicConstant.USE_TYPE.PUR);
        List<UocSaleOrderPayConf> saleOrderPayConfList = this.iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
        if (CollectionUtils.isEmpty(saleOrderPayConfList)) {
            throw new BaseBusinessException("100001", "\u91c7\u8d2d\u4fa7\u652f\u4ed8\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a");
        }
        if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(saleOrderPayConfList.get(0).getPayType())) {
            payState = UocDicConstant.PAY_AFTER_STATE.AMOUNT__DUE_UPDATED;
        }
        String payStateStr = null;
        if (ObjectUtil.isNotEmpty(dictionaryMap.get("PAY_AFTER_STATE"))) {
            payStateStr = dictionaryMap.get("PAY_AFTER_STATE").get(payState.toString());
        }
        UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
        uocAfOrderDo.setAfOrderId(refundObjId);
        uocAfOrderDo.setPayState(payState);
        uocAfOrderDo.setOrderId(saleOrderPayConfList.get(0).getOrderId());
        this.afOrderModel.modifyAfOrderState(uocAfOrderDo);
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        uocEsSyncManagerSaveDataReqBo.setObjId(refundObjId);
        uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getAfOrderIndex());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("payState", (Object)payState);
        jsonObj.put("payStateStr", (Object)payStateStr);
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        log.info("\u66f4\u65b0\u552e\u540e\u5355\u652f\u4ed8\u72b6\u6001uocEsSyncManagerSaveDataReqBo\u4e3a{}", (Object)JSONObject.toJSONString((Object)uocEsSyncManagerSaveDataReqBo));
        this.uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

    private Integer jargeSaleOrderPayState(Long saleOrderId, Integer payType, Long orderId) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderId);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (ObjectUtil.isEmpty(saleOrderItemList)) {
            throw new BaseBusinessException("100001", "\u9500\u552e\u660e\u7ec6\u67e5\u8be2\u4e3a\u7a7a");
        }
        Integer saleOrderPayState = UocDicConstant.PAY_STATE.REFUSED;
        for (UocSaleOrderItem bo : saleOrderItemList) {
            BigDecimal returnPayCount = bo.getRefuseCount().add(bo.getReturnCount());
            if (bo.getSendCount().compareTo(returnPayCount) <= 0) continue;
            saleOrderPayState = UocDicConstant.PAY_STATE.PART_REFUSED;
            break;
        }
        if (UocDicConstant.PAY_STATE.REFUSED.equals(saleOrderPayState) && !UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(payType)) {
            UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
            uocOrderShouldPay.setOrderId(orderId);
            List<UocOrderShouldPay> resultShouldPay = this.iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
            if (CollectionUtils.isEmpty(resultShouldPay)) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u5e94\u4ed8\u660e\u7ec6\u96c6\u5408\u4e3a\u7a7a\uff01");
            }
            for (UocOrderShouldPay bo : resultShouldPay) {
                if (null == bo.getBackAmount() || null == bo.getPaidAmount()) {
                    saleOrderPayState = UocDicConstant.PAY_STATE.PART_REFUSED;
                    break;
                }
                if (bo.getBackAmount().compareTo(bo.getPaidAmount()) >= 0) continue;
                saleOrderPayState = UocDicConstant.PAY_STATE.PART_REFUSED;
                break;
            }
        }
        return saleOrderPayState;
    }

    private void syncEs(Long objId, Integer payState, String payStateStr) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        uocEsSyncManagerSaveDataReqBo.setObjId(objId);
        uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("payState", (Object)payState);
        jsonObj.put("payStateStr", (Object)payStateStr);
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        log.info("\u66f4\u65b0\u9500\u552e\u5355\u652f\u4ed8\u72b6\u6001uocEsSyncManagerSaveDataReqBo\u4e3a{}", (Object)JSONObject.toJSONString((Object)uocEsSyncManagerSaveDataReqBo));
        this.uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

    private static void initialize() {
        pCodeList.add("UOC_SALE_ORDER_PAY_STATE");
        pCodeList.add("PAY_AFTER_STATE");
    }

    static {
        UocUpdateSaleOrderReturnPayResultServiceImpl.initialize();
    }
}

