package com.tydic.dyc.oc.model.order;

import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.service.domainservice.bo.UocSupplierInfoBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocOrder
 * 说明:订单领域对象
 * 时间:2022-02-21 12:29
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocOrderDo extends BaseUmcReqBo {
    private static final long serialVersionUID = -6770269812694625326L;

    @DocField(value = "订单id")
    private Long orderId;

    @DocField(value = "父订单id")
    private Long upperOrderId;

    @DocField(value = "订单编码")
    private String orderNo;

    @DocField(value = "外部订单编码")
    private String orderNoExt;

    @DocField(value = "订单名称")
    private String orderName;

    @DocField(value = "下单系统")
    private String orderSystem;

    @DocField(value = "订单级别             1 个人订单             2 企业订单")
    private Integer orderLevel;

    @DocField(value = "订单类型 :1.采购电商")
    private Integer orderType;

    @DocField(value = "支付类型")
    private Integer payMod;

    @DocField(value = "支付方式")
    private String payType;

    @DocField(value = "支付状态")
    private String payState;

    @DocField(value = "需要开票标识 0不开票 1需要开票")
    private Integer needInvoiceTag;

    @DocField(value = "订单状态")
    private String orderState;

    @DocField(value = "流转状态")
    private String procState;

    @DocField(value = "订单说明")
    private String orderDesc;

    @DocField(value = "销售金额")
    private BigDecimal totalSaleFee;

    @DocField(value = "采购金额")
    private BigDecimal totalPurchaseFee;

    @DocField(value = "优惠金额")
    private BigDecimal totalActShareFee;

    @DocField(value = "收货地址ID")
    private Long contactId;

    @DocField(value = "运费")
    private BigDecimal totalTransFee;

    @DocField(value = "实付金额")
    private BigDecimal usedFee;

    @DocField(value = "实付积分")
    private BigDecimal usedIntegral;

    @DocField(value = "竣工标志       0 在途         1 竣工          ")
    private Integer finishFlag;

    @DocField(value = "租户ID")
    private String tenantId;

    @DocField(value = "送货时间")
    private Date sendTime;

    @DocField(value = "创建时间")
    private Date createTime;

    @DocField(value = "创建工号")
    private String createOperId;

    @DocField(value = "创建人名称")
    private String createOperName;

    @DocField(value = "更新时间")
    private Date updateTime;

    @DocField(value = "更新工号")
    private String updateOperId;

    @DocField(value = "更新时间")
    private String updateOperName;

    @DocField(value = "撤单时间")
    private Date cancelTime;

    @DocField(value = "撤单工号")
    private String cancelOperId;

    @DocField(value = "撤单原因")
    private String cancelReason;

    @DocField(value = "撤单标志:1 已撤单             0 未撤单")
    private Integer cancelFlag;

    @DocField(value = "备注")
    private String remark;

    @DocField(value = "竣工时间")
    private Date finishTime;

    @DocField(value = "逾期时间")
    private Date expTime;

    @DocField(value = "采购方账套id")
    private String purAccount;

    @DocField(value = "采购方账套名称")
    private String purAccountName;

    @DocField(value = "采购方联系人")
    private String purContactName;

    @DocField(value = "采购方联系人电话")
    private String purMobile;

    @DocField(value = "需方联系人名称")
    private String purNeedName;

    @DocField(value = "需方联系电话")
    private String purNeedMobile;

    @DocField("运营机构信息")
    private UocOrderOperating operating;

    @DocField("订单扩展")
    private List<UocOrderMap> orderExt;

    @DocField("发票信息")
    private UocOrdInvoice uocOrdInvoice;

    @DocField("订单明细")
    private List<UocOrderItem> orderItems;

    @DocField("收货人地址信息")
    private UocOrdLogisticsRela receiverAddress;

    @DocField("发票地址信息")
    private UocOrdLogisticsRela invoiceAddress;

    @DocField("订单附件信息")
    private List<UocOrderAccessory> accessoryList;
    @DocField(value = "删除标志1已删除")
    private Integer delTag;

    /**
     * 供应商信息
     */
    private List<UocSupplierInfoBo> supplierBos;
    /**
     * 用户类型：1 外部个人 2 外部企业 3内部个人 4 内部企业
     */
    private String userType;

    /**
     * 二级SUB
     */
    private Long secondOrgId;
    /**
     * 租户id
     */
    private Long sysTenantId;
    /**
     * 租户名称
     */
    private String sysTenantName;

}
