package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.agreeorder.UocOrderAgreementDo;
import com.tydic.dyc.oc.model.agreeorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.repository.UocAgreementOrderRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.UocOrderAgreementPo;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocAgreementOrderRepositoryImpl
 * 说明:协议单
 * 时间:2022/2/21 18:54
 * 作者:罗有
 */

@Service
public class UocAgreementOrderRepositoryImpl implements UocAgreementOrderRepository {

    @Autowired
    private UocOrderAgreementMapper uocOrderAgreementMapper;

    @Override
    public UocOrderAgreementDo getAgreementOrderBy(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        UocOrderAgreementPo uocOrderAgreementPo = uocOrderAgreementMapper.getModelBy(UocRu.js(uocOrderAgreementQryBo, UocOrderAgreementPo.class));
        return null != uocOrderAgreementPo ? UocRu.js(uocOrderAgreementPo, UocOrderAgreementDo.class) : null;
    }

    @Override
    public List<UocOrderAgreementDo> getAgreementOrderList(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        List<UocOrderAgreementPo> list = uocOrderAgreementMapper.getList(UocRu.js(uocOrderAgreementQryBo, UocOrderAgreementPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocOrderAgreementDo.class) : new ArrayList<>();
    }
}
