package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.conforder.qrybo.UocConfTabOrdStateQryBo;
import com.tydic.dyc.oc.model.conforder.sub.UocConfTabOrdState;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocCommonRepositoryImpl
 * 说明:通用
 * 时间:2022/2/25 19:38
 * 作者:罗有
 */

@Service
public class UocCommonRepositoryImpl implements UocCommonRepository {
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;

    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;

    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;

    @Autowired
    private UocOrderStateChgLogMapper uocOrderStateChgLogMapper;

    @Autowired
    private UocOrderBusiOperRecordMapper uocOrderBusiOperRecordMapper;

    @Autowired
    private UocConfTabOrdStateMapper uocConfTabOrdStateMapper;

    @Override
    public void addBatchOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList) {
        if (!CollectionUtils.isEmpty(uocOrderAccessoryList)) {
            uocOrderAccessoryMapper.insertBatch(UocRu.jsl(uocOrderAccessoryList, UocOrderAccessoryPo.class));
        }
    }

    @Override
    public void updateToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        for (UocOrderTaskInst uocOrderTaskInst : uocOrderTaskInstList) {
            UocOrderTaskInstPo updateSetPo = new UocOrderTaskInstPo();
            updateSetPo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);

            UocOrderTaskInstPo updateWherePo = new UocOrderTaskInstPo();
            updateWherePo.setOrderId(uocOrderTaskInst.getOrderId());
            updateWherePo.setTaskInstId(uocOrderTaskInst.getTaskInstId());

            uocOrderTaskInstMapper.updateBy(updateSetPo, updateWherePo);
        }

    }

    @Override
    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            uocOrderTaskInstMapper.insertBatch(UocRu.jsl(saveTaskList, UocOrderTaskInstPo.class));
        }
    }

    @Override
    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        uocOrderProcInstMapper.insert(UocRu.js(inst, UocOrderProcInstPo.class));
        return inst;
    }

    @Override
    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return UocRu.jsl(uocOrderProcInstMapper.getList(UocRu.js(inst, UocOrderProcInstPo.class)), UocOrderProcInst.class);
    }

    @Override
    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        if (ObjectUtil.isNotEmpty(dealList)) {
            uocOrderTaskDealMapper.insertBatch(UocRu.jsl(dealList, UocOrderTaskDealPo.class));
        }
    }

    @Override
    public UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog) {
        if (ObjectUtil.isNotEmpty(uocOrderStateChgLog)) {
            uocOrderStateChgLogMapper.insert(UocRu.js(uocOrderStateChgLog, UocOrderStateChgLogPo.class));
        }
        return uocOrderStateChgLog;
    }

    @Override
    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        if (ObjectUtil.isNotEmpty(taskInst)) {
            return UocRu.jsl(uocOrderTaskInstMapper.getList(UocRu.js(taskInst, UocOrderTaskInstPo.class)), UocOrderTaskInst.class);
        } else {
            return new ArrayList<>();
        }
    }

    @Override
    public UocOrderProcInst updateProInst(UocOrderProcInst inst) {
        UocOrderProcInstPo set = UocRu.js(inst, UocOrderProcInstPo.class);
        UocOrderProcInstPo where = new UocOrderProcInstPo();
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        uocOrderProcInstMapper.updateBy(set, where);
        return inst;
    }

    @Override
    public void saveOperRecord(List<UocOrderBusiOperRecord> recordList) {
        List<UocOrderBusiOperRecordPo> recordPoList = UocRu.jsl(recordList, UocOrderBusiOperRecordPo.class);
        uocOrderBusiOperRecordMapper.insertBatch(recordPoList);
    }

    @Override
    public List<UocConfTabOrdState> qryConfTabOrdStateList(UocConfTabOrdStateQryBo qryBo) {
        List<UocConfTabOrdStatePo> list = uocConfTabOrdStateMapper.getList(UocRu.js(qryBo, UocConfTabOrdStatePo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list,UocConfTabOrdState.class) : new ArrayList<>();
    }

}
