package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplItemMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplItemMap;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderMap;
import com.tydic.dyc.oc.repository.UocImplOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocImplItemMapMapper;
import com.tydic.dyc.oc.repository.dao.UocImplOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocImplOrderMapMapper;
import com.tydic.dyc.oc.repository.dao.UocImplOrderMapper;
import com.tydic.dyc.oc.repository.po.UocImplItemMapPo;
import com.tydic.dyc.oc.repository.po.UocImplOrderItemPo;
import com.tydic.dyc.oc.repository.po.UocImplOrderMapPo;
import com.tydic.dyc.oc.repository.po.UocImplOrderPo;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


/**
 * 标题:UocImplOrderRepositoryImpl
 * 说明:执行单
 * 时间:2022/2/21 18:52
 * 作者:罗有
 */
@Service
public class UocImplOrderRepositoryImpl implements UocImplOrderRepository {

    @Autowired
    private UocImplOrderItemMapper uocImplOrderItemMapper;

    @Autowired
    private UocImplOrderMapper uocImplOrderMapper;

    @Autowired
    private UocImplOrderMapMapper uocImplOrderMapMapper;

    @Autowired
    private UocImplItemMapMapper uocImplItemMapMapper;

    /**
     * 批量更新执行单明细发货数量
     *
     * @param uocImplOrderDo 执行单do
     */
    @Override
    public void modifyBatchItemSendCount(UocImplOrderDo uocImplOrderDo) {
        if (!CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            uocImplOrderItemMapper.updateBatchItemSendCount(UocRu.jsl(uocImplOrderDo.getUocImplOrderItemList(), UocImplOrderItemPo.class), UocRu.js(uocImplOrderDo, UocImplOrderItemPo.class));
        }
    }

    @Override
    public void modifyArrivaImplOrderItem(UocImplOrderDo uocImplOrderDo) {
        if (null != uocImplOrderDo && !CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            uocImplOrderItemMapper.updateItemArriveCount(UocRu.jsl(uocImplOrderDo.getUocImplOrderItemList(), UocImplOrderItemPo.class), UocRu.js(uocImplOrderDo, UocImplOrderItemPo.class));
        }
    }

    @Override
    public void modifyRefuseImplOrderItem(UocImplOrderDo uocImplOrderDo) {
        if (null != uocImplOrderDo && !CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            uocImplOrderItemMapper.updateItemRefuseCount(UocRu.jsl(uocImplOrderDo.getUocImplOrderItemList(), UocImplOrderItemPo.class), UocRu.js(uocImplOrderDo, UocImplOrderItemPo.class));
        }
    }

    @Override
    public UocImplOrderDo getListImplOrderItem(UocImplOrderItemQryBo uocImplOrderItemQryBo) {
        UocImplOrderItemPo uocImplOrderItemPo = UocRu.js(uocImplOrderItemQryBo, UocImplOrderItemPo.class);
        List<UocImplOrderItemPo> uocImplOrderItemPoList = uocImplOrderItemMapper.getList(uocImplOrderItemPo);
        UocImplOrderDo uocImplOrderDo = new UocImplOrderDo();
        uocImplOrderDo.setUocImplOrderItemList(ObjectUtil.isNotEmpty(uocImplOrderItemPoList) ?
                UocRu.jsl(uocImplOrderItemPoList, UocImplOrderItem.class) : new ArrayList<>());
        return uocImplOrderDo;
    }

    @Override
    public List<UocImplItemMap> getImpOrderItemMapList(UocImplItemMapQryBo uocImplItemMapQryBo) {
        List<UocImplItemMapPo> uocImplItemMapPoList = uocImplItemMapMapper.getList(UocRu.js(uocImplItemMapQryBo, UocImplItemMapPo.class));
        return ObjectUtil.isNotEmpty(uocImplItemMapPoList) ? UocRu.jsl(uocImplItemMapPoList,UocImplItemMap.class) : new ArrayList<>();
    }

    @Override
    public UocImplOrderDo saveImplOrder(UocImplOrderDo implOrderDo) {
        //保存执行单
        uocImplOrderMapper.insert(UocRu.js(implOrderDo, UocImplOrderPo.class));

        //保存扩展
        if (ObjectUtil.isNotEmpty(implOrderDo.getUocImplOrderMapList())) {
            uocImplOrderMapMapper.insertBatch(UocRu.jsl(implOrderDo.getUocImplOrderMapList(), UocImplOrderMapPo.class));
        }

        //保存明细
        uocImplOrderItemMapper.insertBatch(UocRu.jsl(implOrderDo.getUocImplOrderItemList(), UocImplOrderItemPo.class));

        return implOrderDo;
    }

    @Override
    public void modifyBatchItemInspCount(UocImplOrderDo implOrderDo) {
        if (null != implOrderDo) {
            uocImplOrderItemMapper.updateBatchItemInspCount(UocRu.jsl(implOrderDo.getUocImplOrderItemList(), UocImplOrderItemPo.class), UocRu.js(implOrderDo, UocImplOrderItemPo.class));
        }
    }


    @Override
    public UocImplOrderItem qryListImplOrderItemCount(UocImplOrderItemQryBo qryBo) {
        UocImplOrderItemPo uocImplOrderItemPo = uocImplOrderItemMapper.getModelBy(UocRu.js(qryBo, UocImplOrderItemPo.class));
        return uocImplOrderItemPo != null ? UocRu.js(uocImplOrderItemPo, UocImplOrderItem.class) : new UocImplOrderItem();
    }

    @Override
    public UocImplOrderDo getImplOrderMain(UocImplOrderQryBo uocImplOrderQryBo) {
        UocImplOrderPo uocImplOrderPo = new UocImplOrderPo();
        uocImplOrderPo.setImplOrderId(uocImplOrderQryBo.getImplOrderId());
        uocImplOrderPo = uocImplOrderMapper.getModelBy(uocImplOrderPo);
        return ObjectUtil.isNotEmpty(uocImplOrderPo) ? UocRu.js(uocImplOrderPo, UocImplOrderDo.class) : null;
    }

    @Override
    public List<UocImplOrderMap> getImplOrderMapList(UocImplOrderMapQryBo uocImplOrderMapQryBo) {
        List<UocImplOrderMapPo> uocImplOrderMapPoList = uocImplOrderMapMapper.getList(UocRu.js(uocImplOrderMapQryBo, UocImplOrderMapPo.class));
        return ObjectUtil.isNotEmpty(uocImplOrderMapPoList) ? UocRu.jsl(uocImplOrderMapPoList, UocImplOrderMap.class) : new ArrayList<>();
    }

    @Override
    public UocImplOrderDo getCollectCount(UocImplOrderItemQryBo uocImplOrderItemQryBo) {
        UocImplOrderItemPo uocImplOrderItemPo = uocImplOrderItemMapper.getCollectCount(UocRu.js(uocImplOrderItemQryBo, UocImplOrderItemPo.class));
        UocImplOrderItem uocImplOrderItem = UocRu.js(uocImplOrderItemPo, UocImplOrderItem.class);
        UocImplOrderDo uocImplOrderDo = new UocImplOrderDo();
        uocImplOrderDo.setUocImplOrderItemList(Collections.singletonList(uocImplOrderItem));
        return uocImplOrderDo;
    }

    @Override
    public List<UocImplOrderDo> getListImplOrder(UocImplOrderQryBo uocImplOrderQryBo) {
        List<UocImplOrderPo> uocImplOrderPoList = uocImplOrderMapper.getList(UocRu.js(uocImplOrderQryBo, UocImplOrderPo.class));
        return UocRu.jsl(uocImplOrderPoList, UocImplOrderDo.class);
    }

    @Override
    public void modifyBatchItemChngingCount(UocImplOrderDo uocImplOrderDo) {
        if (null != uocImplOrderDo && !CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            uocImplOrderItemMapper.updateBatchItemChngingCount(UocRu.jsl(uocImplOrderDo.getUocImplOrderItemList(), UocImplOrderItemPo.class), UocRu.js(uocImplOrderDo, UocImplOrderItemPo.class));
        }
    }

    @Override
    public void modifyBatchItemReturnCountConfirm(UocImplOrderDo uocImplOrderDo) {
        if (null != uocImplOrderDo){
            uocImplOrderItemMapper.updateBatchItemReturnCountByChngCount(UocRu.js(uocImplOrderDo, UocImplOrderItemPo.class));
        }
    }

    @Override
    public void modifyBatchItemChngCountRefuse(UocImplOrderDo uocImplOrderDo) {
        if (null != uocImplOrderDo){
            uocImplOrderItemMapper.updateBatchItemChngCountZero(UocRu.js(uocImplOrderDo, UocImplOrderItemPo.class));
        }
    }
}
