package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocShipOrderItemPo
 * 说明:发货明细
 * 时间:2022-03-09 14:09
 * 作者:罗有
 **/
@Data
public class UocShipOrderItemPo implements Serializable {
	private static final long serialVersionUID = 683224372238930221L;

	@DocField(value = "发货明细id")
	private Long shipOrderItemId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "执行明细id")
	private Long implOrderItemId;

	@DocField(value = "销售明细id")
	private Long saleOrderItemId;

	@DocField(value = "执行单id")
	private Long implOrderId;

	@DocField(value = "发货单id")
	private Long shipOrderId;

	@DocField(value = "明细状态")
	private String shipItemState;

	@DocField(value = "计量单位")
	private String unitName;

	@DocField(value = "发货数量")
	private BigDecimal sendCount;

	@DocField(value = "到货数量             供应商到货登记时预留字段")
	private BigDecimal arriveCount;

	@DocField(value = "拒收数量")
	private BigDecimal refuseCount;

	@DocField(value = "退货数量")
	private BigDecimal returnCount;

	@DocField(value = "验收数量")
	private BigDecimal inspCount;

	@DocField(value = "异常变更在途数量，表示异常供应商确认之前的记录数量")
	private BigDecimal chngingCount;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "扩展字段")
	private String extField1;

	@DocField(value = "扩展字段")
	private String extField2;

	@DocField(value = "扩展字段")
	private String extField3;

	@DocField(value = "扩展字段")
	private String extField4;

	@DocField(value = "扩展字段")
	private String extField5;

	@DocField(value = "排序")
	private String orderBy;

	@DocField(value = "发货单IDList")
	private List<Long> shipOrderIdList;

	@DocField(value = "发货单明细IDList")
	private List<Long> shipOrderItemIdList;

	@DocField(value = "订单IDList")
	private List<Long> orderIdList;

	@DocField(value = "销售单明细IDList")
	private List<Long> saleOrderItemIdList;
}
