package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.DMsgPoolPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:DMsgPoolMapper
 * 说明:外部消息池表
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface DMsgPoolMapper {

	/**
	 * 插入单条数据
	 *
	 * @param dMsgPoolPo 参数对象
	 * @return int 影响数量
	 */
	int insert(DMsgPoolPo dMsgPoolPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param dMsgPoolPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(DMsgPoolPo dMsgPoolPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") DMsgPoolPo set, @Param("where") DMsgPoolPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param dMsgPoolPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(DMsgPoolPo dMsgPoolPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param dMsgPoolPo 参数对象
	 * @return DMsgPoolPo 结果对象
	 */
	DMsgPoolPo getModelBy(DMsgPoolPo dMsgPoolPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param dMsgPoolPo 参数对象
	 * @return List<DMsgPoolPo> 结果对象
	 */
	List<DMsgPoolPo> getList(DMsgPoolPo dMsgPoolPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param dMsgPoolPo 参数对象
	 * @param page 分页参数
	 * @return List<DMsgPoolPo> 结果对象
	 */
	List<DMsgPoolPo> getListPage(DMsgPoolPo dMsgPoolPo, Page<DMsgPoolPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<DMsgPoolPo> list);

}
