package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocSaleOrderPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocSaleOrderMapper
 * 说明:销售订单
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocSaleOrderMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocSaleOrderPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocSaleOrderPo uocSaleOrderPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocSaleOrderPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocSaleOrderPo uocSaleOrderPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocSaleOrderPo set, @Param("where") UocSaleOrderPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocSaleOrderPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocSaleOrderPo uocSaleOrderPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocSaleOrderPo 参数对象
	 * @return UocSaleOrderPo 结果对象
	 */
	UocSaleOrderPo getModelBy(UocSaleOrderPo uocSaleOrderPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocSaleOrderPo 参数对象
	 * @return List<UocSaleOrderPo> 结果对象
	 */
	List<UocSaleOrderPo> getList(UocSaleOrderPo uocSaleOrderPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocSaleOrderPo 参数对象
	 * @param page 分页参数
	 * @return List<UocSaleOrderPo> 结果对象
	 */
	List<UocSaleOrderPo> getListPage(UocSaleOrderPo uocSaleOrderPo, Page<UocSaleOrderPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocSaleOrderPo> list);

}
