package com.tydic.dyc.oc.repository.impl;

import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderMap;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.repository.UocInspOrderRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocInspOrderRepositoryImpl
 * 说明:验收单
 * 时间:2022/2/21 18:53
 * 作者:罗有
 */

@Service
public class UocInspOrderRepositoryImpl implements UocInspOrderRepository {
    @Autowired
    private UocInspOrderMapper uocInspOrderMapper;
    @Autowired
    private UocInspOrderItemMapper uocInspOrderItemMapper;
    @Autowired
    private UocInspOrderMapMapper uocInspOrderMapMapper;
    @Autowired
    private UocInspItemMapMapper uocInspItemMapMapper;
    @Autowired
    private UocShipInspRelMapper uocShipInspRelMapper;

    @Override
    public void createInspOrder(UocInspOrderDo uocInspOrderDo) {
        uocInspOrderMapper.insert(UocRu.js(uocInspOrderDo, UocInspOrderPo.class));
        uocInspOrderItemMapper.insertBatch(UocRu.jsl(uocInspOrderDo.getUocInspOrderItemList(), UocInspOrderItemPo.class));
        uocShipInspRelMapper.insertBatch(UocRu.jsl(uocInspOrderDo.getUocShipInspRelList(), UocShipInspRelPo.class));
        if (!CollectionUtils.isEmpty(uocInspOrderDo.getExtParallelBoList())) {
            uocInspOrderMapMapper.insertBatch(UocRu.jsl(uocInspOrderDo.getExtParallelBoList(), UocInspOrderMapPo.class));
        }
        List<UocInspItemMapPo> inspItemMapPoList = new ArrayList<>();
        uocInspOrderDo.getUocInspOrderItemList().forEach(uocInspOrderItem -> {
            if (!CollectionUtils.isEmpty(uocInspOrderItem.getItemExtParallelBoList())) {
                inspItemMapPoList.addAll(UocRu.jsl(uocInspOrderItem.getItemExtParallelBoList(), UocInspItemMapPo.class));
            }
        });
        if (!CollectionUtils.isEmpty(inspItemMapPoList)) {
            uocInspItemMapMapper.insertBatch(inspItemMapPoList);
        }
    }

    @Override
    public UocInspOrderDo getInspOrderMain(UocInspOrderQryBo uocInspOrderQryBo) {
        UocInspOrderPo uocInspOrderPo = new UocInspOrderPo();
        uocInspOrderPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
        uocInspOrderPo = uocInspOrderMapper.getModelBy(uocInspOrderPo);
        UocInspOrderDo uocInspOrderDo = UocRu.js(uocInspOrderPo, UocInspOrderDo.class);
        if (null != uocInspOrderPo) {
            UocInspOrderMapPo uocInspOrderMapPo = new UocInspOrderMapPo();
            uocInspOrderMapPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
            List<UocInspOrderMapPo> uocInspOrderMapPoList = uocInspOrderMapMapper.getList(uocInspOrderMapPo);
            uocInspOrderDo.setExtParallelBoList(UocRu.jsl(uocInspOrderMapPoList, UocInspOrderMap.class));

            UocShipInspRelPo uocShipInspRelPo = new UocShipInspRelPo();
            uocShipInspRelPo.setInspOrderId(uocInspOrderQryBo.getInspOrderId());
            List<UocShipInspRelPo> uocShipInspRelPoList = uocShipInspRelMapper.getList(uocShipInspRelPo);
            uocInspOrderDo.setUocShipInspRelList(UocRu.jsl(uocShipInspRelPoList, UocShipInspRel.class));
        }
        return uocInspOrderDo;
    }

    @Override
    public UocInspOrderDo getListInspOrderItem(UocInspOrderItemQryBo uocInspOrderItemQryBo) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        List<UocInspOrderItemPo> uocInspOrderItemPoList = uocInspOrderItemMapper.getList(UocRu.js(uocInspOrderItemQryBo, UocInspOrderItemPo.class));
        uocInspOrderDo.setUocInspOrderItemList(UocRu.jsl(uocInspOrderItemPoList, UocInspOrderItem.class));
//        List<Long> inspItemOrderIdList = uocInspOrderItemPoList.stream().map(UocInspOrderItemPo::getImplOrderItemId).filter(Objects::nonNull).collect(Collectors.toList());
//        if (!CollectionUtils.isEmpty(inspItemOrderIdList)) {
//            UocInspItemMapPo uocInspItemMapPo = new UocInspItemMapPo();
//            uocInspItemMapPo.setInspOrderItemIdList(inspItemOrderIdList);
//            List<UocInspItemMapPo> uocInspItemMapPoList = uocInspItemMapMapper.getList(uocInspItemMapPo);
//            if (!CollectionUtils.isEmpty(uocInspItemMapPoList)) {
//                ConcurrentMap<Long, List<UocInspItemMapPo>> uocInspItemMap =
//                        uocInspItemMapPoList.stream().collect(Collectors.groupingByConcurrent(UocInspItemMapPo::getInspOrderItemId));
//                uocInspOrderDo.getUocInspOrderItemList().forEach(uocInspOrderItem ->
//                        uocInspOrderItem.setItemExtParallelBoList(UocRu.jsl(uocInspItemMap.get(uocInspOrderItem.getInspOrderItemId()), UocInspItemMap.class)));
//            }
//        }
        return uocInspOrderDo;
    }

    @Override
    public List<UocInspOrderDo> getListInspOrder(UocInspOrderQryBo uocInspOrderQryBo) {
        List<UocInspOrderPo> uocInspOrderPoList = uocInspOrderMapper.getList(UocRu.js(uocInspOrderQryBo, UocInspOrderPo.class));
        return UocRu.jsl(uocInspOrderPoList, UocInspOrderDo.class);
    }

    @Override
    public UocInspOrderDo qryTotalFeeAndCount(UocInspOrderQryBo uocInspOrderQryBo) {
        UocInspOrderPo uocInspOrderPo = UocRu.js(uocInspOrderQryBo, UocInspOrderPo.class);
        uocInspOrderPo = uocInspOrderMapper.qryTotalFeeAndCount(uocInspOrderPo);
        return UocRu.js(uocInspOrderPo, UocInspOrderDo.class);
    }
}
