/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.conforder.qrybo.UocConfTabOrdStateQryBo;
import com.tydic.dyc.oc.model.conforder.sub.UocConfTabOrdState;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderBusiOperRecord;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.dao.UocConfTabOrdStateMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderAccessoryMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderBusiOperRecordMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderProcInstMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderStateChgLogMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderTaskDealMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderTaskInstMapper;
import com.tydic.dyc.oc.repository.po.UocConfTabOrdStatePo;
import com.tydic.dyc.oc.repository.po.UocOrderAccessoryPo;
import com.tydic.dyc.oc.repository.po.UocOrderBusiOperRecordPo;
import com.tydic.dyc.oc.repository.po.UocOrderProcInstPo;
import com.tydic.dyc.oc.repository.po.UocOrderStateChgLogPo;
import com.tydic.dyc.oc.repository.po.UocOrderTaskDealPo;
import com.tydic.dyc.oc.repository.po.UocOrderTaskInstPo;
import com.tydic.dyc.oc.utils.UocRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocCommonRepositoryImpl
implements UocCommonRepository {
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;
    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;
    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;
    @Autowired
    private UocOrderStateChgLogMapper uocOrderStateChgLogMapper;
    @Autowired
    private UocOrderBusiOperRecordMapper uocOrderBusiOperRecordMapper;
    @Autowired
    private UocConfTabOrdStateMapper uocConfTabOrdStateMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    public void addBatchOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList) {
        if (!CollectionUtils.isEmpty(uocOrderAccessoryList)) {
            this.uocOrderAccessoryMapper.insertBatch(UocRu.jsl(uocOrderAccessoryList, UocOrderAccessoryPo.class));
        }
    }

    public void updateToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        for (UocOrderTaskInst uocOrderTaskInst : uocOrderTaskInstList) {
            UocOrderTaskInstPo updateSetPo = new UocOrderTaskInstPo();
            updateSetPo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
            UocOrderTaskInstPo updateWherePo = new UocOrderTaskInstPo();
            updateWherePo.setOrderId(uocOrderTaskInst.getOrderId());
            updateWherePo.setTaskInstId(uocOrderTaskInst.getTaskInstId());
            this.uocOrderTaskInstMapper.updateBy(updateSetPo, updateWherePo);
        }
    }

    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            this.uocOrderTaskInstMapper.insertBatch(UocRu.jsl(saveTaskList, UocOrderTaskInstPo.class));
        }
    }

    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        this.uocOrderProcInstMapper.insert((UocOrderProcInstPo)UocRu.js((Object)inst, UocOrderProcInstPo.class));
        return inst;
    }

    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return UocRu.jsl(this.uocOrderProcInstMapper.getList((UocOrderProcInstPo)UocRu.js((Object)inst, UocOrderProcInstPo.class)), UocOrderProcInst.class);
    }

    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        if (ObjectUtil.isNotEmpty(dealList)) {
            this.uocOrderTaskDealMapper.insertBatch(UocRu.jsl(dealList, UocOrderTaskDealPo.class));
        }
    }

    public UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog) {
        if (ObjectUtil.isNotEmpty((Object)uocOrderStateChgLog)) {
            this.uocOrderStateChgLogMapper.insert((UocOrderStateChgLogPo)UocRu.js((Object)uocOrderStateChgLog, UocOrderStateChgLogPo.class));
        }
        return uocOrderStateChgLog;
    }

    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        if (ObjectUtil.isNotEmpty((Object)taskInst)) {
            return UocRu.jsl(this.uocOrderTaskInstMapper.getList((UocOrderTaskInstPo)UocRu.js((Object)taskInst, UocOrderTaskInstPo.class)), UocOrderTaskInst.class);
        }
        return new ArrayList<UocOrderTaskInst>();
    }

    public UocOrderProcInst updateProInst(UocOrderProcInst inst) {
        UocOrderProcInstPo set = (UocOrderProcInstPo)UocRu.js((Object)inst, UocOrderProcInstPo.class);
        UocOrderProcInstPo where = new UocOrderProcInstPo();
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        this.uocOrderProcInstMapper.updateBy(set, where);
        return inst;
    }

    public void saveOperRecord(List<UocOrderBusiOperRecord> recordList) {
        List recordPoList = UocRu.jsl(recordList, UocOrderBusiOperRecordPo.class);
        this.uocOrderBusiOperRecordMapper.insertBatch(recordPoList);
    }

    public List<UocConfTabOrdState> qryConfTabOrdStateList(UocConfTabOrdStateQryBo qryBo) {
        List<UocConfTabOrdStatePo> list = this.uocConfTabOrdStateMapper.getList((UocConfTabOrdStatePo)UocRu.js((Object)qryBo, UocConfTabOrdStatePo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocConfTabOrdState.class) : new ArrayList();
    }

    public String getOrderNoSingle(String code) {
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter("UOC");
        getBo.setEncodedRuleCode(code);
        getBo.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(getBo);
        if (CollectionUtils.isEmpty((Collection)encodedSerial.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerial.getSerialNoList().get(0)))) {
            throw new BaseBusinessException("101006", "\u83b7\u53d6\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a");
        }
        return (String)encodedSerial.getSerialNoList().get(0);
    }
}

