package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.cmporder.UocCmpOrderDo;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderItem;
import com.tydic.dyc.oc.repository.UocCmpOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocCmpOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocCmpOrderMapper;
import com.tydic.dyc.oc.repository.po.UocCmpOrderItemPo;
import com.tydic.dyc.oc.repository.po.UocCmpOrderPo;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：类名称:UocCmpOrderRepositoryImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/3/29 11:33
 * 作者 @author 尹栋梁
 */
@Service
public class UocCmpOrderRepositoryImpl implements UocCmpOrderRepository {

    @Autowired
    private UocCmpOrderMapper uocCmpOrderMapper;

    @Autowired
    private UocCmpOrderItemMapper uocCmpOrderItemMapper;

    @Override
    public void createCmpOrder(UocCmpOrderDo uocCmpOrderDo) {
        uocCmpOrderMapper.insert(UocRu.js(uocCmpOrderDo, UocCmpOrderPo.class));
        if (CollectionUtil.isNotEmpty(uocCmpOrderDo.getUocCmpOrderItemList())) {
            uocCmpOrderItemMapper.insertBatch(UocRu.jsl(uocCmpOrderDo.getUocCmpOrderItemList(), UocCmpOrderItemPo.class));
        }
    }

    @Override
    public UocCmpOrderDo qryCmpOrder(UocCmpOrderDo uocCmpOrderDo) {
        UocCmpOrderDo result = new UocCmpOrderDo();
        UocCmpOrderPo uocCmpOrderPo = new UocCmpOrderPo();
        uocCmpOrderPo.setCmpOrderNo(uocCmpOrderDo.getCmpOrderNo());
        UocCmpOrderPo cmpOrderPo = uocCmpOrderMapper.getModelBy(uocCmpOrderPo);
        if (ObjectUtil.isEmpty(cmpOrderPo)) {
            return result;
        }
        result = UocRu.js(cmpOrderPo, UocCmpOrderDo.class);
        UocCmpOrderItemPo uocCmpOrderItemPo = new UocCmpOrderItemPo();
        uocCmpOrderItemPo.setCmpOrderId(cmpOrderPo.getCmpOrderId());
        uocCmpOrderItemPo.setOrderBy("sku_order asc");
        List<UocCmpOrderItemPo> cmpOrderItemList = uocCmpOrderItemMapper.getList(uocCmpOrderItemPo);
        if (CollectionUtil.isNotEmpty(cmpOrderItemList)) {
            result.setUocCmpOrderItemList(UocRu.jsl(cmpOrderItemList, UocCmpOrderItem.class));
        }
        return result;
    }

    @Override
    public Integer getCheckBy(UocCmpOrderDo uocCmpOrderDo) {
        return uocCmpOrderMapper.getCheckBy(UocRu.js(uocCmpOrderDo, UocCmpOrderPo.class));
    }
}
