package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.payorder.UocPayOrderDo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderItemObjQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderMapQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderObjQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderQryBo;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrder;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrderItemObj;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrderMap;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrderObj;
import com.tydic.dyc.oc.repository.UocPayOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocPayOrderItemObjMapper;
import com.tydic.dyc.oc.repository.dao.UocPayOrderMapMapper;
import com.tydic.dyc.oc.repository.dao.UocPayOrderMapper;
import com.tydic.dyc.oc.repository.dao.UocPayOrderObjMapper;
import com.tydic.dyc.oc.repository.po.UocPayOrderItemObjPo;
import com.tydic.dyc.oc.repository.po.UocPayOrderMapPo;
import com.tydic.dyc.oc.repository.po.UocPayOrderObjPo;
import com.tydic.dyc.oc.repository.po.UocPayOrderPo;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocPayOrderRepositoryImpl
 * 说明:支付单
 * 时间:2022/2/21 18:53
 * 作者:罗有
 */

@Service
public class UocPayOrderRepositoryImpl implements UocPayOrderRepository {

    @Autowired
    private UocPayOrderMapper uocPayOrderMapper;
    @Autowired
    private UocPayOrderMapMapper uocPayOrderMapMapper;
    @Autowired
    private UocPayOrderObjMapper uocPayOrderObjMapper;
    @Autowired
    private UocPayOrderItemObjMapper uocPayOrderItemObjMapper;

    @Override
    public UocPayOrder getPayOrderMain(UocPayOrderQryBo uocPayOrderQryBo) {
        UocPayOrderPo po = uocPayOrderMapper.getModelBy(UocRu.js(uocPayOrderQryBo, UocPayOrderPo.class));
        return null != po ? UocRu.js(po, UocPayOrder.class) : null;
    }

    @Override
    public List<UocPayOrder> getListPayOrder(UocPayOrderQryBo uocPayOrderQryBo) {
        List<UocPayOrderPo> list = uocPayOrderMapper.getList(UocRu.js(uocPayOrderQryBo, UocPayOrderPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocPayOrder.class) : new ArrayList<>();
    }

    @Override
    public List<UocPayOrderObj> getListPayOrderObj(UocPayOrderObjQryBo uocPayOrderObjQryBo) {
        List<UocPayOrderObjPo> list = uocPayOrderObjMapper.getList(UocRu.js(uocPayOrderObjQryBo, UocPayOrderObjPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocPayOrderObj.class) : new ArrayList<>();
    }

    @Override
    public List<UocPayOrderItemObj> getListPayOrderItemObj(UocPayOrderItemObjQryBo uocPayOrderItemObjQryBo) {
        List<UocPayOrderItemObjPo> list = uocPayOrderItemObjMapper.getList(UocRu.js(uocPayOrderItemObjQryBo, UocPayOrderItemObjPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocPayOrderItemObj.class) : new ArrayList<>();
    }

    @Override
    public List<UocPayOrderMap> getListPayOrderMap(UocPayOrderMapQryBo uocPayOrderMapQryBo) {
        List<UocPayOrderMapPo> list = uocPayOrderMapMapper.getList(UocRu.js(uocPayOrderMapQryBo, UocPayOrderMapPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocPayOrderMap.class) : new ArrayList<>();
    }

    @Override
    public void modifyPayOrderMain(UocPayOrderQryBo set,UocPayOrderQryBo where) {
        uocPayOrderMapper.updateBy(UocRu.js(set,UocPayOrderPo.class),UocRu.js(where,UocPayOrderPo.class));
    }
}
