/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdInvoiceQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderCheckAccountQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderItemQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderMapQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdInvoice;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderCheckAccount;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderMap;
import com.tydic.dyc.oc.model.order.sub.UocOrderOperating;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.repository.UocOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocOrdInvoiceMapper;
import com.tydic.dyc.oc.repository.dao.UocOrdLogisticsRelaMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderAccessoryMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderAgreementMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderCheckAccountMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderItemEwMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderItemMapMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderItemSnapshotMapMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderItemSnapshotMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderMapMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderProcInstMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderRelMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderStateChgLogMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderTaskDealMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderTaskInstMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleStakeholderMapper;
import com.tydic.dyc.oc.repository.po.UocOrdInvoicePo;
import com.tydic.dyc.oc.repository.po.UocOrdLogisticsRelaPo;
import com.tydic.dyc.oc.repository.po.UocOrderAccessoryPo;
import com.tydic.dyc.oc.repository.po.UocOrderAgreementPo;
import com.tydic.dyc.oc.repository.po.UocOrderCheckAccountPo;
import com.tydic.dyc.oc.repository.po.UocOrderItemEwPo;
import com.tydic.dyc.oc.repository.po.UocOrderItemMapPo;
import com.tydic.dyc.oc.repository.po.UocOrderItemPo;
import com.tydic.dyc.oc.repository.po.UocOrderItemSnapshotPo;
import com.tydic.dyc.oc.repository.po.UocOrderMapPo;
import com.tydic.dyc.oc.repository.po.UocOrderPo;
import com.tydic.dyc.oc.repository.po.UocOrderProcInstPo;
import com.tydic.dyc.oc.repository.po.UocOrderRelPo;
import com.tydic.dyc.oc.repository.po.UocOrderStateChgLogPo;
import com.tydic.dyc.oc.repository.po.UocOrderTaskDealPo;
import com.tydic.dyc.oc.repository.po.UocOrderTaskInstPo;
import com.tydic.dyc.oc.repository.po.UocSaleStakeholderPo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocOrderRepositoryImpl
implements UocOrderRepository {
    @Autowired
    private UocOrderMapper uocOrderMapper;
    @Autowired
    private UocOrderMapMapper uocOrderMapMapper;
    @Autowired
    private UocOrdInvoiceMapper uocOrdInvoiceMapper;
    @Autowired
    private UocSaleStakeholderMapper uocSaleStakeholderMapper;
    @Autowired
    private UocOrderItemMapper uocOrderItemMapper;
    @Autowired
    private UocOrderItemMapMapper uocOrderItemMapMapper;
    @Autowired
    private UocOrderItemEwMapper uocOrderItemEwMapper;
    @Autowired
    private UocOrderItemSnapshotMapMapper uocOrderItemSnapshotMapMapper;
    @Autowired
    private UocOrdLogisticsRelaMapper uocOrdLogisticsRelaMapper;
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;
    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;
    @Autowired
    private UocOrderItemSnapshotMapper uocOrderItemSnapshotMapper;
    @Autowired
    private UocOrderStateChgLogMapper uocOrderStateChgLogMapper;
    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;
    @Autowired
    private UocOrderRelMapper uocOrderRelMapper;
    @Autowired
    private UocOrderCheckAccountMapper uocOrderCheckAccountMapper;
    @Autowired
    private UocOrderAgreementMapper uocOrderAgreementMapper;

    public UocOrderDo saveUocOrder(UocOrderDo orderDo) {
        if (orderDo.getInvoiceAddress() != null) {
            this.uocOrdLogisticsRelaMapper.insert((UocOrdLogisticsRelaPo)UocRu.js((Object)orderDo.getInvoiceAddress(), UocOrdLogisticsRelaPo.class));
        }
        if (orderDo.getReceiverAddress() != null) {
            this.uocOrdLogisticsRelaMapper.insert((UocOrdLogisticsRelaPo)UocRu.js((Object)orderDo.getReceiverAddress(), UocOrdLogisticsRelaPo.class));
        }
        this.uocOrderMapper.insert((UocOrderPo)UocRu.js((Object)orderDo, UocOrderPo.class));
        if (ObjectUtil.isNotEmpty((Object)orderDo.getOrderExt())) {
            this.uocOrderMapMapper.insertBatch(UocRu.jsl((List)orderDo.getOrderExt(), UocOrderMapPo.class));
        }
        this.saveStakeholder(orderDo);
        if (ObjectUtil.isNotEmpty((Object)orderDo.getUocOrdInvoice())) {
            this.uocOrdInvoiceMapper.insert((UocOrdInvoicePo)UocRu.js((Object)orderDo.getUocOrdInvoice(), UocOrdInvoicePo.class));
        }
        if (ObjectUtil.isNotEmpty((Object)orderDo.getAccessoryList())) {
            this.uocOrderAccessoryMapper.insertBatch(UocRu.jsl((List)orderDo.getAccessoryList(), UocOrderAccessoryPo.class));
        }
        this.saveOrderItemData(orderDo);
        return orderDo;
    }

    public UocOrderDo createOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList) {
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setAccessoryList(uocOrderAccessoryList);
        this.uocOrderAccessoryMapper.insertBatch(UocRu.jsl(uocOrderAccessoryList, UocOrderAccessoryPo.class));
        return uocOrderDo;
    }

    public UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog) {
        this.uocOrderStateChgLogMapper.insert((UocOrderStateChgLogPo)UocRu.js((Object)uocOrderStateChgLog, UocOrderStateChgLogPo.class));
        return uocOrderStateChgLog;
    }

    public List<UocOrderStakeholderQryBo> qryStakeholderList(UocOrderStakeholderQryBo qryBo) {
        return UocRu.jsl(this.uocSaleStakeholderMapper.getList((UocSaleStakeholderPo)UocRu.js((Object)qryBo, UocSaleStakeholderPo.class)), UocOrderStakeholderQryBo.class);
    }

    private void saveOrderItemData(UocOrderDo orderDo) {
        List orderItems = orderDo.getOrderItems();
        ArrayList<UocOrderItemPo> ordItemList = new ArrayList<UocOrderItemPo>();
        ArrayList<UocOrderItemMapPo> itemExtList = new ArrayList<UocOrderItemMapPo>();
        ArrayList<UocOrderItemEwPo> itemEwList = new ArrayList<UocOrderItemEwPo>();
        ArrayList<UocOrderItemSnapshotPo> itemCommList = new ArrayList<UocOrderItemSnapshotPo>();
        HashMap<String, Object> agrPoMap = new HashMap<String, Object>();
        for (UocOrderItem orderItem : orderItems) {
            List ewList;
            ordItemList.add((UocOrderItemPo)UocRu.js((Object)orderItem, UocOrderItemPo.class));
            List itemMapList = orderItem.getItemMapList();
            if (ObjectUtil.isNotEmpty((Object)itemMapList)) {
                itemExtList.addAll(UocRu.jsl((List)itemMapList, UocOrderItemMapPo.class));
            }
            if (ObjectUtil.isNotEmpty((Object)(ewList = orderItem.getEwList()))) {
                itemEwList.addAll(UocRu.jsl((List)ewList, UocOrderItemEwPo.class));
            }
            if (ObjectUtil.isNotEmpty((Object)orderItem.getCommJsonStr())) {
                UocOrderItemSnapshotPo commPo = new UocOrderItemSnapshotPo();
                commPo.setId(IdUtil.nextId());
                commPo.setOrderId(orderDo.getOrderId());
                commPo.setOrderItemId(orderItem.getOrderItemId());
                commPo.setSkuId(orderItem.getSkuId());
                commPo.setJsonStr(orderItem.getCommJsonStr());
                commPo.setCreateOperId(orderDo.getCreateOperId());
                commPo.setCreateTime(orderDo.getCreateTime());
                itemCommList.add(commPo);
            }
            if (!ObjectUtil.isNotEmpty((Object)orderItem.getAgreementId()) || !ObjectUtil.isNotEmpty((Object)orderItem.getAgrBo())) continue;
            agrPoMap.put(orderItem.getAgreementId(), JUtil.js((Object)orderItem.getAgrBo(), UocOrderAgreementPo.class));
        }
        if (ObjectUtil.isNotEmpty(agrPoMap)) {
            ArrayList<UocOrderAgreementPo> agrPoList = new ArrayList<UocOrderAgreementPo>(agrPoMap.values());
            this.uocOrderAgreementMapper.insertBatch(agrPoList);
        }
        this.uocOrderItemMapper.insertBatch(ordItemList);
        if (ObjectUtil.isNotEmpty(itemExtList)) {
            this.uocOrderItemMapMapper.insertBatch(itemExtList);
        }
        if (ObjectUtil.isNotEmpty(itemEwList)) {
            this.uocOrderItemEwMapper.insertBatch(itemEwList);
        }
        if (ObjectUtil.isNotEmpty(itemCommList)) {
            this.uocOrderItemSnapshotMapper.insertBatch(itemCommList);
        }
    }

    private void saveStakeholder(UocOrderDo orderDo) {
        List orderItems = orderDo.getOrderItems();
        UocOrderOperating operating = orderDo.getOperating();
        Map<String, List<UocOrderItem>> supplierMap = orderItems.stream().collect(Collectors.groupingBy(UocOrderItem::getSupplierId));
        ArrayList<UocSaleStakeholderPo> operatingList = new ArrayList<UocSaleStakeholderPo>(supplierMap.size());
        for (Map.Entry<String, List<UocOrderItem>> entry : supplierMap.entrySet()) {
            UocOrderItem supOrderItem = entry.getValue().get(0);
            UocSaleStakeholderPo operatingPo = (UocSaleStakeholderPo)UocRu.js((Object)operating, UocSaleStakeholderPo.class);
            operatingPo.setOrderId(orderDo.getOrderId());
            operatingPo.setStakeholderId(IdUtil.nextId());
            operatingPo.setPurAccount(orderDo.getPurAccount());
            operatingPo.setPurAccountName(orderDo.getPurAccountName());
            operatingPo.setPurMobile(orderDo.getPurMobile());
            operatingPo.setPurUserId(orderDo.getCreateOperId());
            operatingPo.setPurName(orderDo.getName());
            operatingPo.setPurUserName(orderDo.getUsername());
            operatingPo.setPurCompanyId(orderDo.getCompanyId() != null ? orderDo.getCompanyId().toString() : null);
            operatingPo.setPurCompanyName(orderDo.getCompanyName());
            operatingPo.setPurOrgId(orderDo.getOrgId() != null ? orderDo.getOrgId().toString() : null);
            operatingPo.setPurOrgName(orderDo.getOrgName());
            operatingPo.setPurOrgPath(orderDo.getOrgPath());
            operatingPo.setPurNeedMobile(orderDo.getPurNeedMobile());
            operatingPo.setPurNeedName(orderDo.getPurNeedName());
            operatingPo.setSupId(supOrderItem.getSupplierId());
            operatingPo.setSupName(supOrderItem.getSupplierName());
            operatingPo.setSupRelaName(supOrderItem.getSupRelaName());
            operatingPo.setSupRelaMobile(supOrderItem.getSupRelaMobile());
            operatingPo.setProDeliveryId(supOrderItem.getProDeliveryId());
            operatingPo.setProDeliveryName(supOrderItem.getProDeliveryName());
            operatingPo.setDelTag(UocDicConstant.DELETE_TAG.NO_DEL);
            operatingList.add(operatingPo);
        }
        this.uocSaleStakeholderMapper.insertBatch(operatingList);
    }

    public List<UocOrderTaskInst> qryOrderTaskInstList(UocOrderTaskInstQryBo qryBo) {
        List<UocOrderTaskInstPo> uocOrderTaskInstPoList = this.uocOrderTaskInstMapper.getList((UocOrderTaskInstPo)UocRu.js((Object)qryBo, UocOrderTaskInstPo.class));
        return ObjectUtil.isNotEmpty(uocOrderTaskInstPoList) ? UocRu.jsl(uocOrderTaskInstPoList, UocOrderTaskInst.class) : new ArrayList();
    }

    public List<UocOrderTaskDeal> qryOrderTaskDealList(UocOrderTaskDealQryBo qryBo) {
        List<UocOrderTaskDealPo> uocOrderTaskDealPoList = this.uocOrderTaskDealMapper.getList((UocOrderTaskDealPo)UocRu.js((Object)qryBo, UocOrderTaskDealPo.class));
        return ObjectUtil.isNotEmpty(uocOrderTaskDealPoList) ? UocRu.jsl(uocOrderTaskDealPoList, UocOrderTaskDeal.class) : new ArrayList();
    }

    public List<UocOrderProcInst> qryOrderProcInstList(UocOrderProcInstQryBo qryBo) {
        List<UocOrderProcInstPo> uocOrderProcInstPoList = this.uocOrderProcInstMapper.getList((UocOrderProcInstPo)UocRu.js((Object)qryBo, UocOrderProcInstPo.class));
        return ObjectUtil.isNotEmpty(uocOrderProcInstPoList) ? UocRu.jsl(uocOrderProcInstPoList, UocOrderProcInst.class) : new ArrayList();
    }

    public UocOrderDo qryOrderBy(UocOrderDo uocOrderDo) {
        UocOrderPo uocOrderPo = this.uocOrderMapper.getModelBy((UocOrderPo)UocRu.js((Object)uocOrderDo, UocOrderPo.class));
        return uocOrderPo != null ? (UocOrderDo)UocRu.js((Object)uocOrderPo, UocOrderDo.class) : null;
    }

    public List<UocOrderItem> qryOrderItemList(UocOrderItemQryBo uocOrderItemQryBo) {
        List<UocOrderItemPo> list = this.uocOrderItemMapper.getList((UocOrderItemPo)UocRu.js((Object)uocOrderItemQryBo, UocOrderItemPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocOrderItem.class) : new ArrayList();
    }

    public UocOrdLogisticsRela qryOrderLogisticsRela(UocOrdLogisticsRelaQryBo qryBo) {
        List<UocOrdLogisticsRelaPo> list = this.uocOrdLogisticsRelaMapper.getList((UocOrdLogisticsRelaPo)UocRu.js((Object)qryBo, UocOrdLogisticsRelaPo.class));
        return ObjectUtil.isNotEmpty(list) ? (UocOrdLogisticsRela)UocRu.js((Object)list.get(0), UocOrdLogisticsRela.class) : new UocOrdLogisticsRela();
    }

    public UocOrdInvoice qryOrderInvoice(UocOrdInvoiceQryBo qryBo) {
        UocOrdInvoicePo invoicePo = this.uocOrdInvoiceMapper.getModelBy((UocOrdInvoicePo)UocRu.js((Object)qryBo, UocOrdInvoicePo.class));
        return ObjectUtil.isNotEmpty((Object)invoicePo) ? (UocOrdInvoice)UocRu.js((Object)invoicePo, UocOrdInvoice.class) : new UocOrdInvoice();
    }

    public List<UocOrderAccessory> getOrderAccessoryList(UocOrderAccessoryQryBo qryBo) {
        List<UocOrderAccessoryPo> list = this.uocOrderAccessoryMapper.getList((UocOrderAccessoryPo)UocRu.js((Object)qryBo, UocOrderAccessoryPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocOrderAccessory.class) : new ArrayList();
    }

    public List<UocOrderMap> qryOrderMapList(UocOrderMapQryBo qryBo) {
        UocOrderMapPo uocOrderMapPo = (UocOrderMapPo)UocRu.js((Object)qryBo, UocOrderMapPo.class);
        List<UocOrderMapPo> uocOrderMapPoList = this.uocOrderMapMapper.getList(uocOrderMapPo);
        return UocRu.jsl(uocOrderMapPoList, UocOrderMap.class);
    }

    public void dealRelUpdate(UocOrderRel qryBo) {
        UocOrderRelPo uocOrderRelPo = (UocOrderRelPo)UocRu.js((Object)qryBo, UocOrderRelPo.class);
        this.uocOrderRelMapper.updateById(uocOrderRelPo);
    }

    public UocOrderRel qryRelInfo(UocOrderRelQryBo qryBo) {
        UocOrderRelPo uocOrderRelPo = (UocOrderRelPo)UocRu.js((Object)qryBo, UocOrderRelPo.class);
        uocOrderRelPo = this.uocOrderRelMapper.getModelBy(uocOrderRelPo);
        return (UocOrderRel)UocRu.js((Object)uocOrderRelPo, UocOrderRel.class);
    }

    public void createRelInfo(UocOrderRel uocOrderRel) {
        UocOrderRelPo uocOrderRelPo = (UocOrderRelPo)UocRu.js((Object)uocOrderRel, UocOrderRelPo.class);
        this.uocOrderRelMapper.insert(uocOrderRelPo);
    }

    public UocOrderCheckAccount qryCheckInfo(UocOrderCheckAccountQryBo qryBo) {
        UocOrderCheckAccountPo uocOrderCheckAccountPo = (UocOrderCheckAccountPo)UocRu.js((Object)qryBo, UocOrderCheckAccountPo.class);
        uocOrderCheckAccountPo = this.uocOrderCheckAccountMapper.getModelBy(uocOrderCheckAccountPo);
        return (UocOrderCheckAccount)UocRu.js((Object)uocOrderCheckAccountPo, UocOrderCheckAccount.class);
    }

    public void createCheckInfo(UocOrderCheckAccount uocOrderCheckAccount) {
        UocOrderCheckAccountPo uocOrderCheckAccountPo = (UocOrderCheckAccountPo)UocRu.js((Object)uocOrderCheckAccount, UocOrderCheckAccountPo.class);
        this.uocOrderCheckAccountMapper.insert(uocOrderCheckAccountPo);
    }

    public void updateCheckInfo(UocOrderCheckAccount uocOrderCheckAccount) {
        UocOrderCheckAccountPo uocOrderCheckAccountPo = (UocOrderCheckAccountPo)UocRu.js((Object)uocOrderCheckAccount, UocOrderCheckAccountPo.class);
        this.uocOrderCheckAccountMapper.updateById(uocOrderCheckAccountPo);
    }
}

