package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.aforder.qrybo.*;
import com.tydic.dyc.oc.model.aforder.sub.*;
import com.tydic.dyc.oc.repository.UocAfOrderRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocAfOrderRepositoryImpl
 * 说明:售后单
 * 时间:2022/2/21 18:54
 * 作者:罗有
 */

@Service
public class UocAfOrderRepositoryImpl implements UocAfOrderRepository {

    @Autowired
    private UocAfOrderMapper uocAfOrderMapper;
    @Autowired
    private UocAfOrderMapMapper uocAfOrderMapMapper;
    @Autowired
    private UocAfOrderObjMapper uocAfOrderObjMapper;
    @Autowired
    private UocAfOrderItemMapper uocAfOrderItemMapper;
    @Autowired
    private UocAfItemMapMapper uocAfItemMapMapper;
    @Autowired
    private UocAfOrderWaybillMapper uocAfOrderWaybillMapper;

    @Override
    public List<UocAfOrderItem> getAfOrderItemList(UocAfOrderItemQryBo uocAfOrderItemQryBo) {
        List<UocAfOrderItemPo> list = uocAfOrderItemMapper.getList(UocRu.js(uocAfOrderItemQryBo, UocAfOrderItemPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderItem.class) : new ArrayList<>();
    }

    @Override
    public UocAfOrder getAfOrderById(UocAfOrderQryBo uocAfOrderQryBo) {
        UocAfOrderPo uocAfOrderPo = new UocAfOrderPo();
        uocAfOrderPo.setAfOrderId(uocAfOrderQryBo.getAfOrderId());
        if (ObjectUtil.isNotNull(uocAfOrderQryBo.getOrderId())) {
            uocAfOrderPo.setOrderId(uocAfOrderQryBo.getOrderId());
        }
        uocAfOrderPo = uocAfOrderMapper.getModelBy(uocAfOrderPo);
        return null != uocAfOrderPo ? UocRu.js(uocAfOrderPo, UocAfOrder.class) : null;
    }

    @Override
    public List<UocAfOrder> getAfOrderList(UocAfOrderQryBo uocAfOrderQryBo) {
        List<UocAfOrderPo> list = uocAfOrderMapper.getList(UocRu.js(uocAfOrderQryBo, UocAfOrderPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrder.class) : new ArrayList<>();
    }

    @Override
    public List<UocAfOrderObj> getAfOrderObjList(UocAfOrderObjQryBo uocAfOrderObjQryBo) {
        List<UocAfOrderObjPo> list = uocAfOrderObjMapper.getList(UocRu.js(uocAfOrderObjQryBo, UocAfOrderObjPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderObj.class) : new ArrayList<>();
    }

    @Override
    public List<UocAfOrderMap> getAfOrderMapList(UocAfOrderMapQryBo uocAfOrderMapQryBo) {
        List<UocAfOrderMapPo> list = uocAfOrderMapMapper.getList(UocRu.js(uocAfOrderMapQryBo, UocAfOrderMapPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderMap.class) : new ArrayList<>();
    }

    @Override
    public List<UocAfOrderWaybill> getAfOrderWayBillList(UocAfOrderWaybillQryBo uocAfOrderWaybillQryBo) {
        List<UocAfOrderWaybillPo> list = uocAfOrderWaybillMapper.getList(UocRu.js(uocAfOrderWaybillQryBo, UocAfOrderWaybillPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderWaybill.class) : new ArrayList<>();
    }

    @Override
    public List<UocAfItemMap> getAfOrderItemMapList(UocAfItemMapQryBo uocAfItemMapQryBo) {
        List<UocAfItemMapPo> list = uocAfItemMapMapper.getList(UocRu.js(uocAfItemMapQryBo, UocAfItemMapPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfItemMap.class) : new ArrayList<>();
    }
}
