package com.tydic.dyc.oc.repository.impl;

import com.tydic.dyc.oc.model.payorder.sub.UocPayOrder;
import com.tydic.dyc.oc.model.shouldpayorder.UocOrderShouldPayDo;
import com.tydic.dyc.oc.repository.UocOrderShouldPayRepository;
import com.tydic.dyc.oc.repository.dao.UocOrderShouldPayMapper;
import com.tydic.dyc.oc.repository.po.UocOrderShouldPayPo;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：UocOrderShouldPayRepositoryImpl
 * 说明：
 * 时间：2022/4/2 10:07
 * 作者： 周中贤
 */
@Service
public class UocOrderShouldPayRepositoryImpl implements UocOrderShouldPayRepository {

    @Autowired
    private UocOrderShouldPayMapper uocOrderShouldPayMapper;

    /**
     * 根据条件获取一条应付单数据
     * @param uocOrderShouldPayDo 查询条件
     * @return 一条应付单数据
     */
    @Override
    public UocOrderShouldPayDo getOrderShouldPay(UocOrderShouldPayDo uocOrderShouldPayDo) {
        UocOrderShouldPayPo po = uocOrderShouldPayMapper.getModelBy(UocRu.js(uocOrderShouldPayDo, UocOrderShouldPayPo.class));
        return null != po ? UocRu.js(po, UocOrderShouldPayDo.class) : null;
    }

    /**
     * 查询多条应付单数据
     *
     * @param uocOrderShouldPayDo 查询条件
     * @return 多条应付单数据
     */
    @Override
    public List<UocOrderShouldPayDo> getListOrderShouldPay(UocOrderShouldPayDo uocOrderShouldPayDo) {
        List<UocOrderShouldPayPo> list = uocOrderShouldPayMapper.getList(UocRu.js(uocOrderShouldPayDo, UocOrderShouldPayPo.class));
        return CollectionUtils.isEmpty(list) ? new ArrayList<>() : UocRu.jsl(list,UocOrderShouldPayDo.class);
    }

    /**
     * 订单应付单主体数据更新
     * @param set
     * @param where
     */
    @Override
    public void modifyOrderShouldPayMain(UocOrderShouldPayDo set, UocOrderShouldPayDo where) {
        uocOrderShouldPayMapper.updateBy(UocRu.js(set, UocOrderShouldPayPo.class),UocRu.js(where, UocOrderShouldPayPo.class));
    }
}
