package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.model.order.sub.ConfSupplierPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface ConfSupplierMapper {

    /**
     * 1.insert新增一条数据
     * 注: 根据Model实体执行新增操作.
     *
     * @return int               - 执行结果
     */
    int insert(ConfSupplierPO confSupplierPO);

    /**
     * 2.deleteById根据主键ID删除一条数据
     * 注: 根据主键ID执行删除操作.
     *
     * @param supNo - 供应商ID(主键ID)
     * @return int              - 执行结果
     */
    int deleteById(long supNo);

    /**
     * 3.deleteByIds根据主键ID批量删除数据
     * 注: 根据拼接有限个主键ID执行多条数据的删除操作.
     *
     * @param supNos - 供应商ID(主键IDS)
     * @return int              - 执行结果
     */
    int deleteByIds(int[] supNos);

    /**
     * 4.deleteBy根据Model删除数据
     * 注: 根据Model拼接条件执行删除操作.
     *
     * @return int              - 执行结果
     */
    int deleteBy(ConfSupplierPO confSupplierPO);

    /**
     * 5.updateById根据Model实体ID更新一条数据
     * 注: 根据Model实体ID更新一条数据.
     *
     * @return int              - 执行结果
     */
    int updateById(ConfSupplierPO confSupplierPO);

    /**
     * 6.getModelById根据ID获取一个Model实体
     * 注: 根据主键ID获取一个Model实体.
     *
     * @param supNo - 供应商ID(主键ID)
     * @return model            - 执行结果
     */
    ConfSupplierPO getModelById(long supNo);

    /**
     * 7.getModelBy根据Model获取一个Model实体
     * 注: 根据Model实体获取一个Model实体.
     *
     * @return model            - 执行结果
     */
    ConfSupplierPO getModelBy(ConfSupplierPO confSupplierPO);

    /**
     * 8.getList条件查询，不分页
     * 注: 支持多条件查询、模糊查询、日期比较查询等操作.
     *
     * @return list             - 执行结果
     */
    List<ConfSupplierPO> getList(ConfSupplierPO confSupplierPO);

    /**
     * 9.getListPage条件查询，分页
     * 注: 支持多条件查询、模糊查询、日期比较查询等操作.
     *
     * @param page 分页信息
     * @return list             - 执行结果
     */
    List<ConfSupplierPO> getListPage(ConfSupplierPO confSupplierPO, Page<ConfSupplierPO> page);

    /**
     * 10.getCheckById根据主键ID验证一条数据是否存在
     * 注: 根据主键ID验证该数据是否存在.
     *
     * @param supNo - 供应商ID(主键ID)
     * @return int              - 执行结果
     */
    int getCheckById(long supNo);

    /**
     * 11.getCheckBy根据Model实体验证一条数据是否存在
     * 注: 根据Model实体验证该数据是否存在.
     *
     * @return int              - 执行结果
     */
    int getCheckBy(ConfSupplierPO confSupplierPO);

    /**
     * 12.insertBatch根据List对象批量新增数据
     * 注: 根据List对象执行批量新增操作.
     */
    void insertBatch(List<ConfSupplierPO> list);

}