package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.UocRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocCommonRepositoryImpl
 * 说明:通用
 * 时间:2022/2/25 19:38
 * 作者:罗有
 */

@Service
public class UocCommonRepositoryImpl implements UocCommonRepository {
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;

    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;

    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;

    @Autowired
    private UocOrderStateChgLogMapper uocOrderStateChgLogMapper;

    @Autowired
    private UocOrderBusiOperRecordMapper uocOrderBusiOperRecordMapper;

    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;


    @Override
    public void addBatchOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList) {
        if (!CollectionUtils.isEmpty(uocOrderAccessoryList)) {
            uocOrderAccessoryMapper.insertBatch(UocRu.jsl(uocOrderAccessoryList, UocOrderAccessoryPo.class));
        }
    }

    @Override
    public void updateToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        for (UocOrderTaskInst uocOrderTaskInst : uocOrderTaskInstList) {
            UocOrderTaskInstPo updateSetPo = new UocOrderTaskInstPo();
            updateSetPo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);

            UocOrderTaskInstPo updateWherePo = new UocOrderTaskInstPo();
            updateWherePo.setOrderId(uocOrderTaskInst.getOrderId());
            updateWherePo.setTaskInstId(uocOrderTaskInst.getTaskInstId());

            uocOrderTaskInstMapper.updateBy(updateSetPo, updateWherePo);
        }

    }

    @Override
    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            uocOrderTaskInstMapper.insertBatch(UocRu.jsl(saveTaskList, UocOrderTaskInstPo.class));
        }
    }

    @Override
    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        uocOrderProcInstMapper.insert(UocRu.js(inst, UocOrderProcInstPo.class));
        return inst;
    }

    @Override
    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return UocRu.jsl(uocOrderProcInstMapper.getList(UocRu.js(inst, UocOrderProcInstPo.class)), UocOrderProcInst.class);
    }

    @Override
    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        if (ObjectUtil.isNotEmpty(dealList)) {
            uocOrderTaskDealMapper.insertBatch(UocRu.jsl(dealList, UocOrderTaskDealPo.class));
        }
    }

    @Override
    public UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog) {
        if (ObjectUtil.isNotEmpty(uocOrderStateChgLog)) {
            uocOrderStateChgLogMapper.insert(UocRu.js(uocOrderStateChgLog, UocOrderStateChgLogPo.class));
        }
        return uocOrderStateChgLog;
    }

    @Override
    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        if (ObjectUtil.isNotEmpty(taskInst)) {
            return UocRu.jsl(uocOrderTaskInstMapper.getList(UocRu.js(taskInst, UocOrderTaskInstPo.class)), UocOrderTaskInst.class);
        } else {
            return new ArrayList<>();
        }
    }

    @Override
    public UocOrderProcInst updateProInst(UocOrderProcInst inst) {
        UocOrderProcInstPo set = UocRu.js(inst, UocOrderProcInstPo.class);
        UocOrderProcInstPo where = new UocOrderProcInstPo();
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        uocOrderProcInstMapper.updateBy(set, where);
        return inst;
    }

    @Override
    public void saveOperRecord(List<UocOrderBusiOperRecord> recordList) {
        List<UocOrderBusiOperRecordPo> recordPoList = UocRu.jsl(recordList, UocOrderBusiOperRecordPo.class);
        uocOrderBusiOperRecordMapper.insertBatch(recordPoList);
    }

    @Override
    public String getOrderNoSingle(String code) {
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter(UocObjNoConstants.UOC);
        getBo.setEncodedRuleCode(code);
        getBo.setOrgType(UocObjNoConstants.ORG_TYPE);
        CfcEncodedSerialGetServiceRspBO encodedSerial = encodedSerialGetService.getEncodedSerial(getBo);
        if (CollectionUtils.isEmpty(encodedSerial.getSerialNoList()) || StringUtils.isBlank(encodedSerial.getSerialNoList().get(0))) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "获取单据编号为空");
        }
        return encodedSerial.getSerialNoList().get(0);
    }

    @Override
    public void updateTaskInst(UocOrderTaskInst inst) {
        UocOrderTaskInstPo set = UocRu.js(inst, UocOrderTaskInstPo.class);
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setTaskInstId(inst.getTaskInstId());
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        where.setId(inst.getId());
        uocOrderTaskInstMapper.updateBy(set, where);
    }
}
