package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrderItemSnapshotMapPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrderItemSnapshotMapMapper
 * 说明:明细快照扩展
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocOrderItemSnapshotMapMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocOrderItemSnapshotMapPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocOrderItemSnapshotMapPo uocOrderItemSnapshotMapPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocOrderItemSnapshotMapPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocOrderItemSnapshotMapPo uocOrderItemSnapshotMapPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocOrderItemSnapshotMapPo set, @Param("where") UocOrderItemSnapshotMapPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocOrderItemSnapshotMapPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocOrderItemSnapshotMapPo uocOrderItemSnapshotMapPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocOrderItemSnapshotMapPo 参数对象
	 * @return UocOrderItemSnapshotMapPo 结果对象
	 */
	UocOrderItemSnapshotMapPo getModelBy(UocOrderItemSnapshotMapPo uocOrderItemSnapshotMapPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocOrderItemSnapshotMapPo 参数对象
	 * @return List<UocOrderItemSnapshotMapPo> 结果对象
	 */
	List<UocOrderItemSnapshotMapPo> getList(UocOrderItemSnapshotMapPo uocOrderItemSnapshotMapPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocOrderItemSnapshotMapPo 参数对象
	 * @param page 分页参数
	 * @return List<UocOrderItemSnapshotMapPo> 结果对象
	 */
	List<UocOrderItemSnapshotMapPo> getListPage(UocOrderItemSnapshotMapPo uocOrderItemSnapshotMapPo, Page<UocOrderItemSnapshotMapPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocOrderItemSnapshotMapPo> list);

}
