package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrderItemPo;
import com.tydic.dyc.oc.repository.po.UocOrderPo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderItemPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrderItemMapper
 * 说明:销售订单明细
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocOrderItemMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocOrderItemPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocOrderItemPo uocOrderItemPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocOrderItemPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocOrderItemPo uocOrderItemPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocOrderItemPo set, @Param("where") UocOrderItemPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocOrderItemPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocOrderItemPo uocOrderItemPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocOrderItemPo 参数对象
	 * @return UocOrderItemPo 结果对象
	 */
	UocOrderItemPo getModelBy(UocOrderItemPo uocOrderItemPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocOrderItemPo 参数对象
	 * @return List<UocOrderItemPo> 结果对象
	 */
	List<UocOrderItemPo> getList(UocOrderItemPo uocOrderItemPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocOrderItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocOrderItemPo> 结果对象
	 */
	List<UocOrderItemPo> getListPage(UocOrderItemPo uocOrderItemPo, Page<UocOrderItemPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocOrderItemPo> list);

	/**
	 * 描述：订单明细销售总金额统计
	 *
	 * @author: daiyuanyuan
	 * @date:   2022-04-06 19:29
	 */
	UocOrderPo getOrderItemTotalSalePrice(UocOrderPo uocOrderPo);
	/**
	 * 描述：更新订单明销售单价 sale_fee  sale_price
	 *
	 * @author: daiyuanyuan
	 * @date:   2022-04-02 16:00
	 */
	void modifyBatchItemSalePrice(@Param("list") List<UocOrderItemPo> list, @Param("uocOrderItemPo") UocOrderItemPo uocOrderItemPo);

}
