package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocInspOrderMapPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocInspOrderMapMapper
 * 说明:验收单扩展
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocInspOrderMapMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocInspOrderMapPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocInspOrderMapPo uocInspOrderMapPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocInspOrderMapPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocInspOrderMapPo uocInspOrderMapPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocInspOrderMapPo set, @Param("where") UocInspOrderMapPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocInspOrderMapPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocInspOrderMapPo uocInspOrderMapPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocInspOrderMapPo 参数对象
	 * @return UocInspOrderMapPo 结果对象
	 */
	UocInspOrderMapPo getModelBy(UocInspOrderMapPo uocInspOrderMapPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocInspOrderMapPo 参数对象
	 * @return List<UocInspOrderMapPo> 结果对象
	 */
	List<UocInspOrderMapPo> getList(UocInspOrderMapPo uocInspOrderMapPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocInspOrderMapPo 参数对象
	 * @param page 分页参数
	 * @return List<UocInspOrderMapPo> 结果对象
	 */
	List<UocInspOrderMapPo> getListPage(UocInspOrderMapPo uocInspOrderMapPo, Page<UocInspOrderMapPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocInspOrderMapPo> list);

}
