/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipItemMap;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderMap;
import com.tydic.dyc.oc.repository.UocShipOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocShipItemMapMapper;
import com.tydic.dyc.oc.repository.dao.UocShipOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocShipOrderMapMapper;
import com.tydic.dyc.oc.repository.dao.UocShipOrderMapper;
import com.tydic.dyc.oc.repository.po.UocShipItemMapPo;
import com.tydic.dyc.oc.repository.po.UocShipOrderItemPo;
import com.tydic.dyc.oc.repository.po.UocShipOrderMapPo;
import com.tydic.dyc.oc.repository.po.UocShipOrderPo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocShipOrderRepositoryImpl
implements UocShipOrderRepository {
    @Autowired
    private UocShipOrderMapper uocShipOrderMapper;
    @Autowired
    private UocShipOrderMapMapper uocShipOrderMapMapper;
    @Autowired
    private UocShipOrderItemMapper uocShipOrderItemMapper;
    @Autowired
    private UocShipItemMapMapper uocShipItemMapMapper;

    public void createShipOrder(UocShipOrderDo uocShipOrderDo) {
        this.uocShipOrderMapper.insert((UocShipOrderPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderPo.class));
        this.uocShipOrderItemMapper.insertBatch(UocRu.jsl((List)uocShipOrderDo.getShipOrderItemBoList(), UocShipOrderItemPo.class));
        if (!CollectionUtils.isEmpty((Collection)uocShipOrderDo.getExtParallelBoList())) {
            this.uocShipOrderMapMapper.insertBatch(UocRu.jsl((List)uocShipOrderDo.getExtParallelBoList(), UocShipOrderMapPo.class));
        }
        ArrayList uocShipItemMapList = new ArrayList();
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            if (!CollectionUtils.isEmpty((Collection)uocShipOrderItem.getItemExtParallelBoList())) {
                uocShipItemMapList.addAll(uocShipOrderItem.getItemExtParallelBoList());
            }
        });
        if (!CollectionUtils.isEmpty(uocShipItemMapList)) {
            this.uocShipItemMapMapper.insertBatch(UocRu.jsl(uocShipItemMapList, UocShipItemMapPo.class));
        }
    }

    public void modifyBatchShipOrderArrivaRefuse(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo where = new UocShipOrderPo();
        where.setShipOrderIdList(uocShipOrderDo.getShipOrderIdList());
        where.setOrderId(uocShipOrderDo.getOrderId());
        where.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        this.uocShipOrderMapper.updateBy((UocShipOrderPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderPo.class), where);
    }

    public void modifyArrivaShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            this.uocShipOrderItemMapper.updateItemArriveCount((UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    public void modifyRefuseShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            this.uocShipOrderItemMapper.updateItemRefuseCount((UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    public UocShipOrderDo getListShipOrderItem(UocShipOrderItemQryBo uocShipOrderItemQryBo) {
        List<UocShipOrderItemPo> uocShipOrderItemPoList;
        UocShipOrderDo uocShipOrderRspDo = new UocShipOrderDo();
        List<UocShipOrderPo> list = this.uocShipOrderMapper.getList((UocShipOrderPo)UocRu.js((Object)uocShipOrderItemQryBo, UocShipOrderPo.class));
        if (ObjectUtil.isNotEmpty(list)) {
            uocShipOrderRspDo = (UocShipOrderDo)UocRu.js((Object)list.get(0), UocShipOrderDo.class);
        }
        if (ObjectUtil.isNotEmpty(uocShipOrderItemPoList = this.uocShipOrderItemMapper.getList((UocShipOrderItemPo)UocRu.js((Object)uocShipOrderItemQryBo, UocShipOrderItemPo.class)))) {
            uocShipOrderRspDo.setShipOrderItemBoList(UocRu.jsl(uocShipOrderItemPoList, UocShipOrderItem.class));
            List<Long> shipOrderItemIdList = uocShipOrderItemPoList.stream().map(UocShipOrderItemPo::getShipOrderItemId).filter(Objects::nonNull).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(shipOrderItemIdList)) {
                UocShipItemMapPo uocShipItemMapPo = new UocShipItemMapPo();
                uocShipItemMapPo.setSaleOrderItemIdList(shipOrderItemIdList);
                List<UocShipItemMapPo> uocShipItemMapPoList = this.uocShipItemMapMapper.getList(uocShipItemMapPo);
                if (ObjectUtil.isNotEmpty(uocShipItemMapPoList)) {
                    ConcurrentMap<Long, List<UocShipItemMapPo>> uocShipItemMap = uocShipItemMapPoList.stream().collect(Collectors.groupingByConcurrent(UocShipItemMapPo::getShipOrderItemId));
                    uocShipOrderRspDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> uocShipOrderItem.setItemExtParallelBoList(UocRu.jsl((List)((List)uocShipItemMap.get(uocShipOrderItem.getShipOrderItemId())), UocShipItemMap.class)));
                }
            }
        }
        return uocShipOrderRspDo;
    }

    public void modifyShipOrderMain(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo where = new UocShipOrderPo();
        where.setOrderId(uocShipOrderDo.getOrderId());
        where.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        where.setShipOrderIdList(uocShipOrderDo.getShipOrderIdList());
        this.uocShipOrderMapper.updateBy((UocShipOrderPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderPo.class), where);
    }

    public void modifyBatchShipOrderItemInspCount(UocShipOrderDo uocShipOrderDo) {
        this.uocShipOrderItemMapper.updateItemInspCount(UocRu.jsl((List)uocShipOrderDo.getShipOrderItemBoList(), UocShipOrderItemPo.class), (UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class));
    }

    public UocShipOrderDo getShipOrderById(UocShipOrderQryBo uocShipOrderQryBo) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        UocShipOrderPo uocShipOrderPo = new UocShipOrderPo();
        uocShipOrderPo.setShipOrderId(uocShipOrderQryBo.getShipOrderId());
        if (ObjectUtil.isNotEmpty((Object)uocShipOrderQryBo.getOrderId())) {
            uocShipOrderPo.setOrderId(uocShipOrderQryBo.getOrderId());
        }
        if (null != (uocShipOrderPo = this.uocShipOrderMapper.getModelBy(uocShipOrderPo))) {
            uocShipOrderDo = (UocShipOrderDo)UocRu.js((Object)uocShipOrderPo, UocShipOrderDo.class);
            UocShipOrderMapPo uocShipOrderMapPo = new UocShipOrderMapPo();
            uocShipOrderMapPo.setShipOrderId(uocShipOrderQryBo.getShipOrderId());
            List<UocShipOrderMapPo> uocShipOrderMapPoList = this.uocShipOrderMapMapper.getList(uocShipOrderMapPo);
            if (!CollectionUtils.isEmpty(uocShipOrderMapPoList)) {
                uocShipOrderDo.setExtParallelBoList(UocRu.jsl(uocShipOrderMapPoList, UocShipOrderMap.class));
            }
        } else {
            return null;
        }
        return uocShipOrderDo;
    }

    public List<UocShipOrderDo> getListShipOrder(UocShipOrderQryBo uocShipOrderQryBo) {
        List<UocShipOrderPo> uocShipOrderPoList = this.uocShipOrderMapper.getList((UocShipOrderPo)UocRu.js((Object)uocShipOrderQryBo, UocShipOrderPo.class));
        return UocRu.jsl(uocShipOrderPoList, UocShipOrderDo.class);
    }

    public UocShipOrderDo getShipOrderNo(UocShipOrderDo uocShipOrderDo) {
        return null;
    }

    public void modifyShipOrderItemChngingCount(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo && !CollectionUtils.isEmpty((Collection)uocShipOrderDo.getShipOrderItemBoList())) {
            this.uocShipOrderItemMapper.updateItemChngingCount(UocRu.jsl((List)uocShipOrderDo.getShipOrderItemBoList(), UocShipOrderItemPo.class), (UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    public void modifyItemReturnCountConfirm(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            this.uocShipOrderItemMapper.updateItemReturnCountByChngingCount((UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    public void modifyItemChngCountRefuse(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            this.uocShipOrderItemMapper.updateItemReturnCountZero((UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    public void updateShipStatusAndProCode(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo set = new UocShipOrderPo();
        if (!StringUtils.isBlank((CharSequence)uocShipOrderDo.getProcState())) {
            set.setProcState(uocShipOrderDo.getProcState());
        }
        set.setShipOrderState(uocShipOrderDo.getShipOrderState());
        UocShipOrderPo where = new UocShipOrderPo();
        where.setOrderId(uocShipOrderDo.getOrderId());
        where.setShipOrderId(uocShipOrderDo.getShipOrderId());
        this.uocShipOrderMapper.updateBy(set, where);
    }

    public void addShipOrderMap(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo && !CollectionUtils.isEmpty((Collection)uocShipOrderDo.getExtParallelBoList())) {
            this.uocShipOrderMapMapper.insertBatch(UocRu.jsl((List)uocShipOrderDo.getExtParallelBoList(), UocShipOrderMapPo.class));
        }
    }

    public void updateBatchValue(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo && !CollectionUtils.isEmpty((Collection)uocShipOrderDo.getExtParallelBoList())) {
            this.uocShipOrderMapMapper.updateBatchValue(UocRu.jsl((List)uocShipOrderDo.getExtParallelBoList(), UocShipOrderMapPo.class), (UocShipOrderMapPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderMapPo.class));
        }
    }

    public void updateInvalid(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            this.uocShipOrderMapMapper.updateInvalid((UocShipOrderMapPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderMapPo.class));
        }
    }

    public void modifyShipOrderItemInspCountEqualArrivalCount(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo uocShipOrderItemPo = (UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class);
        this.uocShipOrderItemMapper.modifyShipOrderItemInspCountEqualArrivalCount(uocShipOrderItemPo);
    }

    public void modifyItemArriveCountConfirm(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo uocShipOrderItemPo = (UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class);
        this.uocShipOrderItemMapper.modifyItemArriveCountConfirm(uocShipOrderItemPo);
    }

    public void modifyItemRefuseCountConfirm(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo uocShipOrderItemPo = (UocShipOrderItemPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderItemPo.class);
        this.uocShipOrderItemMapper.modifyItemRefuseCountConfirm(uocShipOrderItemPo);
    }

    public void modifyShipArrivtime(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderMapPo uocShipOrderMapPo = (UocShipOrderMapPo)UocRu.js((Object)uocShipOrderDo, UocShipOrderMapPo.class);
        this.uocShipOrderMapMapper.updateByShipOrderId(uocShipOrderMapPo);
    }

    public void modifyItemArriveCount(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo set = new UocShipOrderItemPo();
        set.setArriveCount(((UocShipOrderItem)uocShipOrderDo.getShipOrderItemBoList().get(0)).getArriveCount());
        UocShipOrderItemPo where = new UocShipOrderItemPo();
        where.setShipOrderItemId((Long)uocShipOrderDo.getShipOrderItemIdList().get(0));
        this.uocShipOrderItemMapper.updateItemArriveCountAndRefuseAccount(set, where);
    }
}

