package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipItemMap;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderMap;
import com.tydic.dyc.oc.repository.UocShipOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocShipItemMapMapper;
import com.tydic.dyc.oc.repository.dao.UocShipOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocShipOrderMapMapper;
import com.tydic.dyc.oc.repository.dao.UocShipOrderMapper;
import com.tydic.dyc.oc.repository.po.UocShipItemMapPo;
import com.tydic.dyc.oc.repository.po.UocShipOrderItemPo;
import com.tydic.dyc.oc.repository.po.UocShipOrderMapPo;
import com.tydic.dyc.oc.repository.po.UocShipOrderPo;
import com.tydic.dyc.oc.utils.UocRu;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/**
 * 标题:UocShipOrderRepositoryImpl
 * 说明:发货单
 * 时间:2022/2/21 18:54
 * 作者:罗有
 */

@Service
public class UocShipOrderRepositoryImpl implements UocShipOrderRepository {

    @Autowired
    private UocShipOrderMapper uocShipOrderMapper;
    @Autowired
    private UocShipOrderMapMapper uocShipOrderMapMapper;
    @Autowired
    private UocShipOrderItemMapper uocShipOrderItemMapper;
    @Autowired
    private UocShipItemMapMapper uocShipItemMapMapper;

    @Override
    public void createShipOrder(UocShipOrderDo uocShipOrderDo) {
        uocShipOrderMapper.insert(UocRu.js(uocShipOrderDo, UocShipOrderPo.class));
        uocShipOrderItemMapper.insertBatch(UocRu.jsl(uocShipOrderDo.getShipOrderItemBoList(), UocShipOrderItemPo.class));
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getExtParallelBoList())) {
            uocShipOrderMapMapper.insertBatch(UocRu.jsl(uocShipOrderDo.getExtParallelBoList(), UocShipOrderMapPo.class));
        }
        List<UocShipItemMap> uocShipItemMapList = new ArrayList<>();
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            if (!CollectionUtils.isEmpty(uocShipOrderItem.getItemExtParallelBoList())) {
                uocShipItemMapList.addAll(uocShipOrderItem.getItemExtParallelBoList());
            }
        });
        if (!CollectionUtils.isEmpty(uocShipItemMapList)) {
            uocShipItemMapMapper.insertBatch(UocRu.jsl(uocShipItemMapList, UocShipItemMapPo.class));
        }
    }

    @Override
    public void modifyBatchShipOrderArrivaRefuse(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo where = new UocShipOrderPo();
        where.setShipOrderIdList(uocShipOrderDo.getShipOrderIdList());
        where.setOrderId(uocShipOrderDo.getOrderId());
        where.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocShipOrderMapper.updateBy(UocRu.js(uocShipOrderDo, UocShipOrderPo.class), where);
    }

    @Override
    public void modifyArrivaShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            uocShipOrderItemMapper.updateItemArriveCount(UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    @Override
    public void modifyRefuseShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            uocShipOrderItemMapper.updateItemRefuseCount(UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    @Override
    public UocShipOrderDo getListShipOrderItem(UocShipOrderItemQryBo uocShipOrderItemQryBo) {
        UocShipOrderDo uocShipOrderRspDo = new UocShipOrderDo();
        List<UocShipOrderPo> list = uocShipOrderMapper.getList(UocRu.js(uocShipOrderItemQryBo, UocShipOrderPo.class));
        if (ObjectUtil.isNotEmpty(list)) {
            uocShipOrderRspDo = UocRu.js(list.get(0), UocShipOrderDo.class);
        }
        List<UocShipOrderItemPo> uocShipOrderItemPoList = uocShipOrderItemMapper.getList(UocRu.js(uocShipOrderItemQryBo, UocShipOrderItemPo.class));
        if (ObjectUtil.isNotEmpty(uocShipOrderItemPoList)) {
            uocShipOrderRspDo.setShipOrderItemBoList(UocRu.jsl(uocShipOrderItemPoList, UocShipOrderItem.class));
            List<Long> shipOrderItemIdList = uocShipOrderItemPoList.stream().map(UocShipOrderItemPo::getShipOrderItemId).filter(Objects::nonNull).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(shipOrderItemIdList)) {
                UocShipItemMapPo uocShipItemMapPo = new UocShipItemMapPo();
                uocShipItemMapPo.setSaleOrderItemIdList(shipOrderItemIdList);
                List<UocShipItemMapPo> uocShipItemMapPoList = uocShipItemMapMapper.getList(uocShipItemMapPo);
                if (ObjectUtil.isNotEmpty(uocShipItemMapPoList)) {
                    ConcurrentMap<Long, List<UocShipItemMapPo>> uocShipItemMap = uocShipItemMapPoList.stream().collect(Collectors.groupingByConcurrent(UocShipItemMapPo::getShipOrderItemId));
                    uocShipOrderRspDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> uocShipOrderItem.setItemExtParallelBoList(UocRu.jsl(uocShipItemMap.get(uocShipOrderItem.getShipOrderItemId()), UocShipItemMap.class)));
                }
            }
        }
        return uocShipOrderRspDo;
    }

    @Override
    public void modifyShipOrderMain(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo where = new UocShipOrderPo();
        where.setOrderId(uocShipOrderDo.getOrderId());
        where.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        where.setShipOrderIdList(uocShipOrderDo.getShipOrderIdList());
        uocShipOrderMapper.updateBy(UocRu.js(uocShipOrderDo, UocShipOrderPo.class), where);
    }

    @Override
    public void modifyBatchShipOrderItemInspCount(UocShipOrderDo uocShipOrderDo) {
        uocShipOrderItemMapper.updateItemInspCount(UocRu.jsl(uocShipOrderDo.getShipOrderItemBoList(), UocShipOrderItemPo.class), UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class));
    }

    @Override
    public UocShipOrderDo getShipOrderById(UocShipOrderQryBo uocShipOrderQryBo) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        UocShipOrderPo uocShipOrderPo = new UocShipOrderPo();
        uocShipOrderPo.setShipOrderId(uocShipOrderQryBo.getShipOrderId());
        if (ObjectUtil.isNotEmpty(uocShipOrderQryBo.getOrderId())) {
            uocShipOrderPo.setOrderId(uocShipOrderQryBo.getOrderId());
        }
        uocShipOrderPo = uocShipOrderMapper.getModelBy(uocShipOrderPo);
        if (null != uocShipOrderPo) {
            uocShipOrderDo = UocRu.js(uocShipOrderPo, UocShipOrderDo.class);
            UocShipOrderMapPo uocShipOrderMapPo = new UocShipOrderMapPo();
            uocShipOrderMapPo.setShipOrderId(uocShipOrderQryBo.getShipOrderId());
            List<UocShipOrderMapPo> uocShipOrderMapPoList = uocShipOrderMapMapper.getList(uocShipOrderMapPo);
            if (!CollectionUtils.isEmpty(uocShipOrderMapPoList)) {
                uocShipOrderDo.setExtParallelBoList(UocRu.jsl(uocShipOrderMapPoList, UocShipOrderMap.class));
            }
        } else {
            return null;
        }
        return uocShipOrderDo;
    }

    @Override
    public List<UocShipOrderDo> getListShipOrder(UocShipOrderQryBo uocShipOrderQryBo) {
        List<UocShipOrderPo> uocShipOrderPoList = uocShipOrderMapper.getList(UocRu.js(uocShipOrderQryBo, UocShipOrderPo.class));
        return UocRu.jsl(uocShipOrderPoList, UocShipOrderDo.class);
    }

    @Override
    public UocShipOrderDo getShipOrderNo(UocShipOrderDo uocShipOrderDo) {
        return null;
    }

    @Override
    public void modifyShipOrderItemChngingCount(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo && !CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            uocShipOrderItemMapper.updateItemChngingCount(UocRu.jsl(uocShipOrderDo.getShipOrderItemBoList(), UocShipOrderItemPo.class), UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    @Override
    public void modifyItemReturnCountConfirm(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            uocShipOrderItemMapper.updateItemReturnCountByChngingCount(UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    @Override
    public void modifyItemChngCountRefuse(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            uocShipOrderItemMapper.updateItemReturnCountZero(UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class));
        }
    }

    @Override
    public void updateShipStatusAndProCode(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderPo set = new UocShipOrderPo();
        if (!StringUtils.isBlank(uocShipOrderDo.getProcState())) {
            set.setProcState(uocShipOrderDo.getProcState());
        }
        set.setShipOrderState(uocShipOrderDo.getShipOrderState());
        UocShipOrderPo where = new UocShipOrderPo();
        where.setOrderId(uocShipOrderDo.getOrderId());
        where.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderMapper.updateBy(set, where);
    }

    @Override
    public void addShipOrderMap(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo && !CollectionUtils.isEmpty(uocShipOrderDo.getExtParallelBoList())) {
            uocShipOrderMapMapper.insertBatch(UocRu.jsl(uocShipOrderDo.getExtParallelBoList(), UocShipOrderMapPo.class));
        }
    }

    @Override
    public void updateBatchValue(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo && !CollectionUtils.isEmpty(uocShipOrderDo.getExtParallelBoList())) {
            uocShipOrderMapMapper.updateBatchValue(UocRu.jsl(uocShipOrderDo.getExtParallelBoList(), UocShipOrderMapPo.class), UocRu.js(uocShipOrderDo, UocShipOrderMapPo.class));
        }
    }

    @Override
    public void updateInvalid(UocShipOrderDo uocShipOrderDo) {
        if (null != uocShipOrderDo) {
            uocShipOrderMapMapper.updateInvalid(UocRu.js(uocShipOrderDo, UocShipOrderMapPo.class));
        }
    }

    @Override
    public void modifyShipOrderItemInspCountEqualArrivalCount(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo uocShipOrderItemPo = UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class);
        uocShipOrderItemMapper.modifyShipOrderItemInspCountEqualArrivalCount(uocShipOrderItemPo);
    }

    @Override
    public void modifyItemArriveCountConfirm(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo uocShipOrderItemPo = UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class);
        uocShipOrderItemMapper.modifyItemArriveCountConfirm(uocShipOrderItemPo);
    }

    @Override
    public void modifyItemRefuseCountConfirm(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo uocShipOrderItemPo = UocRu.js(uocShipOrderDo, UocShipOrderItemPo.class);
        uocShipOrderItemMapper.modifyItemRefuseCountConfirm(uocShipOrderItemPo);
    }
    
    @Override
    public void modifyShipArrivtime(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderMapPo uocShipOrderMapPo = UocRu.js(uocShipOrderDo, UocShipOrderMapPo.class);
        uocShipOrderMapMapper.updateByShipOrderId(uocShipOrderMapPo);
    }
    
    @Override
    public void modifyItemArriveCount(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemPo set = new UocShipOrderItemPo();
        set.setArriveCount(uocShipOrderDo.getShipOrderItemBoList().get(0).getArriveCount());
        set.setRefuseCount(uocShipOrderDo.getShipOrderItemBoList().get(0).getRefuseCount());
        
        UocShipOrderItemPo where = new UocShipOrderItemPo();
        where.setShipOrderItemId(uocShipOrderDo.getShipOrderItemIdList().get(0));
        uocShipOrderItemMapper.updateItemArriveCountAndRefuseAccount(set,where);
    }
    
}
