package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.repository.UocOrderRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocOrderRepositoryImpl
 * 说明:订单
 * 时间:2022/2/21 18:53
 * 作者:罗有
 */

@Service
public class UocOrderRepositoryImpl implements UocOrderRepository {

    @Autowired
    private UocOrderMapper uocOrderMapper;

    @Autowired
    private UocOrderMapMapper uocOrderMapMapper;

    @Autowired
    private UocOrdInvoiceMapper uocOrdInvoiceMapper;

    @Autowired
    private UocSaleStakeholderMapper uocSaleStakeholderMapper;

    @Autowired
    private UocOrderItemMapper uocOrderItemMapper;

    @Autowired
    private UocOrderItemMapMapper uocOrderItemMapMapper;

    @Autowired
    private UocOrderItemEwMapper uocOrderItemEwMapper;

    @Autowired
    private UocOrderItemSnapshotMapMapper uocOrderItemSnapshotMapMapper;

    @Autowired
    private UocOrdLogisticsRelaMapper uocOrdLogisticsRelaMapper;

    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;

    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;

    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;

    @Autowired
    private UocOrderItemSnapshotMapper uocOrderItemSnapshotMapper;

    @Autowired
    private UocOrderStateChgLogMapper uocOrderStateChgLogMapper;

    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;

    @Autowired
    private UocOrderRelMapper uocOrderRelMapper;

    @Autowired
    private UocOrderCheckAccountMapper uocOrderCheckAccountMapper;

    @Autowired
    private UocOrderAgreementMapper uocOrderAgreementMapper;

    @Autowired
    private UocOrderQueryIndexMapper uocOrderQueryIndexMapper;

    @Autowired
    private UocConfEvaluateMapper uocConfEvaluateMapper;

    @Autowired
    private UocConfTabOrdStateMapper uocConfTabOrdStateMapper;

    @Autowired
    private UocConfButtonMapper uocConfButtonMapper;

    @Autowired
    private UocOrderMsgPoolMapper uocOrderMsgPoolMapper;

    @Autowired
    private ConfSupplierMapper confSupplierMapper;
    @Autowired
    private UocConfInspectionUseMapper uocConfInspectionUseMapper;
    @Autowired
    private UocConfInspectionMapper uocConfInspectionMapper;

    @Autowired
    private UocOrdEvaluateMapper uocOrdEvaluateMapper;

    @Autowired
    private UocTacheButtonMapper uocTacheButtonMapper;

    @Autowired
    private UocConfEffectiveMapper uocConfEffectiveMapper;

    @Override
    public UocOrderDo saveUocOrder(UocOrderDo orderDo) {
        //保存地址信息（收货地址，发票地址）
        if (orderDo.getInvoiceAddress() != null) {
            uocOrdLogisticsRelaMapper.insert(UocRu.js(orderDo.getInvoiceAddress(), UocOrdLogisticsRelaPo.class));
        }
        if (orderDo.getReceiverAddress() != null) {
            uocOrdLogisticsRelaMapper.insert(UocRu.js(orderDo.getReceiverAddress(), UocOrdLogisticsRelaPo.class));
        }

        //保存订单主数据
        //转换，并保存订单主体数据
        uocOrderMapper.insert(UocRu.js(orderDo, UocOrderPo.class));

        //保存订单扩展数据
        if (ObjectUtil.isNotEmpty(orderDo.getOrderExt())) {
            uocOrderMapMapper.insertBatch(UocRu.jsl(orderDo.getOrderExt(), UocOrderMapPo.class));
        }

        //保存三方信息
        saveStakeholder(orderDo);

        //保存发票信息
        if (ObjectUtil.isNotEmpty(orderDo.getUocOrdInvoice())) {
            uocOrdInvoiceMapper.insert(UocRu.js(orderDo.getUocOrdInvoice(), UocOrdInvoicePo.class));
        }

        //保存附件信息
        if (ObjectUtil.isNotEmpty(orderDo.getAccessoryList())) {
            uocOrderAccessoryMapper.insertBatch(UocRu.jsl(orderDo.getAccessoryList(), UocOrderAccessoryPo.class));
        }

        //保存订单明细信息
        saveOrderItemData(orderDo);

        return orderDo;
    }

    @Override
    public UocOrderDo createOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList) {
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setAccessoryList(uocOrderAccessoryList);
        uocOrderAccessoryMapper.insertBatch(UocRu.jsl(uocOrderAccessoryList, UocOrderAccessoryPo.class));
        return uocOrderDo;
    }

    @Override
    public UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog) {
        uocOrderStateChgLogMapper.insert(UocRu.js(uocOrderStateChgLog, UocOrderStateChgLogPo.class));
        return uocOrderStateChgLog;
    }

    @Override
    public List<UocOrderStakeholderQryBo> qryStakeholderList(UocOrderStakeholderQryBo qryBo) {
        return UocRu.jsl(uocSaleStakeholderMapper.getList(UocRu.js(qryBo, UocSaleStakeholderPo.class)), UocOrderStakeholderQryBo.class);
    }


    private void saveOrderItemData(UocOrderDo orderDo) {
        //订单明细数据
        List<UocOrderItem> orderItems = orderDo.getOrderItems();

        List<UocOrderItemPo> ordItemList = new ArrayList<>();
        List<UocOrderItemMapPo> itemExtList = new ArrayList<>();
        List<UocOrderItemEwPo> itemEwList = new ArrayList<>();
        List<UocOrderItemSnapshotPo> itemCommList = new ArrayList<>();
        Map<String, UocOrderAgreementPo> agrPoMap = new HashMap<>();

        for (UocOrderItem orderItem : orderItems) {
            ordItemList.add(UocRu.js(orderItem, UocOrderItemPo.class));

            //订单明细扩展数据，可能为空
            List<UocOrderItemMap> itemMapList = orderItem.getItemMapList();
            if (ObjectUtil.isNotEmpty(itemMapList)) {
                itemExtList.addAll(UocRu.jsl(itemMapList, UocOrderItemMapPo.class));
            }

            //商品延保数据，可能为空
            List<UocOrderItemEw> ewList = orderItem.getEwList();
            if (ObjectUtil.isNotEmpty(ewList)) {
                itemEwList.addAll(UocRu.jsl(ewList, UocOrderItemEwPo.class));
            }

            if (ObjectUtil.isNotEmpty(orderItem.getCommJsonStr())) {
                UocOrderItemSnapshotPo commPo = new UocOrderItemSnapshotPo();
                commPo.setId(IdUtil.nextId());
                commPo.setOrderId(orderDo.getOrderId());
                commPo.setOrderItemId(orderItem.getOrderItemId());
                commPo.setSkuId(orderItem.getSkuId());
                commPo.setJsonStr(orderItem.getCommJsonStr());
                commPo.setCreateOperId(orderDo.getCreateOperId());
                commPo.setCreateTime(orderDo.getCreateTime());
                itemCommList.add(commPo);
            }

            if (ObjectUtil.isNotEmpty(orderItem.getAgreementId()) && ObjectUtil.isNotEmpty(orderItem.getAgrBo())) {
                agrPoMap.put(orderItem.getAgreementId(), JUtil.js(orderItem.getAgrBo(), UocOrderAgreementPo.class));
            }

        }

        //保存协议数据
        if (ObjectUtil.isNotEmpty(agrPoMap)) {
            List<UocOrderAgreementPo> agrPoList = new ArrayList<>(agrPoMap.values());
            uocOrderAgreementMapper.insertBatch(agrPoList);
        }

        uocOrderItemMapper.insertBatch(ordItemList);
        if (ObjectUtil.isNotEmpty(itemExtList)) {
            uocOrderItemMapMapper.insertBatch(itemExtList);
        }
        if (ObjectUtil.isNotEmpty(itemEwList)) {
            uocOrderItemEwMapper.insertBatch(itemEwList);
        }
        if (ObjectUtil.isNotEmpty(itemCommList)) {
            uocOrderItemSnapshotMapper.insertBatch(itemCommList);
        }
    }

    private void saveStakeholder(UocOrderDo orderDo) {
        List<UocOrderItem> orderItems = orderDo.getOrderItems();
        UocOrderOperating operating = orderDo.getOperating();
        //根据供应商id拆分，组装三方表数据
        Map<String, List<UocOrderItem>> supplierMap = orderItems.stream().collect(Collectors.groupingBy(UocOrderItem::getSupplierId));
        List<UocSaleStakeholderPo> operatingList = new ArrayList<>(supplierMap.size());
        for (Map.Entry<String, List<UocOrderItem>> entry : supplierMap.entrySet()) {
            UocOrderItem supOrderItem = entry.getValue().get(0);
            //先复制运营方信息
            UocSaleStakeholderPo operatingPo = UocRu.js(operating, UocSaleStakeholderPo.class);
            operatingPo.setOrderId(orderDo.getOrderId());
            operatingPo.setStakeholderId(IdUtil.nextId());

            //采购方信息
            operatingPo.setPurAccount(orderDo.getPurAccount());
            operatingPo.setPurAccountName(orderDo.getPurAccountName());
            operatingPo.setPurMobile(orderDo.getPurMobile());
            operatingPo.setPurUserId(orderDo.getCreateOperId());
            operatingPo.setPurName(orderDo.getName());
            operatingPo.setPurUserName(orderDo.getUsername());
            operatingPo.setPurCompanyId(orderDo.getCompanyId() != null ? orderDo.getCompanyId().toString() : null);
//            operatingPo.setPurCompanyNo(orderDo.getCompanyName());
            operatingPo.setPurCompanyName(orderDo.getCompanyName());
            operatingPo.setPurOrgId(orderDo.getOrgId() != null ? orderDo.getOrgId().toString() : null);
//            operatingPo.setPurOrgNo(orderDo.getOrgName());
            operatingPo.setPurOrgName(orderDo.getOrgName());
            operatingPo.setPurOrgPath(orderDo.getOrgPath());
            operatingPo.setPurNeedMobile(orderDo.getPurNeedMobile());
            operatingPo.setPurNeedName(orderDo.getPurNeedName());

            //供应商信息
            operatingPo.setSupId(supOrderItem.getSupplierId());
            operatingPo.setSupName(supOrderItem.getSupplierName());
            operatingPo.setSupRelaName(supOrderItem.getSupRelaName());
            operatingPo.setSupRelaMobile(supOrderItem.getSupRelaMobile());

            //协议经办人
//            operatingPo.setProDeliveryId(supOrderItem.getProDeliveryId());
//            operatingPo.setProDeliveryName(supOrderItem.getProDeliveryName());

            operatingPo.setDelTag(UocDicConstant.DELETE_TAG.NO_DEL);

            operatingList.add(operatingPo);
        }
        uocSaleStakeholderMapper.insertBatch(operatingList);
    }

    @Override
    public List<UocOrderTaskInst> qryOrderTaskInstList(UocOrderTaskInstQryBo qryBo) {
        List<UocOrderTaskInstPo> uocOrderTaskInstPoList = uocOrderTaskInstMapper.getList(UocRu.js(qryBo, UocOrderTaskInstPo.class));
        return ObjectUtil.isNotEmpty(uocOrderTaskInstPoList) ? UocRu.jsl(uocOrderTaskInstPoList, UocOrderTaskInst.class) : new ArrayList<>();
    }

    @Override
    public List<UocOrderTaskDeal> qryOrderTaskDealList(UocOrderTaskDealQryBo qryBo) {
        List<UocOrderTaskDealPo> uocOrderTaskDealPoList = uocOrderTaskDealMapper.getList(UocRu.js(qryBo, UocOrderTaskDealPo.class));
        return ObjectUtil.isNotEmpty(uocOrderTaskDealPoList) ? UocRu.jsl(uocOrderTaskDealPoList, UocOrderTaskDeal.class) : new ArrayList<>();
    }

    @Override
    public List<UocOrderProcInst> qryOrderProcInstList(UocOrderProcInstQryBo qryBo) {
        List<UocOrderProcInstPo> uocOrderProcInstPoList = uocOrderProcInstMapper.getList(UocRu.js(qryBo, UocOrderProcInstPo.class));
        return ObjectUtil.isNotEmpty(uocOrderProcInstPoList) ? UocRu.jsl(uocOrderProcInstPoList, UocOrderProcInst.class) : new ArrayList<>();
    }

    @Override
    public UocOrderDo qryOrderBy(UocOrderDo uocOrderDo) {
        UocOrderPo uocOrderPo = uocOrderMapper.getModelBy(UocRu.js(uocOrderDo, UocOrderPo.class));
        return uocOrderPo != null ? UocRu.js(uocOrderPo, UocOrderDo.class) : null;
    }

    @Override
    public List<UocOrderItem> qryOrderItemList(UocOrderItemQryBo uocOrderItemQryBo) {
        List<UocOrderItemPo> list = uocOrderItemMapper.getList(UocRu.js(uocOrderItemQryBo, UocOrderItemPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocOrderItem.class) : new ArrayList<>();
    }

    @Override
    public UocOrdLogisticsRela qryOrderLogisticsRela(UocOrdLogisticsRelaQryBo qryBo) {
        List<UocOrdLogisticsRelaPo> list = uocOrdLogisticsRelaMapper.getList(UocRu.js(qryBo, UocOrdLogisticsRelaPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.js(list.get(0), UocOrdLogisticsRela.class) : new UocOrdLogisticsRela();
    }

    @Override
    public UocOrdInvoice qryOrderInvoice(UocOrdInvoiceQryBo qryBo) {
        UocOrdInvoicePo invoicePo = uocOrdInvoiceMapper.getModelBy(UocRu.js(qryBo, UocOrdInvoicePo.class));
        return ObjectUtil.isNotEmpty(invoicePo) ? UocRu.js(invoicePo, UocOrdInvoice.class) : new UocOrdInvoice();
    }

    @Override
    public List<UocOrderAccessory> getOrderAccessoryList(UocOrderAccessoryQryBo qryBo) {
        List<UocOrderAccessoryPo> list = uocOrderAccessoryMapper.getList(UocRu.js(qryBo, UocOrderAccessoryPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocOrderAccessory.class) : new ArrayList<>();
    }

    @Override
    public List<UocOrderMap> qryOrderMapList(UocOrderMapQryBo qryBo) {
        UocOrderMapPo uocOrderMapPo = UocRu.js(qryBo, UocOrderMapPo.class);
        List<UocOrderMapPo> uocOrderMapPoList = uocOrderMapMapper.getList(uocOrderMapPo);
        return UocRu.jsl(uocOrderMapPoList, UocOrderMap.class);
    }

    @Override
    public void dealRelUpdate(UocOrderRel qryBo) {
        UocOrderRelPo uocOrderRelPo = UocRu.js(qryBo, UocOrderRelPo.class);
        uocOrderRelMapper.updateById(uocOrderRelPo);
    }

    @Override
    public List<UocOrderQueryIndex> qryOrderQueryIndexList(UocOrderQueryIndexQryBo qryBo) {
        List<UocOrderQueryIndexPo> list = uocOrderQueryIndexMapper.getList(UocRu.js(qryBo, UocOrderQueryIndexPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocOrderQueryIndex.class) : new ArrayList<>();
    }

    @Override
    public UocOrderRel qryRelInfo(UocOrderRelQryBo qryBo) {
        UocOrderRelPo uocOrderRelPo = UocRu.js(qryBo, UocOrderRelPo.class);
        uocOrderRelPo = uocOrderRelMapper.getModelBy(uocOrderRelPo);
        return null != uocOrderRelPo ? UocRu.js(uocOrderRelPo, UocOrderRel.class) : null;
    }

    @Override
    public void createRelInfo(UocOrderRel uocOrderRel) {
        UocOrderRelPo uocOrderRelPo = UocRu.js(uocOrderRel, UocOrderRelPo.class);
        uocOrderRelMapper.insert(uocOrderRelPo);
    }

    @Override
    public UocOrderCheckAccount qryCheckInfo(UocOrderCheckAccountQryBo qryBo) {
        UocOrderCheckAccountPo uocOrderCheckAccountPo = UocRu.js(qryBo, UocOrderCheckAccountPo.class);
        uocOrderCheckAccountPo = uocOrderCheckAccountMapper.getModelBy(uocOrderCheckAccountPo);
        return UocRu.js(uocOrderCheckAccountPo, UocOrderCheckAccount.class);
    }

    @Override
    public void createCheckInfo(UocOrderCheckAccount uocOrderCheckAccount) {
        UocOrderCheckAccountPo uocOrderCheckAccountPo = UocRu.js(uocOrderCheckAccount, UocOrderCheckAccountPo.class);
        uocOrderCheckAccountMapper.insert(uocOrderCheckAccountPo);
    }

    @Override
    public void updateCheckInfo(UocOrderCheckAccount uocOrderCheckAccount) {
        UocOrderCheckAccountPo uocOrderCheckAccountPo = UocRu.js(uocOrderCheckAccount, UocOrderCheckAccountPo.class);
        uocOrderCheckAccountMapper.updateById(uocOrderCheckAccountPo);
    }

    @Override
    public void modifyBatchItemSalePrice(UocOrderDo uocOrderDo) {
        List<UocOrderItemPo> uocOrderItemPos = UocRu.jsl(uocOrderDo.getOrderItems(), UocOrderItemPo.class);
        uocOrderItemMapper.modifyBatchItemSalePrice(uocOrderItemPos, UocRu.js(uocOrderDo, UocOrderItemPo.class));
    }

    @Override
    public UocOrderDo getOrderItemTotalSalePrice(UocOrderDo uocOrderDo) {
        UocOrderPo uocOrderPo = UocRu.js(uocOrderDo, UocOrderPo.class);
        UocOrderPo po = uocOrderItemMapper.getOrderItemTotalSalePrice(uocOrderPo);
        UocOrderDo uocOrderDo1 = new UocOrderDo();
        uocOrderDo1.setTotalSaleFee(po.getTotalSaleFee());
        return uocOrderDo1;
    }

    @Override
    public void modifyOrderMain(UocOrderDo uocOrderDo) {
        UocOrderPo where = new UocOrderPo();
        where.setOrderId(uocOrderDo.getOrderId());
        uocOrderMapper.updateBy(UocRu.js(uocOrderDo, UocOrderPo.class), where);
    }

    @Override
    public BasePageRspBo<UocConfEvaluate> qryListPageConfEvaluate(UocConfEvaluateQryBo uocConfEvaluateQryBo) {
        Page<UocConfEvaluatePo> page = new Page<>(uocConfEvaluateQryBo.getPageNo(), uocConfEvaluateQryBo.getPageSize());
        List<UocConfEvaluatePo> uocConfEvaluatePoList = uocConfEvaluateMapper.getListPage(UocRu.js(uocConfEvaluateQryBo, UocConfEvaluatePo.class), page);
        BasePageRspBo<UocConfEvaluate> rspBo = new BasePageRspBo<>();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(UocRu.jsl(uocConfEvaluatePoList, UocConfEvaluate.class));
        return rspBo;
    }

    @Override
    public void addConfEvaluate(UocConfEvaluate uocConfEvaluate) {
        uocConfEvaluateMapper.insert(UocRu.js(uocConfEvaluate, UocConfEvaluatePo.class));
    }

    @Override
    public void modifyConfEvaluate(UocConfEvaluate uocConfEvaluate) {
        UocConfEvaluatePo set = UocRu.js(uocConfEvaluate, UocConfEvaluatePo.class);
        UocConfEvaluatePo where = new UocConfEvaluatePo();
        where.setEvaluateId(uocConfEvaluate.getEvaluateId());
        uocConfEvaluateMapper.updateBy(set, where);
    }

    @Override
    public void deleteConfEvaluate(UocConfEvaluate uocConfEvaluate) {
        UocConfEvaluatePo set = new UocConfEvaluatePo();
        set.setDelTag(UocDicConstant.DELETE_TAG.DELETED);
        UocConfEvaluatePo where = new UocConfEvaluatePo();
        where.setEvaluateId(uocConfEvaluate.getEvaluateId());
        uocConfEvaluateMapper.updateBy(set, where);
    }

    @Override
    public UocConfEvaluate getConfEvaluateById(Long id) {
        UocConfEvaluatePo uocConfEvaluatePo = new UocConfEvaluatePo();
        uocConfEvaluatePo.setEvaluateId(id);
        uocConfEvaluatePo = uocConfEvaluateMapper.getModelBy(uocConfEvaluatePo);
        return UocRu.js(uocConfEvaluatePo, UocConfEvaluate.class);
    }

    @Override
    public int getCheckConfEvaluate(UocConfEvaluate uocConfEvaluate) {
        return uocConfEvaluateMapper.getCheckBy(UocRu.js(uocConfEvaluate, UocConfEvaluatePo.class));
    }

    @Override
    public List<UocConfTabOrdState> qryConfTabOrdStateList(UocConfTabOrdStateQryBo qryBo) {
        List<UocConfTabOrdStatePo> list = uocConfTabOrdStateMapper.getList(UocRu.js(qryBo, UocConfTabOrdStatePo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocConfTabOrdState.class) : new ArrayList<>();
    }

    @Override
    public List<UocConfButton> qryConfButtonList(UocConfButtonQryBo qryBo) {
        List<UocConfButtonPo> list = uocConfButtonMapper.getList(UocRu.js(qryBo, UocConfButtonPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocConfButton.class) : new ArrayList<>();
    }

    @Override
    public UocConfButton updateConfButton(UocConfButton confButton) {
        UocConfButtonPo set = UocRu.js(confButton, UocConfButtonPo.class);
        UocConfButtonPo where = new UocConfButtonPo();
        where.setId(confButton.getId());
        uocConfButtonMapper.updateBy(set, where);
        return confButton;
    }

    @Override
    public int deleteConfSupplierBy(UocConfSupplier uocConfSupplier) {
        return confSupplierMapper.deleteBy(uocConfSupplier);
    }

    @Override
    public int updateConfSupplierById(UocConfSupplier uocConfSupplier) {
        return confSupplierMapper.updateById(uocConfSupplier);
    }

    @Override
    public UocConfSupplier getConfSupplierModelById(long supNo) {
        return confSupplierMapper.getModelById(supNo);
    }

    @Override
    public UocConfSupplier getConfSupplierModelBy(UocConfSupplier uocConfSupplier) {
        return confSupplierMapper.getModelBy(uocConfSupplier);
    }

    @Override
    public int addConfSupplier(UocConfSupplier uocConfSupplier) {
        return confSupplierMapper.insert(uocConfSupplier);
    }

    @Override
    public BasePageRspBo<UocConfEffective> qryListPageConfEffective(UocConfEffectiveQryBo uocConfEffectiveQryBo) {
        Page<UocConfEffectivePo> page = new Page<>(uocConfEffectiveQryBo.getPageNo(), uocConfEffectiveQryBo.getPageSize());
        List<UocConfEffectivePo> uocConfEffectivePos = uocConfEffectiveMapper.getListPage(UocRu.js(uocConfEffectiveQryBo, UocConfEffectivePo.class), page);
        BasePageRspBo<UocConfEffective> rspBo = new BasePageRspBo<>();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(UocRu.jsl(uocConfEffectivePos, UocConfEffective.class));
        return rspBo;
    }

    @Override
    public int getCheckConfEffectiveBy(UocConfEffectiveQryBo uocConfEffectiveQryBo) {
        return uocConfEffectiveMapper.getCheckBy(UocRu.js(uocConfEffectiveQryBo, UocConfEffectivePo.class));
    }

    @Override
    public void addConfEffective(UocConfEffective uocConfEffective) {
        uocConfEffectiveMapper.insert(UocRu.js(uocConfEffective, UocConfEffectivePo.class));
    }

    @Override
    public UocConfEffective getConfEffectiveBy(UocConfEffective uocConfEffective) {
        UocConfEffectivePo uocConfEffectivePo = UocRu.js(uocConfEffective, UocConfEffectivePo.class);
        return null != uocConfEffectivePo ? UocRu.js(uocConfEffectiveMapper.getModelBy(uocConfEffectivePo), UocConfEffective.class) : null;
    }

    @Override
    public void deleteConfEffective(UocConfEffective uocConfEffective) {
        UocConfEffectivePo set = new UocConfEffectivePo();
        set.setDelTag(UocDicConstant.DELETE_TAG.DELETED);
        UocConfEffectivePo where = new UocConfEffectivePo();
        where.setEffectiveId(uocConfEffective.getEffectiveId());
        uocConfEffectiveMapper.updateBy(set, where);
    }

    @Override
    public int updateEffectiveConfById(UocConfEffective effective) {
        UocConfEffectivePo set = new UocConfEffectivePo();
        set.setAging(effective.getAging());
        set.setOperatingTime(new Date());
        set.setOperatorId(effective.getOperatorId());
        set.setOperatorName(effective.getOperatorName());
        UocConfEffectivePo where = new UocConfEffectivePo();
        where.setEffectiveId(effective.getEffectiveId());
        return uocConfEffectiveMapper.updateBy(set, where);
    }

    @Override
    public int getCheckMsg(UocDMsgPoolQryBo qryBo) {
        int count = uocOrderMsgPoolMapper.getCheckBy(UocRu.js(qryBo, UocOrderMsgPoolPo.class));
        return count;
    }

    @Override
    public int insertMsgPool(UocDMsgPoolQryBo qryBo) {
        int count = uocOrderMsgPoolMapper.insert(UocRu.js(qryBo, UocOrderMsgPoolPo.class));
        return count;
    }


    @Override
    public BasePageRspBo<ConfSupplierQryBo> qryListPageConfSupplier(ConfSupplierQryBo confSupplierQryBo) {
        Page<UocConfSupplier> page = new Page<>(confSupplierQryBo.getPageNo(), confSupplierQryBo.getPageSize());
        List<UocConfSupplier> uocConfSuppliers = confSupplierMapper.getListPage(UocRu.js(confSupplierQryBo, UocConfSupplier.class), page);
        BasePageRspBo<ConfSupplierQryBo> rspBo = new BasePageRspBo<>();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(UocRu.jsl(uocConfSuppliers, ConfSupplierQryBo.class));
        return rspBo;
    }

    @Override
    public List<UocConfInspectionUse> qryInspectionConfigUseList(UocConfInspectionUse uocConfInspectionUse) {
        UocConfInspectionUsePo uocConfInspectionUsePo = UocRu.js(uocConfInspectionUse, UocConfInspectionUsePo.class);
        List<UocConfInspectionUsePo> pos = uocConfInspectionUseMapper.getList(uocConfInspectionUsePo);
        return UocRu.jsl(pos, UocConfInspectionUse.class);
    }

    @Override
    public List<UocConfInspection> qryInspectionConfigList(UocConfInspection uocConfInspection) {
        UocConfInspectionPo uocConfInspectionPo = UocRu.js(uocConfInspection, UocConfInspectionPo.class);
        List<UocConfInspectionPo> pos = uocConfInspectionMapper.getList(uocConfInspectionPo);
        return UocRu.jsl(pos, UocConfInspection.class);
    }

    @Override
    public void updateInspectionConfigUse(UocConfInspectionUse uocConfInspectionUse) {
        UocConfInspectionUsePo set = UocRu.js(uocConfInspectionUse, UocConfInspectionUsePo.class);
        UocConfInspectionUsePo where = new UocConfInspectionUsePo();
        where.setBusiType(uocConfInspectionUse.getBusiType());
        where.setInspectionType(uocConfInspectionUse.getInspectionType());
        uocConfInspectionUseMapper.updateBy(set, where);
    }

    @Override
    public void deleteInspectionConfig(UocConfInspection uocConfInspection) {
        UocConfInspectionPo set = new UocConfInspectionPo();
        set.setDelTag(1);
        UocConfInspectionPo where = new UocConfInspectionPo();
        where.setBusiType(uocConfInspection.getBusiType());
        where.setInspectionType(uocConfInspection.getInspectionType());
        uocConfInspectionMapper.updateBy(set, where);
    }

    @Override
    public void insertInspectionConfigByBatch(List<UocConfInspection> uocConfInspections) {
        List<UocConfInspectionPo> uocConfInspectionPos = UocRu.jsl(uocConfInspections, UocConfInspectionPo.class);
        uocConfInspectionMapper.insertBatch(uocConfInspectionPos);
    }

    @Override
    public void insertOrderEvaluate(UocEvaluate uocEvaluate) {
        UocOrdEvaluatePo evaluatePo = UocRu.js(uocEvaluate, UocOrdEvaluatePo.class);
        evaluatePo.setCreateTime(new Date());
        uocOrdEvaluateMapper.insert(evaluatePo);
    }

    @Override
    public List<UocEvaluate> qryOrderEvaluateList(UocEvaluateQryBo uocEvaluateQryBo) {
        UocOrdEvaluatePo uocOrdEvaluatePo = UocRu.js(uocEvaluateQryBo, UocOrdEvaluatePo.class);
        return null != uocOrdEvaluatePo ? UocRu.jsl(uocOrdEvaluateMapper.getList(uocOrdEvaluatePo), UocEvaluate.class) : new ArrayList<>();
    }

    @Override
    public void updateOrderEvaluate(UocEvaluate uocEvaluate) {
        UocOrdEvaluatePo set = UocRu.js(uocEvaluate, UocOrdEvaluatePo.class);
        set.setEvaluateState(uocEvaluate.getEvaluateState());
        UocOrdEvaluatePo where = new UocOrdEvaluatePo();
        where.setId(uocEvaluate.getId());
        uocOrdEvaluateMapper.updateBy(set, where);
    }

    
    @Override
    public List<UocDMsgPoolQryBo> getListByRunResultAndFailureCount(UocDMsgPoolQryBo reqBo) {
        List<UocOrderMsgPoolPo> msgPoolPoList = uocOrderMsgPoolMapper.getListByRunResultAndFailureCount(reqBo.getRunResultList(),reqBo.getFailureCount());
        List<UocDMsgPoolQryBo> rspBo = new ArrayList<>();
        UocDMsgPoolQryBo uocDMsgPoolQryBo = new UocDMsgPoolQryBo();
        if(ObjectUtil.isNotEmpty(msgPoolPoList)){
            for (UocOrderMsgPoolPo item: msgPoolPoList){
                BeanUtils.copyProperties(item,uocDMsgPoolQryBo);
                uocDMsgPoolQryBo.setPackageId(item.getPackageid());
                uocDMsgPoolQryBo.setServiceId(item.getServiceid());
                rspBo.add(uocDMsgPoolQryBo);
            }
        }
        return rspBo;
    }
    
    @Override
    public List<UocDMsgPoolQryBo> getVoteMsgList(UocDMsgPoolQryBo reqBo) {
        List<UocOrderMsgPoolPo> msgPoolPoList = uocOrderMsgPoolMapper.getVoteMsgList(reqBo.getRunResultList(),reqBo.getObjTypeList(),reqBo.getFailureCount());
        List<UocDMsgPoolQryBo> rspBo = new ArrayList<>();
        UocDMsgPoolQryBo uocDMsgPoolQryBo = new UocDMsgPoolQryBo();
        if(ObjectUtil.isNotEmpty(msgPoolPoList)){
            for (UocOrderMsgPoolPo item: msgPoolPoList){
                BeanUtils.copyProperties(item,uocDMsgPoolQryBo);
                rspBo.add(uocDMsgPoolQryBo);
            }
        }
        return rspBo;
    }
    
    @Override
    public UocDMsgPoolQryBo getModelByMsgId(UocDMsgPoolQryBo reqBo) {
        UocOrderMsgPoolPo uocOrderMsgPoolPo = uocOrderMsgPoolMapper.getModelBy(UocRu.js(reqBo,UocOrderMsgPoolPo.class));
        
        return UocRu.js(uocOrderMsgPoolPo,UocDMsgPoolQryBo.class);
    }
    
    @Override
    public void upDateMsgPoolById(UocDMsgPoolQryBo qryBo) {
        uocOrderMsgPoolMapper.updateById(UocRu.js(qryBo,UocOrderMsgPoolPo.class));
    }
    
    @Override
    public void updateQueryIndexById(UocOrderQueryIndexQryBo qryBo) {
    
        UocOrderQueryIndexPo set = new UocOrderQueryIndexPo();
        
        set.setObjType(qryBo.getObjType());
        set.setObjId(qryBo.getObjId());
        set.setOrderSystem(qryBo.getOrderSystem());
        set.setOutObjId(qryBo.getOutObjId());
        
        
        UocOrderQueryIndexPo where = new UocOrderQueryIndexPo();
        where.setOrderId(qryBo.getOrderId());
        uocOrderQueryIndexMapper.updateBy(set,where);
    }

    @Override
    public List<UocTacheButtonBo> qryTacheButton(UocTacheButtonQryBo uocTacheButtonQryBo) {
        UocTacheButtonPo uocTacheButtonPo = UocRu.js(uocTacheButtonQryBo, UocTacheButtonPo.class);
        List<UocTacheButtonPo> uocTacheButtonPos = uocTacheButtonMapper.getListByTabIdAndTacheCode(uocTacheButtonPo);
        return UocRu.jsl(uocTacheButtonPos, UocTacheButtonBo.class);
    }
}
