package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocConfInspectionUsePo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocConfInspectionUseMapper
 * 说明:订单超验在用模式配置表
 * 时间:2022-04-08 17:20
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocConfInspectionUseMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocConfInspectionUsePo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocConfInspectionUsePo uocConfInspectionUsePo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocConfInspectionUsePo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocConfInspectionUsePo uocConfInspectionUsePo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set   set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocConfInspectionUsePo set, @Param("where") UocConfInspectionUsePo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocConfInspectionUsePo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocConfInspectionUsePo uocConfInspectionUsePo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocConfInspectionUsePo 参数对象
	 * @return UocConfInspectionUsePo 结果对象
	 */
	UocConfInspectionUsePo getModelBy(UocConfInspectionUsePo uocConfInspectionUsePo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocConfInspectionUsePo 参数对象
	 * @return List<UocConfInspectionUsePo> 结果对象
	 */
	List<UocConfInspectionUsePo> getList(UocConfInspectionUsePo uocConfInspectionUsePo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocConfInspectionUsePo 参数对象
	 * @param page                   分页参数
	 * @return List<UocConfInspectionUsePo> 结果对象
	 */
	List<UocConfInspectionUsePo> getListPage(UocConfInspectionUsePo uocConfInspectionUsePo, Page<UocConfInspectionUsePo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocConfInspectionUsePo> list);

}
