package com.tydic.dyc.oc.repository.impl;

import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.repository.UocChngOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocChngOrderItemObjMapper;
import com.tydic.dyc.oc.repository.dao.UocChngOrderMapMapper;
import com.tydic.dyc.oc.repository.dao.UocChngOrderMapper;
import com.tydic.dyc.oc.repository.dao.UocChngOrderObjMapper;
import com.tydic.dyc.oc.repository.po.UocChngOrderItemObjPo;
import com.tydic.dyc.oc.repository.po.UocChngOrderMapPo;
import com.tydic.dyc.oc.repository.po.UocChngOrderObjPo;
import com.tydic.dyc.oc.repository.po.UocChngOrderPo;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/**
 * 标题:UocChngOrderRepositoryImpl
 * 说明:变更单
 * 时间:2022/3/8 18:11
 * 作者:罗有
 */

@Service
public class UocChngOrderRepositoryImpl implements UocChngOrderRepository {
    @Autowired
    private UocChngOrderMapper uocChngOrderMapper;
    @Autowired
    private UocChngOrderMapMapper uocChngOrderMapMapper;
    @Autowired
    private UocChngOrderObjMapper uocChngOrderObjMapper;
    @Autowired
    private UocChngOrderItemObjMapper uocChngOrderItemObjMapper;

    @Override
	public void createChngOrder(UocChngOrderDo uocChngOrderDo) {
		uocChngOrderMapper.insert(UocRu.js(uocChngOrderDo, UocChngOrderPo.class));
		if (!CollectionUtils.isEmpty(uocChngOrderDo.getUocChngOrderMapList())) {
			uocChngOrderMapMapper.insertBatch(UocRu.jsl(uocChngOrderDo.getUocChngOrderMapList(), UocChngOrderMapPo.class));
		}
		uocChngOrderObjMapper.insertBatch(UocRu.jsl(uocChngOrderDo.getUocChngOrderObjList(), UocChngOrderObjPo.class));
		List<UocChngOrderItemObjPo> uocChngOrderItemObjPoList = new ArrayList<>();
		uocChngOrderDo.getUocChngOrderObjList().forEach(uocChngOrderObj -> uocChngOrderItemObjPoList.addAll(UocRu.jsl(uocChngOrderObj.getUocChngOrderItemObjList(), UocChngOrderItemObjPo.class)));
		uocChngOrderItemObjMapper.insertBatch(uocChngOrderItemObjPoList);
	}

	@Override
	public void modifyBatchChngOrderState(List<UocChngOrderDo> uocChngOrderDoList) {
		if (!CollectionUtils.isEmpty(uocChngOrderDoList)) {
			uocChngOrderMapper.updateBatchState(UocRu.jsl(uocChngOrderDoList, UocChngOrderPo.class), UocRu.js(uocChngOrderDoList.get(0), UocChngOrderPo.class));
		}
	}

	@Override
	public List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo) {
		UocChngOrderItemObjPo uocChngOrderItemObjPo = new UocChngOrderItemObjPo();
		uocChngOrderItemObjPo.setChngOrderIdList(uocChngOrderItemObjQryBo.getChngOrderIdList());
		uocChngOrderItemObjPo.setOrderIdList(uocChngOrderItemObjQryBo.getOrderIdList());
		List<UocChngOrderItemObjPo> uocChngOrderItemObjPoList = uocChngOrderItemObjMapper.getList(uocChngOrderItemObjPo);
		return UocRu.jsl(uocChngOrderItemObjPoList, UocChngOrderItemObj.class);
	}

	@Override
	public List<UocChngOrderDo> getListChngOrder(UocChngOrderQryBo uocChngOrderQryBo) {
		List<UocChngOrderPo> uocChngOrderPoList = uocChngOrderMapper.getList(UocRu.js(uocChngOrderQryBo, UocChngOrderPo.class));
		return UocRu.jsl(uocChngOrderPoList, UocChngOrderDo.class);
	}

	@Override
	public void updateChngStatusAndProCode(UocChngOrderDo uocChngOrderDo) {
		UocChngOrderPo set = new UocChngOrderPo();
		set.setChngOrderState(uocChngOrderDo.getChngOrderState());
		UocChngOrderPo where = new UocChngOrderPo();
		where.setOrderId(uocChngOrderDo.getOrderId());
		where.setChngOrderId(uocChngOrderDo.getChngOrderId());
		uocChngOrderMapper.updateBy(set, where);
	}

	@Override
	public UocChngOrderDo getChngOrder(UocChngOrderQryBo uocChngOrderQryBo) {
		UocChngOrderPo uocChngOrderPo = uocChngOrderMapper.getModelBy(UocRu.js(uocChngOrderQryBo, UocChngOrderPo.class));
		UocChngOrderDo uocChngOrderDo = UocRu.js(uocChngOrderPo, UocChngOrderDo.class);
		if (null != uocChngOrderPo) {
			UocChngOrderMapPo uocChngOrderMapPo = new UocChngOrderMapPo();
			uocChngOrderMapPo.setOrderId(uocChngOrderPo.getOrderId());
			uocChngOrderMapPo.setChngOrderId(uocChngOrderPo.getChngOrderId());
			List<UocChngOrderMapPo> uocChngOrderMapPoList = uocChngOrderMapMapper.getList(uocChngOrderMapPo);
			if (!CollectionUtils.isEmpty(uocChngOrderMapPoList)) {
				uocChngOrderDo.setUocChngOrderMapList(UocRu.jsl(uocChngOrderMapPoList, UocChngOrderMap.class));
			}
		}
		return uocChngOrderDo;
	}

	@Override
	public void updateChngOrderMain(UocChngOrderDo uocChngOrderDo) {
		UocChngOrderPo set = UocRu.js(uocChngOrderDo, UocChngOrderPo.class);
		UocChngOrderPo where = new UocChngOrderPo();
		where.setChngOrderId(uocChngOrderDo.getChngOrderId());
		where.setOrderId(uocChngOrderDo.getOrderId());
		uocChngOrderMapper.updateBy(set, where);
	}

	@Override
	public List<UocChngOrderObj> getListChngOrderObj(UocChngOrderObjQryBo uocChngOrderObjQryBo) {
		List<UocChngOrderObj> uocChngOrderObjList = new ArrayList<>();
		UocChngOrderObjPo uocChngOrderObjPo = UocRu.js(uocChngOrderObjQryBo, UocChngOrderObjPo.class);
		List<UocChngOrderObjPo> uocChngOrderObjPoList = uocChngOrderObjMapper.getList(uocChngOrderObjPo);
		if (!CollectionUtils.isEmpty(uocChngOrderObjPoList)) {
			uocChngOrderObjList = UocRu.jsl(uocChngOrderObjPoList, UocChngOrderObj.class);
			UocChngOrderItemObjPo uocChngOrderItemObjPo = UocRu.js(uocChngOrderObjQryBo, UocChngOrderItemObjPo.class);
			List<UocChngOrderItemObjPo> uocChngOrderItemObjPoList = uocChngOrderItemObjMapper.getList(uocChngOrderItemObjPo);
			if (!CollectionUtils.isEmpty(uocChngOrderItemObjPoList)) {
				ConcurrentMap<Long, List<UocChngOrderItemObjPo>> chngOrderItemObjMap =
						uocChngOrderItemObjPoList.stream().collect(Collectors.groupingByConcurrent(UocChngOrderItemObjPo::getChngOrderObjId));
				uocChngOrderObjList.forEach(uocChngOrderObj -> {
					List<UocChngOrderItemObjPo> uocChngOrderItemObjPos = chngOrderItemObjMap.get(uocChngOrderObj.getChngOrderObjId());
					if (!CollectionUtils.isEmpty(uocChngOrderItemObjPos)) {
						uocChngOrderObj.setUocChngOrderItemObjList(UocRu.jsl(uocChngOrderItemObjPos, UocChngOrderItemObj.class));
					}
				});
			}
		}
		return uocChngOrderObjList;
	}

	@Override
	public void addChngOrderMap(UocChngOrderDo uocChngOrderDo) {
		if (null != uocChngOrderDo && !CollectionUtils.isEmpty(uocChngOrderDo.getUocChngOrderMapList())) {
			uocChngOrderMapMapper.insertBatch(UocRu.jsl(uocChngOrderDo.getUocChngOrderMapList(), UocChngOrderMapPo.class));
		}
	}

	@Override
	public void updateBatchValue(UocChngOrderDo uocChngOrderDo) {
		if (null != uocChngOrderDo && !CollectionUtils.isEmpty(uocChngOrderDo.getUocChngOrderMapList())) {
			uocChngOrderMapMapper.updateBatchValue(UocRu.jsl(uocChngOrderDo.getUocChngOrderMapList(), UocChngOrderMapPo.class), UocRu.js(uocChngOrderDo, UocChngOrderMapPo.class));
		}
	}

	@Override
	public void updateInvalid(UocChngOrderDo uocChngOrderDo) {
		if (null != uocChngOrderDo) {
			uocChngOrderMapMapper.updateInvalid(UocRu.js(uocChngOrderDo, UocChngOrderMapPo.class));
		}
	}

	@Override
	public List<UocChngOrderObj> getListChngOrderObjWithOutItem(UocChngOrderObjQryBo uocChngOrderObjQryBo) {
		UocChngOrderObjPo uocChngOrderObjPo = UocRu.js(uocChngOrderObjQryBo, UocChngOrderObjPo.class);
		return UocRu.jsl(uocChngOrderObjMapper.getList(uocChngOrderObjPo), UocChngOrderObj.class);
	}
}
