package com.tydic.dyc.oc.repository.po;

import lombok.Data;
import java.io.Serializable;
import com.tydic.utils.generatedoc.annotation.DocField;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocSaleOrderPo
 * 说明:销售订单
 * 时间:2022-04-28 15:56
 * 作者:罗有
 **/
@Data
public class UocSaleOrderPo implements Serializable {
	private static final long serialVersionUID =  3467014985427558833L;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "三方信息id")
	private Long stakeholderId;

	@DocField(value = "父订单id")
	private Long upperOrderId;

	@DocField(value = "销售单编码")
	private String saleOrderNo;

	@DocField(value = "外部销售单编码")
	private String saleOrderNoExt;

	@DocField(value = "销售单名称")
	private String saleOrderName;

	@DocField(value = "销售单类型")
	private Integer saleOrderType;

	@DocField(value = "订单状态")
	private String saleOrderState;

	@DocField(value = "销售单单说明")
	private String saleOrderDesc;

	@DocField(value = "订单来源  1 自营单品   2 电商导入   3 协议生成    ")
	private Integer orderSource;

	@DocField(value = "支付类型")
	private Integer payMod;

	@DocField(value = "支付方式")
	private String payType;

	@DocField(value = "销售金额")
	private BigDecimal totalSaleFee;

	@DocField(value = "采购金额")
	private BigDecimal totalPurchaseFee;

	@DocField(value = "优惠金额")
	private BigDecimal totalActShareFee;

	@DocField(value = "运费")
	private BigDecimal totalTransFee;

	@DocField(value = "实付金额")
	private BigDecimal usedFee;

	@DocField(value = "实付积分")
	private BigDecimal usedIntegral;

	@DocField(value = "合同编号")
	private String contractNo;

	@DocField(value = "支付状态")
	private Integer payState;

	@DocField(value = "环节编码")
	private String procState;

	@DocField(value = "税率")
	private String taxRate;

	@DocField(value = "竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	@DocField(value = "租户ID")
	private String tenantId;

	@DocField(value = "协议数据id")
	private Long agrDataId;

	@DocField(value = "协议id")
	private String agreementId;

	@DocField(value = "协议编号")
	private String agreementNo;

	@DocField(value = "送货时间")
	private Date sendTime;

	@DocField(value = "送货时间 开始")
	private Date sendTimeStart;

	@DocField(value = "送货时间 结束")
	private Date sendTimeEnd;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "创建人名称")
	private String createOperName;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新人名称")
	private String updateOperName;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "撤单申请时间")
	private Date cancelRequestTime;

	@DocField(value = "撤单申请时间 开始")
	private Date cancelRequestTimeStart;

	@DocField(value = "撤单申请时间 结束")
	private Date cancelRequestTimeEnd;

	@DocField(value = "撤单时间")
	private Date cancelTime;

	@DocField(value = "撤单时间 开始")
	private Date cancelTimeStart;

	@DocField(value = "撤单时间 结束")
	private Date cancelTimeEnd;

	@DocField(value = "撤单工号")
	private String cancelOperId;

	@DocField(value = "撤单人名称")
	private String cancelOperName;

	@DocField(value = "撤单原因")
	private String cancelReason;

	@DocField(value = "撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	@DocField(value = "取消订单申请同意拒绝原因")
	private String cancelReplyContent;

	@DocField(value = "取消订单申请同意拒绝原因时间")
	private Date cancelReplyTime;

	@DocField(value = "取消订单申请同意拒绝原因时间 开始")
	private Date cancelReplyTimeStart;

	@DocField(value = "取消订单申请同意拒绝原因时间 结束")
	private Date cancelReplyTimeEnd;

	@DocField(value = "竣工时间")
	private Date finishTime;

	@DocField(value = "竣工时间 开始")
	private Date finishTimeStart;

	@DocField(value = "竣工时间 结束")
	private Date finishTimeEnd;

	@DocField(value = "逾期时间")
	private Date expTime;

	@DocField(value = "逾期时间 开始")
	private Date expTimeStart;

	@DocField(value = "逾期时间 结束")
	private Date expTimeEnd;

	@DocField(value = "调价机制：0：无，1：事前调价，2：事中调价 默认值：0")
	private Integer adjustPrice;

	@DocField(value = "调价人id")
	private String adjustPriceOperId;

	@DocField(value = "调价人名称")
	private String adjustPriceOperName;

	@DocField(value = "调价时间")
	private Date adjustPriceTime;

	@DocField(value = "调价时间 开始")
	private Date adjustPriceTimeStart;

	@DocField(value = "调价时间 结束")
	private Date adjustPriceTimeEnd;

	@DocField(value = "结算模式 2:撮合 1:贸易")
	private Integer modelSettle;

	@DocField(value = "采购类别             1 物资             2 施工             3 服务             ")
	private Integer purchaseType;

	@DocField(value = "采购模式  1计划，2非计划")
	private Integer purchaseMode;

	@DocField(value = "供应商拒单原因")
	private String rejectReason;

	@DocField(value = "供应商拒单时间")
	private Date rejectTime;

	@DocField(value = "供应商拒单时间 开始")
	private Date rejectTimeStart;

	@DocField(value = "供应商拒单时间 结束")
	private Date rejectTimeEnd;

	@DocField(value = "供应商拒单人")
	private String rejectOperId;

	@DocField(value = "供应商拒单人名称")
	private String rejectOperName;

	@DocField(value = "是否已关闭尾差 1是 0否")
	private Integer closePennyDiff;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "协议经办人id（配送专责）")
	private String proDeliveryId;

	@DocField(value = "协议经办人名字（配送专责）")
	private String proDeliveryName;

	@DocField(value = "订单创建结果 0创建中，1成功，2失败")
	private Integer createdResult;

	@DocField(value = "排序")
	private String orderBy;

}
