/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocOrderAccessoryMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderRelMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleItemMapMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderMapMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderPayConfMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleStakeholderMapper;
import com.tydic.dyc.oc.repository.po.UocOrderAccessoryPo;
import com.tydic.dyc.oc.repository.po.UocOrderRelPo;
import com.tydic.dyc.oc.repository.po.UocSaleItemMapPo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderItemPo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderMapPo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderPayConfPo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderPo;
import com.tydic.dyc.oc.repository.po.UocSaleStakeholderPo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocSaleOrderRepositoryImpl
implements UocSaleOrderRepository {
    private static final Logger log = LoggerFactory.getLogger(UocSaleOrderRepositoryImpl.class);
    @Autowired
    private UocSaleOrderMapper uocSaleOrderMapper;
    @Autowired
    private UocSaleOrderMapMapper uocSaleOrderMapMapper;
    @Autowired
    private UocSaleOrderPayConfMapper uocSaleOrderPayConfMapper;
    @Autowired
    private UocSaleOrderItemMapper uocSaleOrderItemMapper;
    @Autowired
    private UocSaleItemMapMapper uocSaleItemMapMapper;
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocSaleStakeholderMapper uocSaleStakeholderMapper;
    @Autowired
    private UocOrderRelMapper uocOrderRelMapper;

    public UocSaleOrderDo createSaleOrder(UocSaleOrderDo saleOrderDo) {
        this.uocSaleOrderMapper.insert((UocSaleOrderPo)UocRu.js((Object)saleOrderDo, UocSaleOrderPo.class));
        if (ObjectUtil.isNotEmpty((Object)saleOrderDo.getSaleOrderMapList())) {
            this.uocSaleOrderMapMapper.insertBatch(UocRu.jsl((List)saleOrderDo.getSaleOrderMapList(), UocSaleOrderMapPo.class));
        }
        if (ObjectUtil.isNotEmpty((Object)saleOrderDo.getSaleOrderPayConfList())) {
            this.uocSaleOrderPayConfMapper.insertBatch(UocRu.jsl((List)saleOrderDo.getSaleOrderPayConfList(), UocSaleOrderPayConfPo.class));
        }
        if (ObjectUtil.isNotEmpty((Object)saleOrderDo.getSaleOrderAccessoryList())) {
            this.uocOrderAccessoryMapper.insertBatch(UocRu.jsl((List)saleOrderDo.getSaleOrderAccessoryList(), UocOrderAccessoryPo.class));
        }
        if (saleOrderDo.getIsCreateServiceFee().booleanValue()) {
            this.createServiceFeeRel(saleOrderDo);
        }
        this.saveSaleItems(saleOrderDo);
        return saleOrderDo;
    }

    private void createServiceFeeRel(UocSaleOrderDo saleOrderDo) {
        UocOrderRelPo uocOrderRelPo = new UocOrderRelPo();
        uocOrderRelPo.setId(IdUtil.nextId());
        uocOrderRelPo.setOrderId(saleOrderDo.getOrderId());
        uocOrderRelPo.setObjId(saleOrderDo.getSaleOrderId());
        uocOrderRelPo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderRelPo.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        uocOrderRelPo.setRelType(UocDicConstant.REL_TYPE.SERVICE_CHARGE);
        this.uocOrderRelMapper.insert(uocOrderRelPo);
    }

    public void modifySaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderPo where = new UocSaleOrderPo();
        where.setOrderId(uocSaleOrderDo.getOrderId());
        where.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        this.uocSaleOrderMapper.updateBy((UocSaleOrderPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderPo.class), where);
    }

    public UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo saleOrderDo) {
        UocSaleOrderPo updateSaleSetPo = new UocSaleOrderPo();
        updateSaleSetPo.setSaleOrderState(saleOrderDo.getSaleOrderState());
        if (ObjectUtil.isNotEmpty((Object)saleOrderDo.getProcState())) {
            updateSaleSetPo.setProcState(saleOrderDo.getSaleOrderState());
        }
        updateSaleSetPo.setClosePennyDiff(saleOrderDo.getClosePennyDiff());
        UocSaleOrderPo updateSaleWherePo = new UocSaleOrderPo();
        updateSaleWherePo.setOrderId(saleOrderDo.getOrderId());
        updateSaleWherePo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        this.uocSaleOrderMapper.updateBy(updateSaleSetPo, updateSaleWherePo);
        return saleOrderDo;
    }

    public List<UocSaleOrderDo> qrySaleOrderList(UocSaleOrderDo qryDo) {
        UocSaleOrderPo qryPo = (UocSaleOrderPo)UocRu.js((Object)qryDo, UocSaleOrderPo.class);
        UocSaleStakeholderPo qryStakeholderPo = new UocSaleStakeholderPo();
        qryStakeholderPo.setOrderId(qryDo.getOrderId());
        List<UocSaleStakeholderPo> list = this.uocSaleStakeholderMapper.getList(qryStakeholderPo);
        Map<Object, Object> stakeholderMap = new HashMap();
        if (ObjectUtil.isNotEmpty(list)) {
            stakeholderMap = list.stream().collect(Collectors.groupingBy(UocSaleStakeholderPo::getStakeholderId));
        }
        List<UocSaleOrderPo> uocSaleOrderPoList = this.uocSaleOrderMapper.getList(qryPo);
        List<Object> retList = new ArrayList<UocSaleOrderDo>();
        if (ObjectUtil.isNotEmpty(uocSaleOrderPoList)) {
            retList = UocRu.jsl(uocSaleOrderPoList, UocSaleOrderDo.class);
            for (UocSaleOrderDo uocSaleOrderDo : retList) {
                if (!ObjectUtil.isNotEmpty(stakeholderMap) || !stakeholderMap.containsKey(uocSaleOrderDo.getStakeholderId())) continue;
                uocSaleOrderDo.setStakeholder((UocSaleStakeholder)UocRu.js(((List)stakeholderMap.get(uocSaleOrderDo.getStakeholderId())).get(0), UocSaleStakeholder.class));
            }
        }
        return retList;
    }

    public UocSaleOrderDo getSaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderDo rspDo = new UocSaleOrderDo();
        UocSaleOrderPo uocSaleOrderPo = this.uocSaleOrderMapper.getModelBy((UocSaleOrderPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderPo.class));
        if (ObjectUtil.isNotNull((Object)uocSaleOrderPo)) {
            rspDo = (UocSaleOrderDo)UocRu.js((Object)uocSaleOrderPo, UocSaleOrderDo.class);
        }
        return rspDo;
    }

    private void saveSaleItems(UocSaleOrderDo saleOrderDo) {
        List saleOrderItems = saleOrderDo.getSaleOrderItems();
        ArrayList<UocSaleItemMapPo> itemMapList = new ArrayList<UocSaleItemMapPo>();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            if (!ObjectUtil.isNotEmpty((Object)saleOrderItem.getSaleItemMapList())) continue;
            itemMapList.addAll(UocRu.jsl((List)saleOrderItem.getSaleItemMapList(), UocSaleItemMapPo.class));
        }
        this.uocSaleOrderItemMapper.insertBatch(UocRu.jsl((List)saleOrderItems, UocSaleOrderItemPo.class));
        if (ObjectUtil.isNotEmpty(itemMapList)) {
            this.uocSaleItemMapMapper.insertBatch(itemMapList);
        }
    }

    public UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo) {
        UocSaleOrderPo uocSaleOrderPo = this.uocSaleOrderMapper.getModelBy((UocSaleOrderPo)UocRu.js((Object)uocSaleOrderQryBo, UocSaleOrderPo.class));
        UocSaleOrderDo uocSaleOrderDo = null;
        if (uocSaleOrderPo != null) {
            uocSaleOrderDo = (UocSaleOrderDo)UocRu.js((Object)uocSaleOrderPo, UocSaleOrderDo.class);
            UocSaleStakeholderPo qryStakeholderPo = new UocSaleStakeholderPo();
            qryStakeholderPo.setOrderId(uocSaleOrderDo.getOrderId());
            qryStakeholderPo.setStakeholderId(uocSaleOrderPo.getStakeholderId());
            UocSaleStakeholderPo modelBy = this.uocSaleStakeholderMapper.getModelBy(qryStakeholderPo);
            if (ObjectUtil.isNotEmpty((Object)modelBy)) {
                uocSaleOrderDo.setStakeholder((UocSaleStakeholder)UocRu.js((Object)modelBy, UocSaleStakeholder.class));
            }
        }
        return uocSaleOrderDo;
    }

    public UocSaleOrderDo getSaleOrderAccessoryList(UocOrderAccessoryQryBo uocOrderAccessoryQryBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        List<UocOrderAccessoryPo> uocOrderAccessoryPoList = this.uocOrderAccessoryMapper.getList((UocOrderAccessoryPo)UocRu.js((Object)uocOrderAccessoryQryBo, UocOrderAccessoryPo.class));
        if (ObjectUtil.isNotEmpty(uocOrderAccessoryPoList)) {
            uocSaleOrderDo.setSaleOrderAccessoryList(UocRu.jsl(uocOrderAccessoryPoList, UocOrderAccessory.class));
        }
        return uocSaleOrderDo;
    }

    public List<UocSaleOrderPayConf> getSaleOrderPayConfList(UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo) {
        List<UocSaleOrderPayConfPo> payConfPoList = this.uocSaleOrderPayConfMapper.getList((UocSaleOrderPayConfPo)UocRu.js((Object)uocSaleOrderPayConfQryBo, UocSaleOrderPayConfPo.class));
        return ObjectUtil.isNotEmpty(payConfPoList) ? UocRu.jsl(payConfPoList, UocSaleOrderPayConf.class) : new ArrayList();
    }

    public List<UocSaleOrderMap> getSaleOrderExpandList(UocSaleOrderMapQryBo uocSaleOrderMapQryBo) {
        List<UocSaleOrderMapPo> uocSaleOrderMapPoList = this.uocSaleOrderMapMapper.getList((UocSaleOrderMapPo)UocRu.js((Object)uocSaleOrderMapQryBo, UocSaleOrderMapPo.class));
        return ObjectUtil.isNotEmpty(uocSaleOrderMapPoList) ? UocRu.jsl(uocSaleOrderMapPoList, UocSaleOrderMap.class) : new ArrayList();
    }

    public List<UocSaleOrderItem> getSaleOrderItemList(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        List<UocSaleOrderItemPo> uocSaleOrderItemPoList = this.uocSaleOrderItemMapper.getList((UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderItemQryBo, UocSaleOrderItemPo.class));
        List<Object> uocSaleOrderItemList = new ArrayList<UocSaleOrderItem>();
        if (ObjectUtil.isNotEmpty(uocSaleOrderItemPoList)) {
            uocSaleOrderItemList = UocRu.jsl(uocSaleOrderItemPoList, UocSaleOrderItem.class);
        }
        return uocSaleOrderItemList;
    }

    public List<UocSaleOrderItem> getSaleOrderItemListByItemIds(List<Long> itemIds) {
        List<UocSaleOrderItemPo> uocSaleOrderItemPoList = this.uocSaleOrderItemMapper.getListByItemIds(itemIds);
        List<Object> uocSaleOrderItemList = new ArrayList<UocSaleOrderItem>();
        if (!CollectionUtils.isEmpty(uocSaleOrderItemPoList)) {
            uocSaleOrderItemList = UocRu.jsl(uocSaleOrderItemPoList, UocSaleOrderItem.class);
        }
        return uocSaleOrderItemList;
    }

    public List<UocSaleItemMap> getSaleOrderItemMapList(UocSaleItemMapQryBo uocSaleItemMapQryBo) {
        List<UocSaleItemMapPo> uocSaleItemMapPoList = this.uocSaleItemMapMapper.getList((UocSaleItemMapPo)UocRu.js((Object)uocSaleItemMapQryBo, UocSaleItemMapPo.class));
        return ObjectUtil.isNotEmpty(uocSaleItemMapPoList) ? UocRu.jsl(uocSaleItemMapPoList, UocSaleItemMap.class) : new ArrayList();
    }

    public UocSaleOrderDo qryListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        List<UocSaleOrderItemPo> uocSaleOrderItemPoList = this.uocSaleOrderItemMapper.getList((UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderItemQryBo, UocSaleOrderItemPo.class));
        if (ObjectUtil.isNotEmpty(uocSaleOrderItemPoList)) {
            uocSaleOrderDo.setSaleOrderItems(UocRu.jsl(uocSaleOrderItemPoList, UocSaleOrderItem.class));
        }
        return uocSaleOrderDo;
    }

    public List<UocSaleStakeholder> qrySaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        List<UocSaleStakeholderPo> list = this.uocSaleStakeholderMapper.getList((UocSaleStakeholderPo)UocRu.js((Object)qryBo, UocSaleStakeholderPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocSaleStakeholder.class) : new ArrayList();
    }

    public void addShipOrderMap(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty((Collection)uocSaleOrderDo.getSaleOrderMapList())) {
            this.uocSaleOrderMapMapper.insertBatch(UocRu.jsl((List)uocSaleOrderDo.getSaleOrderMapList(), UocSaleOrderMapPo.class));
        }
    }

    public void updateBatchValue(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty((Collection)uocSaleOrderDo.getSaleOrderMapList())) {
            this.uocSaleOrderMapMapper.updateBatchValue(UocRu.jsl((List)uocSaleOrderDo.getSaleOrderMapList(), UocSaleOrderMapPo.class), (UocSaleOrderMapPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderMapPo.class));
        }
    }

    public void updateInvalid(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo) {
            this.uocSaleOrderMapMapper.updateInvalid((UocSaleOrderMapPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderMapPo.class));
        }
    }

    public UocSaleOrderDo qryTotalFeeAndCount(UocSaleOrderQryBo uocSaleOrderQryBo) {
        UocSaleOrderPo uocSaleOrderPo = this.uocSaleOrderMapper.qryTotalFeeAndCount((UocSaleOrderPo)UocRu.js((Object)uocSaleOrderQryBo, UocSaleOrderPo.class));
        return (UocSaleOrderDo)UocRu.js((Object)uocSaleOrderPo, UocSaleOrderDo.class);
    }

    public void modifyBatchItemInspCount(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo) {
            this.uocSaleOrderItemMapper.updateBatchItemInspCount(UocRu.jsl((List)uocSaleOrderDo.getSaleOrderItems(), UocSaleOrderItemPo.class), (UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderItemPo.class));
        }
    }

    public void deleteSaleOrder(UocSaleOrderDo uocSaleOrderDo) {
        if (null != uocSaleOrderDo) {
            UocSaleOrderPo where = new UocSaleOrderPo();
            where.setOrderId(uocSaleOrderDo.getOrderId());
            where.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            UocSaleOrderPo set = (UocSaleOrderPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderPo.class);
            set.setDelTag(UocDicConstant.DELETE_TAG.DELETED);
            this.uocSaleOrderMapper.updateBy(set, where);
        }
    }

    public void modifySaleOrderStakeholder(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleStakeholderPo where = new UocSaleStakeholderPo();
        where.setOrderId(uocSaleOrderDo.getStakeholder().getOrderId());
        where.setStakeholderId(uocSaleOrderDo.getStakeholder().getStakeholderId());
        UocSaleStakeholderPo set = (UocSaleStakeholderPo)UocRu.js((Object)uocSaleOrderDo.getStakeholder(), UocSaleStakeholderPo.class);
        this.uocSaleStakeholderMapper.updateBy(set, where);
    }

    public void modifySaleOrderItemReturningCount(UocSaleOrderItem uocSaleOrderItem) {
        this.uocSaleOrderItemMapper.updateItemReturningCount(uocSaleOrderItem);
    }

    public void modifyBatchItemSalePrice(UocSaleOrderDo uocSaleOrderDo) {
        List uocSaleOrderItemPos = UocRu.jsl((List)uocSaleOrderDo.getSaleOrderItems(), UocSaleOrderItemPo.class);
        this.uocSaleOrderItemMapper.modifyBatchItemSalePrice(uocSaleOrderItemPos, (UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderItemPo.class));
    }

    public UocSaleOrderDo getSaleItemTotalSalePrice(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderPo uocSaleOrderPo = (UocSaleOrderPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderPo.class);
        UocSaleOrderPo po = this.uocSaleOrderItemMapper.getSaleItemTotalSalePrice(uocSaleOrderPo);
        UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
        uocSaleOrderDo1.setTotalSaleFee(po.getTotalSaleFee());
        return uocSaleOrderDo1;
    }

    public void modifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderItemPo uocSaleOrderItemPo = (UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderItemPo.class);
        this.uocSaleOrderItemMapper.modifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderItemPo);
    }

    public void modifyBatchItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo) {
        if (null != convertSaleOrderDo) {
            this.uocSaleOrderItemMapper.updateItemReturnCountZero((UocSaleOrderItem)UocRu.js((Object)convertSaleOrderDo, UocSaleOrderItem.class));
        }
    }

    public void modifyBatchItemReturnCountConfirm(UocSaleOrderDo convertSaleOrderDo) {
        if (null != convertSaleOrderDo) {
            this.uocSaleOrderItemMapper.updateItemReturnCountByChngingCount((UocSaleOrderItem)UocRu.js((Object)convertSaleOrderDo, UocSaleOrderItem.class));
        }
    }

    public void modifyBatchItemChngingCount(UocSaleOrderDo saleOrderDo) {
        this.uocSaleOrderItemMapper.updateBatchItemChngingCount(UocRu.jsl((List)saleOrderDo.getSaleOrderItems(), UocSaleOrderItem.class), (UocSaleOrderItem)UocRu.js((Object)saleOrderDo, UocSaleOrderItem.class));
    }

    public UocSaleOrderDo getListSaleOrderItem(UocSaleOrderItemQryBo qryBo) {
        List<UocSaleOrderItemPo> uocSaleOrderItemPos = this.uocSaleOrderItemMapper.getList((UocSaleOrderItemPo)UocRu.js((Object)qryBo, UocSaleOrderItemPo.class));
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderItems(UocRu.jsl(uocSaleOrderItemPos, UocSaleOrderItem.class));
        return uocSaleOrderDo;
    }

    public void modifyBatchItemSendCount(UocSaleOrderDo convertSaleOrderDo) {
        if (!CollectionUtils.isEmpty((Collection)convertSaleOrderDo.getSaleOrderItems())) {
            this.uocSaleOrderItemMapper.updateBatchItemSendCount(UocRu.jsl((List)convertSaleOrderDo.getSaleOrderItems(), UocSaleOrderItemPo.class), (UocSaleOrderItemPo)UocRu.js((Object)convertSaleOrderDo, UocSaleOrderItemPo.class));
        }
    }

    public UocSaleOrderDo getCollectCount(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        UocSaleOrderItemPo uocSaleOrderItemPo = this.uocSaleOrderItemMapper.getCollectCount((UocSaleOrderItemPo)UocRu.js((Object)uocSaleOrderItemQryBo, UocSaleOrderItemPo.class));
        UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)UocRu.js((Object)uocSaleOrderItemPo, UocSaleOrderItem.class);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderItems(Collections.singletonList(uocSaleOrderItem));
        return uocSaleOrderDo;
    }

    public void modifySaleOrderItemAfterServingCount(UocSaleOrderItem uocSaleOrderItem) {
        this.uocSaleOrderItemMapper.updateSaleOrderItemAfterServingCount(uocSaleOrderItem);
    }

    public void modifyInspSuper(UocSaleOrderDo uocSaleOrderDo) {
        UocSaleOrderItemPo uocSaleOrderItemPo = new UocSaleOrderItemPo();
        uocSaleOrderItemPo.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderItemPo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        this.uocSaleOrderItemMapper.modifyInspSuper(uocSaleOrderItemPo);
    }

    public void modifyItemRefuseCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderItemMapper.modifyItemRefuseCountConfirm((UocSaleOrderItem)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderItem.class));
    }

    public void modifyItemArriveCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderItemMapper.modifyItemArriveCountConfirm((UocSaleOrderItem)UocRu.js((Object)uocSaleOrderDo, UocSaleOrderItem.class));
    }

    public int updateItem(UocSaleOrderDo uocSaleOrderDo) {
        int updated = 0;
        List saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            UocSaleOrderItemPo set = new UocSaleOrderItemPo();
            UocSaleOrderItemPo where = new UocSaleOrderItemPo();
            set.setNakedPrice(saleOrderItem.getNakedPrice());
            set.setTax(saleOrderItem.getTax());
            set.setTaxPrice(saleOrderItem.getTaxPrice());
            where.setOrderId(saleOrderItem.getOrderId());
            where.setSaleOrderId(saleOrderItem.getSaleOrderId());
            where.setSkuExtSkuId(saleOrderItem.getSkuExtSkuId());
            int i = this.uocSaleOrderItemMapper.updateBy(set, where);
            if (i != 1) continue;
            ++updated;
        }
        return updated;
    }

    public void updateItemArriveAccount(UocSaleOrderDo uocSaleOrderDo) {
        List saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            UocSaleOrderItemPo set = new UocSaleOrderItemPo();
            UocSaleOrderItemPo where = new UocSaleOrderItemPo();
            set.setArriveCount(saleOrderItem.getArriveCount());
            set.setRefuseCount(saleOrderItem.getRefuseCount());
            where.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            int n = this.uocSaleOrderItemMapper.updateBy(set, where);
        }
    }
}

