package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrderMsgPoolPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrderMsgPoolMapper
 * 说明:外部消息池表
 * 时间:2022-04-07 12:05
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocOrderMsgPoolMapper {
    
    /**
     * 插入单条数据
     *
     * @param uocOrderMsgPoolPo 参数对象
     * @return int 影响数量
     */
    int insert(UocOrderMsgPoolPo uocOrderMsgPoolPo);
    
    /**
     * 根据主键更新数据
     *
     * @param uocOrderMsgPoolPo 参数对象
     * @return int 影响数量
     * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
     */
    @Deprecated
    int updateById(UocOrderMsgPoolPo uocOrderMsgPoolPo);
    
    /**
     * 根据条件更新数据
     *
     * @param set   set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") UocOrderMsgPoolPo set, @Param("where") UocOrderMsgPoolPo where);
    
    /**
     * 根据条件校验有多少条数据
     *
     * @param uocOrderMsgPoolPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(UocOrderMsgPoolPo uocOrderMsgPoolPo);
    
    /**
     * 根据条件查询单条数据
     *
     * @param uocOrderMsgPoolPo 参数对象
     * @return UocOrderMsgPoolPo 结果对象
     */
    UocOrderMsgPoolPo getModelBy(UocOrderMsgPoolPo uocOrderMsgPoolPo);
    
    /**
     * 根据条件查询列表数据
     *
     * @param uocOrderMsgPoolPo 参数对象
     * @return List<UocOrderMsgPoolPo> 结果对象
     */
    List<UocOrderMsgPoolPo> getList(UocOrderMsgPoolPo uocOrderMsgPoolPo);
    
    /**
     * 根据条件分页查询列表数据
     *
     * @param uocOrderMsgPoolPo 参数对象
     * @param page              分页参数
     * @return List<UocOrderMsgPoolPo> 结果对象
     */
    List<UocOrderMsgPoolPo> getListPage(UocOrderMsgPoolPo uocOrderMsgPoolPo, Page<UocOrderMsgPoolPo> page);
    
    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<UocOrderMsgPoolPo> list);
    
    /**
     * 根据执行状态和最大失败次数查询结果
     */
    List<UocOrderMsgPoolPo> getListByRunResultAndFailureCount(
            @Param("runResultList") List<Integer> runResultList,
            @Param("failureCount") Integer failureCount);
    
    /**
     * 去重查询还未执行妥投/拒收消息列表
     */
    List<UocOrderMsgPoolPo> getVoteMsgList(
                                   @Param("runResultList") List<Integer> runResultList,
                                   @Param("objTypeList") List<Integer> objTypeList,
                                   @Param("failureCount") Integer failureCount);
}
