package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocPayOrderItemObjPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocPayOrderItemObjMapper
 * 说明:支付单明细对象
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocPayOrderItemObjMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocPayOrderItemObjPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocPayOrderItemObjPo uocPayOrderItemObjPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocPayOrderItemObjPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocPayOrderItemObjPo uocPayOrderItemObjPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocPayOrderItemObjPo set, @Param("where") UocPayOrderItemObjPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocPayOrderItemObjPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocPayOrderItemObjPo uocPayOrderItemObjPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocPayOrderItemObjPo 参数对象
	 * @return UocPayOrderItemObjPo 结果对象
	 */
	UocPayOrderItemObjPo getModelBy(UocPayOrderItemObjPo uocPayOrderItemObjPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocPayOrderItemObjPo 参数对象
	 * @return List<UocPayOrderItemObjPo> 结果对象
	 */
	List<UocPayOrderItemObjPo> getList(UocPayOrderItemObjPo uocPayOrderItemObjPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocPayOrderItemObjPo 参数对象
	 * @param page 分页参数
	 * @return List<UocPayOrderItemObjPo> 结果对象
	 */
	List<UocPayOrderItemObjPo> getListPage(UocPayOrderItemObjPo uocPayOrderItemObjPo, Page<UocPayOrderItemObjPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocPayOrderItemObjPo> list);

}
