package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocConfEffectivePo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * 标题:UocConfEffectiveMapper
 * 说明:订单时效类配置表
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocConfEffectiveMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocConfEffectivePo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocConfEffectivePo uocConfEffectivePo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocConfEffectivePo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocConfEffectivePo uocConfEffectivePo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocConfEffectivePo set, @Param("where") UocConfEffectivePo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocConfEffectivePo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocConfEffectivePo uocConfEffectivePo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocConfEffectivePo 参数对象
	 * @return UocConfEffectivePo 结果对象
	 */
	UocConfEffectivePo getModelBy(UocConfEffectivePo uocConfEffectivePo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocConfEffectivePo 参数对象
	 * @return List<UocConfEffectivePo> 结果对象
	 */
	List<UocConfEffectivePo> getList(UocConfEffectivePo uocConfEffectivePo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocConfEffectivePo 参数对象
	 * @param page 分页参数
	 * @return List<UocConfEffectivePo> 结果对象
	 */
	List<UocConfEffectivePo> getListPage(UocConfEffectivePo uocConfEffectivePo, Page<UocConfEffectivePo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocConfEffectivePo> list);
    
    
    List<UocConfEffectivePo> getRemainingTimeInfo(@Param("supNo") Set<String> supNo, @Param("effectiveCode") Set<String> effectiveCode, @Param("businessTypeCode") Set<String> businessTypeCode);
}
