package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrderTaskInstLogPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrderTaskInstLogMapper
 * 说明:订单任务实例
 * 时间:2022-05-23 11:06
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocOrderTaskInstLogMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocOrderTaskInstLogPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocOrderTaskInstLogPo uocOrderTaskInstLogPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocOrderTaskInstLogPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocOrderTaskInstLogPo uocOrderTaskInstLogPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set   set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocOrderTaskInstLogPo set, @Param("where") UocOrderTaskInstLogPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocOrderTaskInstLogPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocOrderTaskInstLogPo uocOrderTaskInstLogPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocOrderTaskInstLogPo 参数对象
	 * @return UocOrderTaskInstLogPo 结果对象
	 */
	UocOrderTaskInstLogPo getModelBy(UocOrderTaskInstLogPo uocOrderTaskInstLogPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocOrderTaskInstLogPo 参数对象
	 * @return List<UocOrderTaskInstLogPo> 结果对象
	 */
	List<UocOrderTaskInstLogPo> getList(UocOrderTaskInstLogPo uocOrderTaskInstLogPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocOrderTaskInstLogPo 参数对象
	 * @param page                  分页参数
	 * @return List<UocOrderTaskInstLogPo> 结果对象
	 */
	List<UocOrderTaskInstLogPo> getListPage(UocOrderTaskInstLogPo uocOrderTaskInstLogPo, Page<UocOrderTaskInstLogPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocOrderTaskInstLogPo> list);

}
