package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocConfSupplierPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocConfSupplierMapper
 * 说明:供应商下单配置表
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocConfSupplierMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocConfSupplierPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocConfSupplierPo uocConfSupplierPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocConfSupplierPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocConfSupplierPo uocConfSupplierPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocConfSupplierPo set, @Param("where") UocConfSupplierPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocConfSupplierPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocConfSupplierPo uocConfSupplierPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocConfSupplierPo 参数对象
	 * @return UocConfSupplierPo 结果对象
	 */
	UocConfSupplierPo getModelBy(UocConfSupplierPo uocConfSupplierPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocConfSupplierPo 参数对象
	 * @return List<UocConfSupplierPo> 结果对象
	 */
	List<UocConfSupplierPo> getList(UocConfSupplierPo uocConfSupplierPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocConfSupplierPo 参数对象
	 * @param page 分页参数
	 * @return List<UocConfSupplierPo> 结果对象
	 */
	List<UocConfSupplierPo> getListPage(UocConfSupplierPo uocConfSupplierPo, Page<UocConfSupplierPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocConfSupplierPo> list);

}
