package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocApprovalObjPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocApprovalObjMapper
 * 说明:审批对象表
 * 时间:2022-03-10 10:33
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocApprovalObjMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocApprovalObjPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocApprovalObjPo uocApprovalObjPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocApprovalObjPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocApprovalObjPo uocApprovalObjPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocApprovalObjPo set, @Param("where") UocApprovalObjPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocApprovalObjPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocApprovalObjPo uocApprovalObjPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocApprovalObjPo 参数对象
	 * @return UocApprovalObjPo 结果对象
	 */
	UocApprovalObjPo getModelBy(UocApprovalObjPo uocApprovalObjPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocApprovalObjPo 参数对象
	 * @return List<UocApprovalObjPo> 结果对象
	 */
	List<UocApprovalObjPo> getList(UocApprovalObjPo uocApprovalObjPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocApprovalObjPo 参数对象
	 * @param page 分页参数
	 * @return List<UocApprovalObjPo> 结果对象
	 */
	List<UocApprovalObjPo> getListPage(UocApprovalObjPo uocApprovalObjPo, Page<UocApprovalObjPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocApprovalObjPo> list);

}
