package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrderShouldPayPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrderShouldPayMapper
 * 说明:订单应付单表
 * 时间:2022-03-29 14:14
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocOrderShouldPayMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocOrderShouldPayPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocOrderShouldPayPo uocOrderShouldPayPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocOrderShouldPayPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocOrderShouldPayPo uocOrderShouldPayPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set   set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocOrderShouldPayPo set, @Param("where") UocOrderShouldPayPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocOrderShouldPayPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocOrderShouldPayPo uocOrderShouldPayPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocOrderShouldPayPo 参数对象
	 * @return UocOrderShouldPayPo 结果对象
	 */
	UocOrderShouldPayPo getModelBy(UocOrderShouldPayPo uocOrderShouldPayPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocOrderShouldPayPo 参数对象
	 * @return List<UocOrderShouldPayPo> 结果对象
	 */
	List<UocOrderShouldPayPo> getList(UocOrderShouldPayPo uocOrderShouldPayPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocOrderShouldPayPo 参数对象
	 * @param page                分页参数
	 * @return List<UocOrderShouldPayPo> 结果对象
	 */
	List<UocOrderShouldPayPo> getListPage(UocOrderShouldPayPo uocOrderShouldPayPo, Page<UocOrderShouldPayPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocOrderShouldPayPo> list);

}
