package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocPayOrderPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocPayOrderMapper
 * 说明:支付单
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocPayOrderMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocPayOrderPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocPayOrderPo uocPayOrderPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocPayOrderPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocPayOrderPo uocPayOrderPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocPayOrderPo set, @Param("where") UocPayOrderPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocPayOrderPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocPayOrderPo uocPayOrderPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocPayOrderPo 参数对象
	 * @return UocPayOrderPo 结果对象
	 */
	UocPayOrderPo getModelBy(UocPayOrderPo uocPayOrderPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocPayOrderPo 参数对象
	 * @return List<UocPayOrderPo> 结果对象
	 */
	List<UocPayOrderPo> getList(UocPayOrderPo uocPayOrderPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocPayOrderPo 参数对象
	 * @param page 分页参数
	 * @return List<UocPayOrderPo> 结果对象
	 */
	List<UocPayOrderPo> getListPage(UocPayOrderPo uocPayOrderPo, Page<UocPayOrderPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocPayOrderPo> list);

}
