package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrderCancelAdvanceOrderTaskPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrderCancelAdvanceOrderTaskMapper
 * 说明:预订单取消任务表
 * 时间:2022-07-05 17:09
 * 作者:tkl
 **/
@Mapper
@Repository
public interface UocOrderCancelAdvanceOrderTaskMapper {

    /**
     * 插入单条数据
     *
     * @param uocOrderCancelAdvanceOrderTaskPo 参数对象
     * @return int 影响数量
     */
    int insert(UocOrderCancelAdvanceOrderTaskPO uocOrderCancelAdvanceOrderTaskPo);

    /**
     * 根据条件删除数据
     *
     * @param uocOrderCancelAdvanceOrderTaskPo 参数对象
     * @return int 影响数量
     */
    int deleteBy(UocOrderCancelAdvanceOrderTaskPO uocOrderCancelAdvanceOrderTaskPo);

    /**
     * 根据主键更新数据
     *
     * @param uocOrderCancelAdvanceOrderTaskPo 参数对象
     * @return int 影响数量
     * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
     */
    @Deprecated
    int updateById(UocOrderCancelAdvanceOrderTaskPO uocOrderCancelAdvanceOrderTaskPo);

    /**
     * 根据条件更新数据
     *
     * @param set   set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") UocOrderCancelAdvanceOrderTaskPO set, @Param("where") UocOrderCancelAdvanceOrderTaskPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param uocOrderCancelAdvanceOrderTaskPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(UocOrderCancelAdvanceOrderTaskPO uocOrderCancelAdvanceOrderTaskPo);

    /**
     * 根据条件查询单条数据
     *
     * @param uocOrderCancelAdvanceOrderTaskPo 参数对象
     * @return UocOrderCancelAdvanceOrderTaskPO 结果对象
     */
    UocOrderCancelAdvanceOrderTaskPO getModelBy(UocOrderCancelAdvanceOrderTaskPO uocOrderCancelAdvanceOrderTaskPo);

    /**
     * 根据条件查询列表数据
     *
     * @param uocOrderCancelAdvanceOrderTaskPo 参数对象
     * @return List<UocOrderCancelAdvanceOrderTaskPO> 结果对象
     */
    List<UocOrderCancelAdvanceOrderTaskPO> getList(UocOrderCancelAdvanceOrderTaskPO uocOrderCancelAdvanceOrderTaskPo);

    /**
     * 根据条件分页查询列表数据
     *
     * @param uocOrderCancelAdvanceOrderTaskPo 参数对象
     * @param page                             分页参数
     * @return List<UocOrderCancelAdvanceOrderTaskPO> 结果对象
     */
    List<UocOrderCancelAdvanceOrderTaskPO> getListPage(UocOrderCancelAdvanceOrderTaskPO uocOrderCancelAdvanceOrderTaskPo, Page<UocOrderCancelAdvanceOrderTaskPO> page);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<UocOrderCancelAdvanceOrderTaskPO> list);

}
