package com.tydic.dyc.oc.repository.impl;

import com.tydic.dyc.oc.model.order.sub.UocOrderCancelAdvanceOrderTask;
import com.tydic.dyc.oc.repository.UocOrderCancelAdvanceOrderTaskRepository;
import com.tydic.dyc.oc.repository.dao.UocOrderCancelAdvanceOrderTaskMapper;
import com.tydic.dyc.oc.repository.po.UocOrderCancelAdvanceOrderTaskPO;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 标题:UocOrderCancelAdvanceOrderTaskRepositoryImpl
 * 说明:预订单取消任务单
 * 时间:2022/7/05 17:54
 * 作者:tkl
 */

@Service
public class UocOrderCancelAdvanceOrderTaskRepositoryImpl implements UocOrderCancelAdvanceOrderTaskRepository {

    @Autowired
    private UocOrderCancelAdvanceOrderTaskMapper uocOrderCancelAdvanceOrderTaskMapper;

    @Override
    public void createCancelAdvanceOrderTask(UocOrderCancelAdvanceOrderTask advanceOrderTask) {
        uocOrderCancelAdvanceOrderTaskMapper.insert(UocRu.js(advanceOrderTask, UocOrderCancelAdvanceOrderTaskPO.class));
    }

    @Override
    public void batchCreateCancelAdvanceOrderTask(List<UocOrderCancelAdvanceOrderTask> advanceOrderTaskList) {
        List<UocOrderCancelAdvanceOrderTaskPO> advanceOrderTaskPOList = UocRu.jsl(advanceOrderTaskList, UocOrderCancelAdvanceOrderTaskPO.class);
        uocOrderCancelAdvanceOrderTaskMapper.insertBatch(advanceOrderTaskPOList);
    }

    @Override
    public void updateCancelAdvanceOrderTask(UocOrderCancelAdvanceOrderTask advanceOrderTask) {
        UocOrderCancelAdvanceOrderTaskPO set = UocRu.js(advanceOrderTask, UocOrderCancelAdvanceOrderTaskPO.class);
        UocOrderCancelAdvanceOrderTaskPO where = new UocOrderCancelAdvanceOrderTaskPO();
        where.setId(advanceOrderTask.getId());
        uocOrderCancelAdvanceOrderTaskMapper.updateBy(set, where);
    }

    @Override
    public void updateCancelTaskStatus(UocOrderCancelAdvanceOrderTask advanceOrderTask) {
        UocOrderCancelAdvanceOrderTaskPO set = new UocOrderCancelAdvanceOrderTaskPO();
        UocOrderCancelAdvanceOrderTaskPO where = new UocOrderCancelAdvanceOrderTaskPO();
        set.setStatus(advanceOrderTask.getStatus());
        set.setDealTime(advanceOrderTask.getDealTime());
        where.setId(advanceOrderTask.getId());
        uocOrderCancelAdvanceOrderTaskMapper.updateBy(set, where);
    }

    @Override
    public List<UocOrderCancelAdvanceOrderTask> getCancelAdvanceOrderTaskList(UocOrderCancelAdvanceOrderTask advanceOrderTask) {
        return UocRu.jsl(uocOrderCancelAdvanceOrderTaskMapper.getList(UocRu.js(advanceOrderTask, UocOrderCancelAdvanceOrderTaskPO.class)), UocOrderCancelAdvanceOrderTask.class);
    }
}
