package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import io.github.whitedg.mybatis.crypto.EncryptedField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocOrdLogisticsRelaPo
 * 说明:收货信息表
 * 时间:2022-02-23 20:57
 * 作者:罗有
 **/
@Data
public class UocOrdLogisticsRelaPo implements Serializable {
	private static final long serialVersionUID =  778556160119517814L;

	@DocField(value = "收货地址ID")
	private Long contactId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "联系人国家编号")
	private String contactCountryId;

	@DocField(value = "联系人国家名称")
	private String contactCountryName;

	@DocField(value = "联系人省份编号")
	private String contactProvinceId;

	@DocField(value = "联系人省份名称")
	private String contactProvinceName;

	@DocField(value = "联系人地市编号")
	private String contactCityId;

	@DocField(value = "联系人地市名称")
	private String contactCityName;

	@DocField(value = "联系人区县编号")
	private String contactCountyId;

	@DocField(value = "联系人区县名称")
	private String contactCountyName;

	@DocField(value = "联系人乡镇编号")
	private String contactTownId;

	@DocField(value = "联系人乡镇名称")
	private String contactTown;

	@DocField(value = "收货人地址")
	private String contactAddress;

	@DocField(value = "联系人公司")
	private String contactCompany;

	@DocField(value = "联系人名称")
	private String contactName;

	@DocField(value = "联系人固话")
	@EncryptedField
	private String contactFixPhone;

	@DocField(value = "联系人邮件")
	private String contactEmail;

	@DocField(value = "联系人手机")
	@EncryptedField
	private String contactMobile;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "排序")
	private String orderBy;
	/**
	 * 租户id
	 */
	private Long sysTenantId;
	/**
	 * 租户名称
	 */
	private String sysTenantName;
	/**
	 * 区号
	 */
	private String areaCode;

}
