<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
    <meta charset="utf-8">
    <title>支付详情</title>
    <meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1,user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
    <meta http-equiv="Pragma" content="no-cache" />
    <meta http-equiv="Expires" content="0" />

    <link rel="stylesheet" href="../../css/app/common.css"/>
    <link rel="stylesheet" href="../../css/app/payResult.css"/>
</head>
<body>
    <header class="nav-bar">
        
    </header>

    <!--支付成功-->
    <section class="content-box pay-success" id="paySuccess">
        <div class="panel-view">
            <div class="result-layout">
                <img class="result-icon" src="../../images/app/pay-success.png"/>
                <div class="text">
                    订单编号：<span id="orderId">${uniQrCodePayResultInfo.orderId}</span>
                </div>
                <div class="result-money">￥<span id="totalFee">${uniQrCodePayResultInfo.totalFee}</span></div>
            </div>
        </div>
        <div class="panel-action">
            <div class="btn" id="jumpBtn">完成</div>
        </div>
    </section>

    <script type="text/javascript" src="../../lib/jquery/jquery-3.3.1.min.js"></script>
    <script type="text/javascript" src="../../js/app/util.js"></script>
    
    <script type="text/javascript">
    	//var payOrderInfo={};
    	var payOrderInfo = JSON.parse(sessionStorage.getItem('payOrderInfo'));
    	var payOrderId = util.getQueryString('payOrderId');
	    $(document).ready(function () {
	    	if(payOrderId != null && payOrderId != ''){
		        pollingPayResult();
	    	}else{
	    		if(payOrderInfo == null){
	    			payOrderInfo = {};
	    		}
	    		payOrderInfo.detailName = '${uniQrCodePayResultInfo.detailName}';
		        payOrderInfo.totalFee = '${uniQrCodePayResultInfo.totalFee}'*100;
		        payOrderInfo.redirectUrl = '${uniQrCodePayResultInfo.redirectUrl}';
		        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
		        
	    		pay();
	    	}
	    	
	    });
	    
	    //支付
	    function pay(){
	    	var rspCode = '${uniQrCodePayResultInfo.rspCode}';
	    	if(rspCode != "0000"){
	    		util.dialog.alert('${uniQrCodePayResultInfo.rspName}');
	    		return;
	    	}
	    	
	    	//返回成功，跳转支付
    		var channel = '${uniQrCodePayResultInfo.channel}';
    		if(channel = "23"){
        		//支付宝H5支付
        		var form = $('${uniQrCodePayResultInfo.body}').appendTo('html');
        	}else if(channel = "14"){
        		//微信公众号支付
        		if (typeof WeixinJSBridge == "undefined"){
     			   if( document.addEventListener ){
     			       document.addEventListener('WeixinJSBridgeReady', onBridgeReady, false);
     			   }else if (document.attachEvent){
     			       document.attachEvent('WeixinJSBridgeReady', onBridgeReady);
     			       document.attachEvent('onWeixinJSBridgeReady', onBridgeReady);
     			   }
     			}else{
     			   onBridgeReady();
     			}
        	}
	    }
    	
	    //拉起微信支付框
    	function onBridgeReady(){
    		   WeixinJSBridge.invoke(
    		       'getBrandWCPayRequest', {
    		           "appId": '${uniQrCodePayResultInfo.appId}',  //公众号名称，由商户传入
    		           "timeStamp": '${uniQrCodePayResultInfo.timeStamp}', //时间戳，自1970年以来的秒数
    		           "nonceStr" : '${uniQrCodePayResultInfo.nonceStr}', //随机串
    		           "package" : '${uniQrCodePayResultInfo.package_}',
    		           "signType" : '${uniQrCodePayResultInfo.signType}', //微信签名方式：
    		           "paySign" : '${uniQrCodePayResultInfo.paySign}' //微信签名
    		       },
    		       function(res){
    		    	   // 使用以上方式判断前端返回,微信团队郑重提示：res.err_msg将在用户支付成功后返回    ok，但并不保证它绝对可靠。
    		    	   if(res.err_msg == "get_brand_wcpay_request:ok") {
    		    		   pollingPayResult();
    		    	   }else if(res.err_msg == "get_brand_wcpay_request:cancel"){
    		    		   util.dialog.alert('您没有确认支付，请重新扫码支付！');
    		    	   }else{
    		    		   util.dialog.alert(res.err_desc+'，请重新扫码支付！');
    		    	   }
    		       }
    		   );
    		};
    		
    		var pollingPayResult = function() {
    			timersearch = setInterval(function() {
		            payWaiting(payOrderId);
		        }, 1000);
    		};

    		var timersearch = null;
    		var payTimeout = 10;
    		var payWaiting = function(payOrderId) {
    		    if (payTimeout-- > 0) {
    		        util.loading.show("正在查询支付结果...");
    		        if (payTimeout === 1) {
    		            qrySourcePayResult(payOrderId);
    		        } else {
    		            qryPayResult(payOrderId);
    		        }
    		    } else {
    		        clearInterval(timersearch);
    		        util.loading.hide();
    		        util.dialog.alert('支付已超时，请重新支付');
    		    }
    		};

    		var qryPayResult = function(payOrderId) {
    		    var data = {};
    		    data.loadingHide = false;
    		    data.params = {
    		        payOrderId: payOrderId
    		    };
    		    data.params.service = '/pay/pollingPayState';
    		    data.successF = function(returnData) {
    		        if (returnData.payStatus === 'SUCCESS') {
    		            clearInterval(timersearch);
    		            util.loading.hide();
    		            alert("成功");
    		            location.replace('/payResult.html?payStatus=' + returnData.payStatus);
    		        }
    		    };
    		    data.failF = function(returnData) {
					
    		    };
    		    util.ajax(data);
    		};
    		
    		var qrySourcePayResult = function(payOrderId) {
    		    var data = {};
    		    data.loadingHide = false;
    		    data.params = {
    		        payOrderId: payOrderId
    		    };
    		    data.params.service = '/pay/orderQuery';
    		    data.successF = function(returnData) {
    		        if (returnData.payStatus == 'SUCCESS') {
    		            clearInterval(timersearch);
    		            util.loading.hide();
    		            location.replace('payResult.html?payStatus=' + returnData.payStatus);
    		        }
    		    };
    		    util.ajax(data);
    		};
    		
	</script>
</body>
</html>