var payOrderInfo = JSON.parse(sessionStorage.getItem('payOrderInfo'));
$(document).ready(function () {
    // 返回收银台
    $("#backBtn").on('click', function () {
        window.history.back();
        /* 不需要关闭订单
        clearInterval(timersearch);
        util.loading.show('正在返回收银台...');
        qrySourcePayResult(payOrderInfo.payOrderId, 2);//1 返回操作 2 轮询*/
    });
    init();
    getQrCode();
});

var init = function () {
    $('#orderId').text(payOrderInfo.orderId);
    $('#goodsName').text(payOrderInfo.detailName);
    $('#totalFee').text(payOrderInfo.totalFee.indexOf('.') >= 0 ? payOrderInfo.totalFee : payOrderInfo.totalFee + '.00');
    $('#realFee').text(payOrderInfo.realFee.indexOf('.') >= 0 ? payOrderInfo.totalFee : payOrderInfo.totalFee + '.00');

    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId
    };
    data.params.service = 'paymentMethodInquiryService';
    data.successF = function (returnData) {
        util.countdown('#remainingTime', returnData.payTimeLeft, function(timeLeft) {
            if (timeLeft <= 0) {
                util.dialog.alert('订单已超时，点击确定返回重新下单', function() {
                    window.history.go(-2);
                });
            }
        });
    };
    util.loading.show('正在获取支付信息...');
    util.ajax(data);
};

function getQrCode() {
    loadingQrcode();

    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        realFee: payOrderInfo.realFee,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = 'wopayOneCodePayQryCodeBusiService';
    data.successF = function (returnData) {
        payOrderInfo.payOrderId = returnData.payOrderId;
        payTimeout = returnData.effectiveSeconds;
        createQrcode(returnData.qrCode);
        timersearch = setInterval(function () {
            payWaiting(returnData);
        }, 1000);
    };
    util.loading.show('正在生成二维码...');
    util.ajax(data);
}

var timersearch = null;
var payTimeout = 120;
var payWaiting = function (returnData) {
    $('#curtimes').text(payTimeout);
    if (payTimeout-- > 0) {
        if (payTimeout == 3) {
            qrySourcePayResult(returnData.payOrderId, 1);
        } else {
            qryPayResult(returnData.payOrderId);
        }
    } else {
        clearInterval(timersearch);
        util.dialog.alert('二维码失效，请手动刷新页面', function () {
            window.location.reload();
        });
    }
};

var qryPayResult = function (payOrderId) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = 'queryPayNotifyBusiService';
    data.successF = function (returnData) {
        if (returnData.payStatus == 'SUCCESS') {
            clearInterval(timersearch);
            sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
            location.replace('payResult.html?payStatus=' + returnData.payStatus + '&rspName=' + returnData.rspName  + "&orderId=" +  payOrderInfo.orderId);
        }
    };
    data.failF = function (returnData) {
        // TODO
    };
    util.ajax(data);
};

var qrySourcePayResult = function (payOrderId, oper) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = 'queryPaymentStructureCombService';
    data.successF = function (returnData) {
        if (returnData.payStatus == 'SUCCESS') {
            clearInterval(timersearch);
            sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
            location.replace('payResult.html?payStatus=' + returnData.payStatus + '&rspName=' + returnData.rspName  + "&orderId=" +  payOrderInfo.orderId);
        } else {
            /* 不需要关闭订单
            if (oper == 2) {//返回操作
                setTimeout(function () {
                    closeOrder(returnData.payOrderId);
                }, 100);
            }*/
        }
    };
    util.ajax(data);
};
/* 不需要关闭订单
var closeOrder = function (payOrderId) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = 'pmcCloseOrderCombService';
    data.successF = function (returnData) {
        window.history.back();
    };
    util.loading.show('正在关闭支付单...');
    util.ajax(data);
};*/

// 生成二维码
function createQrcode(content) {
    $('#qrCode').empty().qrcode({
        width: 280, // 宽度
        height: 280, // 高度
        correctLevel: 0,
        render: 'canvas',
        text: content // 二维码内容
    });
}

// 正在加载二维码
function loadingQrcode() {
    $('#qrCode').html('正在加载...');
}
