var timersearch = null;
var pertime = 1000;		//执行间隔
var curtimes = 115;		//总次数
var pay_order_id = null;

var payOrderInfo = JSON.parse(sessionStorage.getItem('payOrderInfo'));
$(document).ready(function () {
    // 返回收银台
    $("#payment_a").on("click", function () {
        clearInterval(timersearch);
        loadingMask('正在查询支付结果...');
        qrySourcePayResult(payOrderInfo.payOrderId, 2);//1 返回操作 2 轮询
    });

    init();
    getQrCode();
});

var init = function () {
    $('#orderId').text(payOrderInfo.orderId);
    $('#realFee').text(payOrderInfo.realFee / 100.00);

    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId
    };
    data.params.service = '/cashierDesk/queryCashierDesk';
    data.successF = function (returnData) {
        util.countdown('#remainingTime', returnData.payTimeLeft, function (timeLeft) {
            /* if (timeLeft <= 0) {
                 util.dialog.alert('订单已超时，点击确定返回重新下单', function () {
                     window.history.back();
                 });
             }*/
        });
    };
    loadingMask('正在获取支付信息...');
    util.ajax(data);
};

function getQrCode() {
    loadingQrcode();

    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        key: payOrderInfo.key,
        realFee: payOrderInfo.realFee,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = "/pay/uniPay";
    data.successF = function (returnData) {
        payOrderInfo.payOrderId = returnData.payOrderId;
        payTimeout = returnData.effectiveSeconds;
        createQrcode(returnData.qrCode);
        timersearch = setInterval(function () {
            payWaiting(returnData);
        }, 1000);
    };
    loadingMask("正在生成二维码...");
    util.ajax(data);
}

var timersearch = null;
var payTimeout = 120;
var payWaiting = function (returnData) {
    $('#curtimes').text(payTimeout);
    if (payTimeout-- > 0) {
        qryPayResult(returnData.payOrderId);
        if (payTimeout == 5) {
            qrySourcePayResult(returnData.payOrderId, 1);
        }
    } else {
        clearInterval(timersearch);
        util.dialog.alert('二维码失效，请手动刷新页面', function () {
            window.location.reload();
        });
    }
};

var qryPayResult = function (payOrderId) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = '/pay/pollingPayState';
    data.successF = function (returnData) {
        if (returnData.payStatus == 'SUCCESS') {
            clearInterval(timersearch);
            sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
            location.replace('payResult.html?payStatus=' + returnData.payStatus + "&rspName=" +encodeURIComponent(returnData.rspName));
        }
    };
    util.ajax(data);
};

var qrySourcePayResult = function (payOrderId, oper) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = '/pay/orderQuery';
    data.successF = function (returnData) {
        if (returnData.payStatus == 'SUCCESS') {
            clearInterval(timersearch);
            sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
            location.replace('payResult.html?payStatus=' + returnData.payStatus + "&rspName=" + returnData.rspName);
        } else {
            if (oper == 2) {//返回操作
                window.history.back();
            }
        }
    };
    util.ajax(data);
};
var closeOrder = function (payOrderId) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = '/pay/closeOrder';
    data.successF = function (returnData) {
        window.history.back();
    };
    util.ajax(data);
};

// 生成二维码
function createQrcode(content) {
    $('#qrCode').empty().qrcode({
        width: 280, // 宽度
        height: 280, // 高度
        correctLevel: 0,
        render: "canvas",
        text: content // 二维码内容
    });
}

// 正在加载二维码
function loadingQrcode() {
    $('#qrCode').html('正在加载...');
}
