var projectInfo = undefined;
var payOrderInfo = JSON.parse(sessionStorage.getItem('payOrderInfo'));
if (!payOrderInfo) {
    payOrderInfo = {
        orderId: util.getQueryString('orderId')
    };
} else {
    payOrderInfo.orderId = util.getQueryString('orderId');
}
var cashierDeskInfo = null;

$(document).ready(function () {
    getProjectInfo();

    $('.pay-tabs').on('click', '.pay-tab', function (e) {
        var $this = $(this);
        $this.siblings().removeClass('active');
        $this.addClass('active');
        $('.pay-type').hide();
        $('.pay-type[data-tab="' + $this.data('value') + '"]').show();
    });
    $("#useCoupon").on('click', function () {
        createOrderToCoupons();
    });
    $('#paymentList').on('click', '.payment-mode', function (e) {
        var $this = $(this);
        $('#paymentList .payment-mode').removeClass('checked');
        $this.addClass('checked').siblings().removeClass('checked');
    });
    $('#payNow').on('click', function () {
        var payMethodObj = $('#paymentList .payment-mode.checked');
        payOrderInfo.payMethod = payMethodObj.data('pay-method');
        console.log(payOrderInfo.payMethod, '易宝支付点击');
        if (payOrderInfo.payMethod == '24') {
            aliPcWebPay();
        }
        // else if (payOrderInfo.payMethod == '30') {
        //     cashPay();
        // }
        else if (payOrderInfo.payMethod == '54') {
            getWopayInfo();
        } else if (payOrderInfo.payMethod == '110') {
            unionPay();
        } else if (payOrderInfo.payMethod == '180') {
            bocPay();
        }
        else if (payOrderInfo.payMethod == '51') {
            wozfPay();
        }
        else if (payOrderInfo.payMethod == '610') {
            console.log(payOrderInfo.payMethod, '易宝支付进入');
            ybzfPay();
        }
        else if (payOrderInfo.payMethod == '1') {
            misposPay();
        } else {
            sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
            window.location.href = payMethodObj.data('url');
        }
    });
});

var getProjectInfo = function () {
    var data = {};
    data.params = {};
    data.params.service = "/config/getIPConfigInfos";
    data.async = false;
    data.successF = function (returnData) {
        projectInfo = {
            payAccessIp: returnData.payAccessIp,
            payAccessProjectName: returnData.payAccessProjectName,
            payContactIp: returnData.payContactIp,
            payContactProjectName: returnData.payContactProjectName
        };
        sessionStorage.setItem('projectInfo', JSON.stringify(projectInfo));
        qryPayInfo();
    };
    util.ajax(data);
};

var qryPayInfo = function () {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId
    };
    data.params.service = '/cashierDesk/queryCashierDesk';
    data.successF = function (returnData) {
        cashierDeskInfo = returnData;
        util.countdown('#remainingTime', returnData.payTimeLeft, function (timeLeft) {
            if (timeLeft <= 0) {
                util.dialog.alert('订单已超时，点击确定返回重新下单', function () {
                    payOrderInfo.userCoupons === 'Y' ? window.history.go(-2) : window.history.go(-1);
                });
            }
        });
        payOrderInfo.orderId = returnData.orderId;
        payOrderInfo.outOrderId = returnData.outOrderId;
        payOrderInfo.totalFee = returnData.totalFee;
        payOrderInfo.realFee = returnData.realFee;
        payOrderInfo.redirectUrl = returnData.redirectUrl;
        $('#orderId').text(returnData.orderId);
        $('#totalFee').text(returnData.totalFee / 100.00);
        $('#realFee').text(returnData.realFee / 100.00);
        payOrderInfo.createTime = returnData.createTime;

        var paymentList = '';
        var wxHtml = '';
        var xxFlag = false;
        var hideCoupons = true;
        console.log(returnData.payMethod, "returnData.payMethod");
        // let newPayMethod = []
        let wx = null
        let zfb = null
        let yb = null
        let wzf = null
        let xx = null
        $.each(returnData.payMethod, function (i, item) {
            console.log(item, "循环");
            if (item.payMethod == 611) {
                // 微信
                wx = item
            } if (item.payMethod == 612) {
                // 支付宝
                zfb = item
            }
            if (item.payMethod == 610) {
                // 易宝
                yb = item
            }
            if (item.payMethod == 51) {
                //沃支付
                wzf = item
            }
            if (item.payMethod == 30) {
                //线下支付
                xx = item
            }

        });
        returnData.payMethod = []
        if (wx) {
            returnData.payMethod.push(wx)
        }
        if (zfb) {
            returnData.payMethod.push(zfb)
        }
        if (yb) {
            returnData.payMethod.push(yb)
        }
        if (wzf) {
            returnData.payMethod.push(wzf)
        }
        if (xx) {
            returnData.payMethod.push(xx)
        }


        console.log(returnData.payMethod, "改了之后的");
        $.each(returnData.payMethod, function (i, item) {
            if (item.payMethod == '71') {
                hideCoupons = false;
            }
            if (item.payMethod == '2' || item.payMethod == '3' ||
                item.payMethod == '4' || item.payMethod == '5' ||
                item.payMethod == '6' || item.payMethod == '71') {
                return;
            }
            var iconClass = '';
            var dataUrl = '';
            switch (parseInt(item.payMethod)) {
                case 1:
                    iconClass = 'pay-misPosPay';
                    break;
                case 10:
                    iconClass = 'pay-weixin-barcode';
                    dataUrl = 'payWeixinBarCode.html';
                    break;
                case 611:
                    iconClass = 'pay-weixin-qrcode';
                    dataUrl = 'payWeixinQrCode.html';
                    break;
                case 20:
                    iconClass = 'pay-zhifubao-barcode';
                    dataUrl = 'payZhifubaoBarCode.html';
                    break;
                case 612:
                    iconClass = 'pay-zhifubao-qrcode';
                    dataUrl = 'payZhifubaoQrCode.html';
                    break;
                case 24:
                    iconClass = 'pay-alipay';
                    break;
                case 30:
                    iconClass = 'pay-cashPay';
                    dataUrl = 'offlinePayment.html';
                    break;
                case 54:
                    iconClass = 'pay-wopay';
                    break;
                case 104:
                    iconClass = 'pay-onecodepay';
                    dataUrl = 'payYimafuQrCode.html';
                    break;
                case 110:
                    iconClass = 'pay-unionpay';
                    dataUrl = 'payUnionPay.html';
                    break;
                case 160: // 中核财企通
                    iconClass = 'pay-cnncpay';
                    dataUrl = 'payCnnc.html';
                    break;
                case 180: // 中国银行
                    iconClass = 'pay-bocpay';
                    break;
                case 51: // 沃支付
                    iconClass = 'pay_wozf';
                    break;
                case 610: // 沃支付
                    iconClass = 'pay_ybzf';
                    break;
                case 666: //线下支付
                    iconClass = 'pay-xxpay';
                    dataUrl = 'offlinePayment.html';
                    break;
                case 190: // 中国工商银行
                    iconClass = 'pay-icbcpay';
                    dataUrl = 'payICBC.html';
                    break;
            }
            if (item.payMethod == 30) {
                xxFlag = true;
                wxHtml += '<div class=" payment-mode ' + iconClass + '" data-pay-method="' + item.payMethod + '" data-pay-type="' + item.payType + '" data-url="' + dataUrl + '">' +
                    '<i></i>' +
                    '</div>';
            } else {
                paymentList += '<div class=" payment-mode ' + iconClass + '' + (i == 0 ? " checked" : "") + '" data-pay-method="' + item.payMethod + '" data-pay-type="' + item.payType + '" data-url="' + dataUrl + '">' +
                    '<i></i>' +
                    '</div>';
            }
        });
        paymentList = '<div class="payment-list clearfix" >' + paymentList + '</div>'
        if (xxFlag) {
            wxHtml = '<div class="pay-tabs" style="margin: 0 20px 20px"><div class="pay-tab active" data-value="3">线下支付</div></div>' +
                '<div class="payment-list clearfix">' +
                '' + wxHtml + '</div>'
        } else {
            wxHtml = ''
        }
        paymentList += wxHtml
        $('#paymentList').html(paymentList);
        //如果不存在支付方式为71（红包）,隐藏使用红包按钮
        if (hideCoupons) {
            $('#useCoupon').parent().hide();
        }
        // 如果只有mispos一种支付方式，就直接打开mispos支付界面
        if (returnData.payMethod.length == 6 && returnData.payMethod[0].payMethod == '1') {
            payOrderInfo.payMethod = returnData.payMethod[0].payMethod;
            misposPay();
            return;
        }
        // createQrcode();
        // scanPolling();

        $('.view-main').show();
    };
    loadingMask('正在查询支付信息...');
    util.ajax(data);
};

/**
 * 现金支付
 */
var cashPay = function () {
    var data = {};
    var offlinePayUrl = cashierDeskInfo.offlinePayUrl
    //非及时线下支付跳转地址为空的，作及时支付
    if (offlinePayUrl == null || offlinePayUrl == '') {
        data.params = {
            orderId: payOrderInfo.orderId,
            realFee: payOrderInfo.realFee,
            payMethod: payOrderInfo.payMethod
        };
        data.params.service = "/pay/uniPay";
        data.successF = function (returnData) {
            sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
            location.replace('payResult.html?payStatus=SUCCESS');
        };
        loadingMask('现金支付确认中...');
    } else {
        var busiReqData = {
            offlinePayUrl: offlinePayUrl
        };
        data.params = {
            busiCode: cashierDeskInfo.busiCode,
            reqWay: cashierDeskInfo.reqWay,
            outOrderId: cashierDeskInfo.outOrderId,
            merchantId: cashierDeskInfo.merchantId,
            totalFee: Number.parseInt(cashierDeskInfo.realFee),
            detailName: cashierDeskInfo.detailName,
            payMethod: payOrderInfo.payMethod,
            channelId: cashierDeskInfo.channelId,
            cityId: cashierDeskInfo.cityId,
            createOperId: cashierDeskInfo.createOperId,
            districtId: cashierDeskInfo.districtId,
            provinceId: cashierDeskInfo.provinceId,
            notifyUrl: cashierDeskInfo.notifyUrl,
            redirectUrl: cashierDeskInfo.redirectUrl,
            busiReqData: JSON.stringify(busiReqData)
        };
        data.params.service = "/payPro/dealOrder";
        data.contentType = 'json';
        data.successF = function (returnData) {
            location.href = offlinePayUrl + "&payOrderId=" + returnData.payOrderId;
            loadingMask("正在跳转...");
            setTimeout(function () {
                hideLoadingMask();
            }, 10000);
        };
        loadingMask("等待支付结果...");
    }
    util.ajax(data);
};

/**
 * 支付宝H5支付
 */
var aliPcWebPay = function () {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        realFee: payOrderInfo.realFee,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = "/pay/uniPay";
    data.successF = function (returnData) {
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        var form = $(returnData.body).appendTo('html');
    };
    loadingMask('正在跳转支付宝...');
    util.ajax(data);
};

/**
 * 银联支付
 */
var unionPay = function () {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        realFee: payOrderInfo.realFee,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = "/pay/uniPay";
    data.successF = function (returnData) {
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        document.write(returnData.acpHtml);
        document.close();
    };
    loadingMask('正在跳转银联...');
    util.ajax(data);
};

/**
 * 中国银行支付
 */
var bocPay = function () {
    var data = {};
    data.params = {
        busiCode: cashierDeskInfo.busiCode,
        merchantId: cashierDeskInfo.merchantId,
        outOrderId: cashierDeskInfo.outOrderId,
        totalFee: Number.parseInt(cashierDeskInfo.totalFee),
        payMethod: payOrderInfo.payMethod,
        reqWay: cashierDeskInfo.reqWay,
        detailName: cashierDeskInfo.detailName,
        channelId: cashierDeskInfo.channelId,
        cityId: cashierDeskInfo.cityId,
        createOperId: cashierDeskInfo.createOperId,
        districtId: cashierDeskInfo.districtId,
        provinceId: cashierDeskInfo.provinceId,
        notifyUrl: cashierDeskInfo.notifyUrl,
        redirectUrl: cashierDeskInfo.redirectUrl
    };
    data.params.service = '/payPro/dealOrder';
    data.contentType = 'json';
    data.successF = function (returnData) {
        var busiRspData = JSON.parse(returnData.busiRspData);
        $('body').append(busiRspData.htmlBody);
        loadingMask("正在跳转...");
        setTimeout(function () {
            hideLoadingMask();
        }, 10000);
    };
    loadingMask("等待支付结果...");
    util.ajax(data);
};


/**
 * 联东沃支付
 */
var wozfPay = function () {
    var data = {};
    data.params = {
        busiCode: cashierDeskInfo.busiCode,
        merchantId: cashierDeskInfo.merchantId,
        outOrderId: cashierDeskInfo.outOrderId,
        totalFee: Number.parseInt(cashierDeskInfo.totalFee),
        payMethod: payOrderInfo.payMethod,
        reqWay: cashierDeskInfo.reqWay,
        detailName: cashierDeskInfo.detailName,
        channelId: cashierDeskInfo.channelId,
        cityId: cashierDeskInfo.cityId,
        createOperId: cashierDeskInfo.createOperId,
        districtId: cashierDeskInfo.districtId,
        provinceId: cashierDeskInfo.provinceId,
        notifyUrl: cashierDeskInfo.notifyUrl,
        redirectUrl: cashierDeskInfo.redirectUrl
    };
    // /pay/worest/payPro/dealOrder
    data.params.service = '/payPro/dealOrder';
    data.params.wzfUrl = 'wzf'
    data.contentType = 'json';
    data.successF = function (returnData) {
        var busiRspData = JSON.parse(returnData.busiRspData);
        $('body').append(busiRspData.htmlBody);
        loadingMask("正在跳转...");
        setTimeout(function () {
            hideLoadingMask();
        }, 10000);
    };
    loadingMask("等待支付结果...");
    util.ajax(data);
};

/**
 * 联东易宝支付
 */
var ybzfPay = function () {
    console.log(cashierDeskInfo, "联东易宝支付函数");
    var data = {};
    data.params = {
        busiCode: cashierDeskInfo.busiCode,
        merchantId: cashierDeskInfo.merchantId,
        outOrderId: cashierDeskInfo.outOrderId,
        totalFee: Number.parseInt(cashierDeskInfo.totalFee),
        payMethod: payOrderInfo.payMethod,
        reqWay: cashierDeskInfo.reqWay,
        detailName: cashierDeskInfo.detailName,
        channelId: cashierDeskInfo.channelId,
        cityId: cashierDeskInfo.cityId,
        createOperId: cashierDeskInfo.createOperId,
        districtId: cashierDeskInfo.districtId,
        provinceId: cashierDeskInfo.provinceId,
        notifyUrl: cashierDeskInfo.notifyUrl,
        redirectUrl: cashierDeskInfo.redirectUrl
    };
    console.log(cashierDeskInfo, "222222");
    data.params.service = '/payPro/dealOrder';
    data.contentType = 'json';
    data.successF = function (returnData) {
        console.log("调用接口");
        var busiRspData = JSON.parse(returnData.busiRspData);
        $('body').append(busiRspData.htmlBody);
        location.replace(busiRspData.yeePayUrl);
        loadingMask("正在跳转...");
        setTimeout(function () {
            hideLoadingMask();
        }, 10000);
    };
    util.ajax(data);
};

/**
 * 沃支付
 */
var getWopayInfo = function () {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payMethod: payOrderInfo.payMethod,
        addStr: projectInfo.payAccessIp + projectInfo.payAccessProjectName
    };
    data.params.service = 'queryWopayInternetArgService';
    data.successF = function (returnData) {
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        var form = $('<form action="' + returnData.postUrl + '" method="post" id="wopayInternetForm"></form>').appendTo('body');
        $.each(returnData.argBo, function (key, val) {
            form.append('<input type="hidden" name="' + key + '" id="' + key + '" value="' + (val ? val : '') + '" />');
        });
        form.submit();
    };
    loadingMask('正在跳转沃支付...');
    util.ajax(data);
};

/**
 * 一码付
 */
var scanPolling = function () {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId
    };
    data.params.service = '/pay/pollingScanState';
    data.successF = function (returnData) {
        if (returnData.scanState == '00') {
            util.dialog.alert('正在使用' + returnData.payMethodName + '付款...', '提示', '重新扫码');
            timersearch = setInterval(function () {
                payWaiting(returnData);
            }, 1000);
        } else {
            setTimeout(function () {
                scanPolling();
            }, 1000);
        }
    };
    util.ajax(data);
};
var timersearch = null;
var payTimeout = 30;
var payWaiting = function (returnData) {
    if (payTimeout-- > 0) {
        qryPayResult(returnData.payOrderId);
        /*if (payTimeout == 5) {
            qrySourcePayResult(returnData.payOrderId);
        }*/
    } else {
        clearInterval(timersearch);
    }
};
var qryPayResult = function (payOrderId) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId
    };
    data.params.service = '/pay/pollingPayState';
    data.successF = function (returnData) {
        if (returnData.payStatus == 'SUCCESS') {
            clearInterval(timersearch);
            sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
            location.replace('payResult.html?payStatus=' + returnData.payStatus + "&rspName=" + returnData.rspName);
        }
    };
    util.ajax(data);
};
var qrySourcePayResult = function (payOrderId) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = '/pay/orderQuery';
    data.successF = function (returnData) {
        if (returnData.payStatus == 'SUCCESS') {
            clearInterval(timersearch);
            sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
            location.replace('payResult.html?payStatus=' + returnData.payStatus + "&rspName=" + returnData.rspName);
        }
    };
    util.ajax(data);
};

/**
 * mispos支付测试方法
 */
var misposPayTest = function () {
    if (!CIcCardCtrl.object) {
        util.dialog.alert('控件加载失败!');
        return;
    }
    var jsonParam = {
        'BUSI_AMT': '1', // Y 交易金额 单位：分
        'BUSI_TRANS_TYPE': 'Consume', // Y 交易类型
        'BUSI_CONSTRACT_CELLNO': '9900', // Y 业务受理号码(批量受理时以第一笔受理号码为准；小系统以单号为准，供后期在资金系统查询交易明细时使用)
        'BUSI_SYS': 'D400', // Y 业务系统编码，以全业务渠道编码为准
        'ORIGINAL_BUSI_ORDER_ID': '', // 原始订单号
        'ORIGINAL_TRANS_TYPE': '', // 原始交易类型
        'BUSI_ORDER_ID': '99000001' + new Date().Format('yyyyMMddhhmmssS') + new Date().Format('S'), // Y 业务侧支付订单号(必选 消费/撤销/退货) 例：'9900000120151128002001849955'
        'BUSI_TM': new Date().Format('yyyyMMddhhmmss'), // Y 业务系统交易发生时间
        'BUSI_TYPE': '1', // Y 业务类型（1:营业/2:账管/3:资源/4:购物车）
        'BUSI_NODE_ID': '13a0164', // Y 营业厅编号（总部渠道编码）
        'BUSI_STAFF_ID': 'LTHQY211', // Y 营业员工号
        'BUSI_NODE_PRO': '13', // Y 业务发生省份编码
        'BUSI_NODE_CITY': '130', // Y 业务发生地市编码
        'BUSI_NODE_AREA': '132006', // N 业务发生区县编码
        'BUSI_CELLNO': '' // N 业务办理手机号(电子签名短信下发使用)
    };
    var misposBackData = CIcCardCtrl.PosConsume(JSON.stringify(jsonParam));
    alert(misposBackData);
};

/**
 * mispos支付
 */
var misposPay = function () {
    if (!CIcCardCtrl.object) {
        util.dialog.alert('控件加载失败!');
        return;
    }

    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        realFee: payOrderInfo.realFee,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = "pmcUniPayIntfceService";
    data.successF = function (returnData) {
        var misposBackData = CIcCardCtrl.PosConsume(returnData.data);
        misposBackData = JSON.parse(misposBackData);
        // TRANS_STATUS: 00 支付成功，01 支付失败， 02 支付超时
        if (misposBackData.TRANS_STATUS == '00') {
            misposPayBack(misposBackData, 'SUCCESS');
        } else if (misposBackData.TRANS_STATUS == '01') {
            misposPayBack(misposBackData, 'FAIL');
        } else if (misposBackData.TRANS_STATUS == '02') {
            misposSearch(returnData.payOrderId);
        }
    };
    loadingMask('正在跳转MisPos支付...');
    util.ajax(data);
};

/**
 * 支付成功/失败，调用更新接口
 * @param misposBackData mispos消费的返回数据
 */
var misposPayBack = function (misposBackData, payStatus) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        data: JSON.stringify(misposBackData)
    };
    data.params.service = 'pmcMisposPayBackBusiService';
    data.successF = function (returnData) {
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        location.replace('payResult.html?payStatus=' + payStatus);
    };
    loadingMask('正在更新支付结果...');
    util.ajax(data);
};

/**
 * 支付超时，调用查询接口
 * @param payOrderId 支付订单号
 */
var misposSearch = function (payOrderId) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId
    };
    data.params.service = 'pmcMisposSearchBusiService';
    data.successF = function (returnData) {
        var misposBackData = CIcCardCtrl.PosSerach(returnData.data);
        misposBackData = JSON.parse(misposBackData);
        // TRANS_STATUS: 00 支付成功，01 支付失败， 02 支付超时
        if (misposBackData.TRANS_STATUS == '00') {
            misposSearchBack(misposBackData, 'SUCCESS');
        } else if (misposBackData.TRANS_STATUS == '01') {
            misposSearchBack(misposBackData, 'FAIL');
        } else if (misposBackData.TRANS_STATUS == '02') {
            misposSearch(returnData.payOrderId);
        }
    };
    loadingMask('支付超时，正在补单...');
    util.ajax(data);
};

/**
 * 支付超时查询成功之后，调用查询返回接口
 * @param misposBackData mispos补单的返回数据
 */
var misposSearchBack = function (misposBackData, payStatus) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        data: JSON.stringify(misposBackData)
    };
    data.params.service = 'pmcMisposSearchBackBusiService';
    data.successF = function (returnData) {
        sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
        location.replace('payResult.html?payStatus=' + payStatus);
    };
    loadingMask('正在更新支付结果...');
    util.ajax(data);
};

function showdiv (popWinId) {
    if (!window.XMLHttpRequest) {
        for (var i = 0; i < selects.length; i++) {
            if (selects[i].style.display != 'none') {
                selects_display.push(selects[i]);
                selects[i].style.display = 'none';
            }
        }
    }
    document.getElementById('bg_mask').style.display = 'block';
    document.getElementById(popWinId).style.display = 'block';
}

function hidediv (popWinId) {
    if (!window.XMLHttpRequest) {
        for (var i = 0; i < selects_display.length; i++) {
            selects_display[i].style.display = '';
        }
    }
    document.getElementById('bg_mask').style.display = 'none';
    document.getElementById(popWinId).style.display = 'none';
}

// 生成二维码
function createQrcode () {
    var text = projectInfo.payAccessIp + projectInfo.payAccessProjectName +
        'pay/rest/qrCode/uniQrCodePay/' + payOrderInfo.orderId +
        '/' + payOrderInfo.totalFee; // 二维码内容
    $('#qrCode').empty().qrcode({
        width: 260, // 宽度
        height: 260, // 高度
        correctLevel: 0,
        render: "canvas",
        text: text
    });
}
