/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.user.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.common.member.user.api.DycUmcCheckUserExistFunction;
import com.tydic.dyc.atom.common.member.user.bo.DycUmcCheckUserExistFuncReqBo;
import com.tydic.dyc.atom.common.member.user.bo.DycUmcCheckUserExistFuncRspBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.user.AuthCreateUserInfoService;
import com.tydic.dyc.authority.service.user.bo.AuthCreateUserInfoReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthCreateUserInfoRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthCustInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserTagRelBo;
import com.tydic.dyc.base.utils.EncryptUtils;
import com.tydic.dyc.base.utils.SaltUtils;
import com.tydic.dyc.common.member.user.api.DycUmcUserInfoAddService;
import com.tydic.dyc.common.member.user.bo.DycUmcUserInfoAddReqBo;
import com.tydic.dyc.common.member.user.bo.DycUmcUserInfoAddRspBo;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcEnumConstant;
import com.tydic.dyc.umc.service.domainservice.UmcUserInfoAddService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcUserInfoAddReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserTagRelBo;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycUmcUserInfoAddServiceImpl
implements DycUmcUserInfoAddService {
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcUserInfoAddService umcUserInfoAddService;
    @Autowired
    private DycUmcCheckUserExistFunction dycUmcCheckUserExistFunction;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="AUTHORITY_CENTER_DEV")
    private AuthCreateUserInfoService authCreateUserInfoService;
    @Autowired
    private EncryptUtils encryptUtils;
    @Value(value="${password.encryptType:SHA-256}")
    private String encryptType;
    @Value(value="${password.default:123456}")
    private String defaultPasswd;
    @Value(value="${role.default.purchaser:1L:\"\u9ed8\u8ba4\u91c7\u8d2d\u89d2\u8272\"}")
    private String defaultPurchaserRole;
    @Value(value="${role.default.supplier:2L:\"\u9ed8\u8ba4\u4f9b\u5e94\u89d2\u8272\"}")
    private String defaultSupplierRole;
    private static final String USER_SOURCE = "0";

    @Override
    public DycUmcUserInfoAddRspBo addMember(DycUmcUserInfoAddReqBo reqBo) {
        this.validReqParams(reqBo);
        if (!StringUtils.isEmpty((Object)reqBo.getRegAccount())) {
            DycUmcCheckUserExistFuncReqBo umcCheckUserExistFuncReqBo = new DycUmcCheckUserExistFuncReqBo();
            umcCheckUserExistFuncReqBo.setRegAccount(reqBo.getRegAccount());
            DycUmcCheckUserExistFuncRspBo umcCheckUserExistFuncRspBo = this.dycUmcCheckUserExistFunction.checkAddUserExist(umcCheckUserExistFuncReqBo);
            if (umcCheckUserExistFuncRspBo.getIsExistFlag().equals("1")) {
                throw new ZTBusinessException("\u7528\u6237\u540d\u5df2\u5b58\u5728");
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getRegMobile())) {
            DycUmcCheckUserExistFuncReqBo umcCheckUserExistFuncReqBo1 = new DycUmcCheckUserExistFuncReqBo();
            umcCheckUserExistFuncReqBo1.setRegAccount(reqBo.getRegAccount());
            DycUmcCheckUserExistFuncRspBo umcCheckUserExistFuncRspBo1 = this.dycUmcCheckUserExistFunction.checkAddUserExist(umcCheckUserExistFuncReqBo1);
            if (umcCheckUserExistFuncRspBo1.getIsExistFlag().equals("1")) {
                throw new ZTBusinessException("\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a");
            }
        }
        AuthCreateUserInfoReqBo authCreateUserInfoReqBo = this.buildAuthMember(reqBo);
        AuthCreateUserInfoRspBo authCreateUserInfoRspBo = this.authCreateUserInfoService.createUserInfo(authCreateUserInfoReqBo);
        UmcUserInfoAddReqBo umcUserInfoAddReqBo = this.buildMember(reqBo, authCreateUserInfoRspBo.getUserInfoBo());
        this.umcUserInfoAddService.createUserInfo(umcUserInfoAddReqBo);
        DycUmcUserInfoAddRspBo rspBo = new DycUmcUserInfoAddRspBo();
        rspBo.setCode(USER_SOURCE);
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private AuthCreateUserInfoReqBo buildAuthMember(DycUmcUserInfoAddReqBo reqBo) {
        AuthCreateUserInfoReqBo authCreateUserInfoReqBo = new AuthCreateUserInfoReqBo();
        authCreateUserInfoReqBo.setOrgId(reqBo.getOrgIdWeb());
        authCreateUserInfoReqBo.setIsMain("00");
        authCreateUserInfoReqBo.setCreateTime(new Date());
        authCreateUserInfoReqBo.setCreateOperId(reqBo.getUserIdIn());
        authCreateUserInfoReqBo.setCreateOperName(reqBo.getCustNameIn());
        AuthCustInfoBo authCustInfoBo = new AuthCustInfoBo();
        authCustInfoBo.setLoginName(reqBo.getRegAccount());
        String password = reqBo.getPassword();
        if (StringUtils.isEmpty((Object)password)) {
            password = this.defaultPasswd;
        }
        String encrypt = this.encryptUtils.encryptByType(password, this.encryptType);
        String salt = SaltUtils.getSerialNo((int)8);
        String pwd = this.encryptUtils.encryptByType(encrypt + salt, this.encryptType);
        authCustInfoBo.setCustPassword(pwd);
        authCustInfoBo.setPasswordSalt(salt);
        authCustInfoBo.setCustName(reqBo.getCustName());
        authCustInfoBo.setCellPhone(reqBo.getRegMobile());
        authCustInfoBo.setCustEmail(reqBo.getRegEmail());
        authCustInfoBo.setCustStatus("01");
        authCustInfoBo.setCustSource(USER_SOURCE);
        authCustInfoBo.setCreateOperId(reqBo.getUserIdIn());
        authCustInfoBo.setCreateOperName(reqBo.getCustNameIn());
        authCustInfoBo.setCreateTime(new Date());
        authCreateUserInfoReqBo.setCustInfo(authCustInfoBo);
        ArrayList<AuthDistributeBo> authDistributeBoList = new ArrayList<AuthDistributeBo>();
        if (!CollectionUtils.isEmpty(reqBo.getRoleIdList())) {
            for (Long roleId : reqBo.getRoleIdList()) {
                AuthDistributeBo authDistributeBo = new AuthDistributeBo();
                authDistributeBo.setRoleId(roleId);
                authDistributeBo.setOrgId(reqBo.getOrgIdWeb());
                authDistributeBo.setCreateOperId(reqBo.getUserIdIn());
                authDistributeBo.setCreateTime(new Date());
                authDistributeBo.setCreateOperName(reqBo.getCustNameIn());
                authDistributeBoList.add(authDistributeBo);
            }
        }
        ArrayList<AuthUserTagRelBo> userTagRelBoList = new ArrayList<AuthUserTagRelBo>(reqBo.getTagIdList().size());
        if (!CollectionUtils.isEmpty(reqBo.getTagIdList())) {
            for (String tagId : reqBo.getTagIdList()) {
                AuthUserTagRelBo authUserTagRelBo = new AuthUserTagRelBo();
                authUserTagRelBo.setTagId(Long.valueOf(tagId));
                authUserTagRelBo.setCreateOperId(reqBo.getUserIdIn());
                authUserTagRelBo.setCreateTime(new Date());
                authUserTagRelBo.setCreateOperName(reqBo.getCustNameIn());
                userTagRelBoList.add(authUserTagRelBo);
            }
        }
        authCreateUserInfoReqBo.setUserTagRelList(userTagRelBoList);
        authCreateUserInfoReqBo.setAuthDistributeList(authDistributeBoList);
        return authCreateUserInfoReqBo;
    }

    private UmcUserInfoAddReqBo buildMember(DycUmcUserInfoAddReqBo reqBo, AuthUserInfoBo authUserInfoBo) {
        UmcUserInfoAddReqBo umcUserInfoAddReqBo = new UmcUserInfoAddReqBo();
        umcUserInfoAddReqBo.setUserId(authUserInfoBo.getUserId());
        umcUserInfoAddReqBo.setCustId(authUserInfoBo.getCustId());
        umcUserInfoAddReqBo.setMainCustId(authUserInfoBo.getCustId());
        umcUserInfoAddReqBo.setOrgId(reqBo.getOrgIdWeb());
        umcUserInfoAddReqBo.setIsMain("00");
        UmcCustInfoBo custInfoBo = new UmcCustInfoBo();
        custInfoBo.setWorkNo(reqBo.getWorkNo());
        custInfoBo.setOfficePhone(reqBo.getOfficePhone());
        custInfoBo.setStopStatus("01");
        custInfoBo.setCustAffiliation(reqBo.getCustAffiliation());
        custInfoBo.setCustType(reqBo.getCustType());
        if (!StringUtils.isEmpty((Object)reqBo.getCustClassify())) {
            custInfoBo.setCustClassify("2");
        } else {
            custInfoBo.setCustClassify(reqBo.getCustClassify());
        }
        custInfoBo.setRegAccount(reqBo.getRegAccount());
        custInfoBo.setRegMobile(reqBo.getRegMobile());
        custInfoBo.setRegEmail(reqBo.getRegEmail());
        custInfoBo.setIsOnline(UmcEnumConstant.IsOnline.NO.getCode());
        custInfoBo.setCustStatus(UmcEnumConstant.CustState.EFFECTIVE.getCode());
        custInfoBo.setPasswd(reqBo.getPasswd());
        custInfoBo.setIsPasswdValid(UmcEnumConstant.IsPasswdValid.YES.getCode());
        custInfoBo.setMaxRepeatLoginNum(UmcCommConstant.UmcDefaultValue.MAX_REPEAT_LOGIN_NUM);
        custInfoBo.setCustName(reqBo.getCustName());
        custInfoBo.setCustNickname(reqBo.getCustNickname());
        custInfoBo.setSex(reqBo.getSex());
        custInfoBo.setCertNo(reqBo.getCertNo());
        custInfoBo.setCertType(UmcEnumConstant.CertType.ID_18.getCode());
        custInfoBo.setIsBlacklist(UmcEnumConstant.IsBlacklist.NO.getCode());
        custInfoBo.setCreateTime(new Date());
        custInfoBo.setCreateOperId(reqBo.getUserIdIn());
        custInfoBo.setCreateOperName(reqBo.getCustNameIn());
        umcUserInfoAddReqBo.setCustInfoBo(custInfoBo);
        ArrayList<UmcUserTagRelBo> userTagRelBoList = new ArrayList<UmcUserTagRelBo>(reqBo.getTagIdList().size());
        if (!CollectionUtils.isEmpty(reqBo.getTagIdList())) {
            for (String tagId : reqBo.getTagIdList()) {
                UmcUserTagRelBo umcUserTagRelBo = new UmcUserTagRelBo();
                umcUserTagRelBo.setTagId(tagId);
                umcUserTagRelBo.setCreateOperId(reqBo.getUserIdIn());
                umcUserTagRelBo.setCreateTime(new Date());
                umcUserTagRelBo.setCreateOperName(reqBo.getCustNameIn());
                userTagRelBoList.add(umcUserTagRelBo);
            }
        }
        umcUserInfoAddReqBo.setUserTagRelBoList(userTagRelBoList);
        return umcUserInfoAddReqBo;
    }

    private void validReqParams(DycUmcUserInfoAddReqBo reqBo) {
        if (reqBo == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (reqBo.getOrgIdWeb() == null) {
            throw new ZTBusinessException("\u673a\u6784ID\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getRegAccount())) {
            throw new ZTBusinessException("\u7528\u6237\u540d\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getCustName())) {
            throw new ZTBusinessException("\u59d3\u540d\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getRegMobile())) {
            throw new ZTBusinessException("\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getRegEmail())) {
            throw new ZTBusinessException("\u90ae\u7bb1\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getMemUserType())) {
            throw new ZTBusinessException("\u7528\u6237\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getWorkNo()) && reqBo.getWorkNo().length() > 10) {
            throw new ZTBusinessException("\u5de5\u53f7\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e10");
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPasswd())) {
            if (StringUtils.isEmpty((Object)reqBo.getConfirmPasswd())) {
                throw new ZTBusinessException("\u786e\u8ba4\u5bc6\u7801\u4e3a\u7a7a");
            }
            if (!reqBo.getPasswd().equals(reqBo.getConfirmPasswd())) {
                throw new ZTBusinessException("\u5bc6\u7801\u4e0e\u786e\u8ba4\u5bc6\u7801\u4e0d\u4e00\u81f4");
            }
        }
    }
}

