/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.invoiceaddress.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.common.member.invoiceaddress.api.DycUmcInvoiceAddressAddService;
import com.tydic.dyc.common.member.invoiceaddress.bo.DycUmcInvoiceAddressAddReqBo;
import com.tydic.dyc.common.member.invoiceaddress.bo.DycUmcInvoiceAddressAddRspBo;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.service.enterprise.UmcOrgInfoCheckService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoCheckReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoCheckRspBo;
import com.tydic.dyc.umc.service.invoiceaddress.UmcInvoiceAddressAddService;
import com.tydic.dyc.umc.service.invoiceaddress.bo.UmcInvoiceAddressAddReqBo;
import com.tydic.dyc.umc.service.invoiceaddress.bo.UmcInvoiceAddressAddRspBo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DycUmcInvoiceAddressAddServiceImpl
implements DycUmcInvoiceAddressAddService {
    private static final Logger log = LoggerFactory.getLogger(DycUmcInvoiceAddressAddServiceImpl.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcInvoiceAddressAddService umcInvoiceAddressAddService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcOrgInfoCheckService umcOrgInfoCheckService;

    @Override
    public DycUmcInvoiceAddressAddRspBo addInvoiceAddress(DycUmcInvoiceAddressAddReqBo reqBo) {
        this.validateParams(reqBo);
        DycUmcInvoiceAddressAddRspBo rspBo = new DycUmcInvoiceAddressAddRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (null != reqBo.getAccountId()) {
            this.checkAccount(reqBo.getAccountId());
        }
        this.checkOrg(reqBo.getOrgIdWeb());
        UmcInvoiceAddressAddReqBo invoiceAddressAddReqBo = (UmcInvoiceAddressAddReqBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBo)), UmcInvoiceAddressAddReqBo.class);
        invoiceAddressAddReqBo.setName(reqBo.getCustNameIn());
        UmcInvoiceAddressAddRspBo umcInvoiceAddressAddRspBo = this.umcInvoiceAddressAddService.addInvoiceAddress(invoiceAddressAddReqBo);
        if (!"0000".equals(umcInvoiceAddressAddRspBo.getRespCode())) {
            throw new ZTBusinessException(umcInvoiceAddressAddRspBo.getRespDesc());
        }
        rspBo.setId(umcInvoiceAddressAddRspBo.getId());
        return rspBo;
    }

    private void checkAccount(Long accountId) {
    }

    private void checkOrg(Long orgId) {
        UmcOrgInfoCheckReqBo orgInfoCheckReqBo = new UmcOrgInfoCheckReqBo();
        orgInfoCheckReqBo.setOrgId(orgId);
        UmcOrgInfoCheckRspBo umcOrgInfoCheckRspBo = this.umcOrgInfoCheckService.checkOrgInfo(orgInfoCheckReqBo);
        if (umcOrgInfoCheckRspBo == null || umcOrgInfoCheckRspBo.getResult() == null) {
            throw new ZTBusinessException("\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u5931\u8d25\uff0c\u8be5\u673a\u6784[" + orgId + "]\u4e0d\u5b58\u5728");
        }
        if (umcOrgInfoCheckRspBo.getResult() < 1) {
            throw new ZTBusinessException("\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u5931\u8d25\uff0c\u8be5\u673a\u6784[" + orgId + "]\u4e0d\u5b58\u5728");
        }
    }

    private void validateParams(DycUmcInvoiceAddressAddReqBo reqBo) {
        if (null == reqBo.getOrgIdWeb()) {
            throw new BaseBusinessException("201001", "\u673a\u6784ID[orgIdWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getContactNameWeb())) {
            throw new BaseBusinessException("201001", "\u8054\u7cfb\u4eba[contactNameWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getAddrDesc())) {
            throw new BaseBusinessException("201001", "\u8be6\u7ec6\u5730\u5740[addrDesc]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getAreaName())) {
            throw new BaseBusinessException("201001", "\u6240\u5728\u5730\u533a\u540d\u79f0[areaName]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getTel())) {
            throw new BaseBusinessException("201001", "\u624b\u673a\u53f7\u7801[areaName]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getMainFlag()) {
            throw new BaseBusinessException("201001", "\u662f\u5426\u9ed8\u8ba4\u5730\u5740[mainFlag]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UmcCommConstant.InvAddrMainFlag.YES.equals(reqBo.getMainFlag()) && !UmcCommConstant.InvAddrMainFlag.NO.equals(reqBo.getMainFlag())) {
            throw new BaseBusinessException("201001", "\u662f\u5426\u9ed8\u8ba4\u5730\u5740[mainFlag]\u53c2\u6570\u53ea\u80fd\u4e3a0\u62161");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getAreaCode())) {
            throw new BaseBusinessException("201001", "\u6240\u5728\u5730\u533a\u7f16\u7801[areaCode]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getMemIdExt()) {
            throw new BaseBusinessException("201001", "\u4f1a\u5458ID[memIdExt]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

