/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.menu.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.tydic.dyc.authority.service.menu.AuthGetMenuListService;
import com.tydic.dyc.authority.service.menu.bo.AuthGetMenuListReqBo;
import com.tydic.dyc.authority.service.menu.bo.AuthGetMenuListRspBo;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.common.member.menu.api.DycAuthGetMenuListService;
import com.tydic.dyc.common.member.menu.bo.DycAuthGetMenuListReqBo;
import com.tydic.dyc.common.member.menu.bo.DycAuthGetMenuListRspBo;
import com.tydic.dyc.common.member.menu.bo.DycAuthMenuInfoBo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DycAuthGetMenuListServiceImpl
implements DycAuthGetMenuListService {
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="AUTHORITY_CENTER_DEV")
    private AuthGetMenuListService authGetMenuListService;

    @Override
    public DycAuthGetMenuListRspBo getMenuList(DycAuthGetMenuListReqBo reqBo) {
        this.validateArg(reqBo);
        AuthGetMenuListReqBo authReqBo = (AuthGetMenuListReqBo)JUtil.js((Object)((Object)reqBo), AuthGetMenuListReqBo.class);
        AuthGetMenuListRspBo authRspBo = this.authGetMenuListService.getMenuList(authReqBo);
        List menuInfos = JUtil.jsl((List)authRspBo.getMenuInfoBoList(), AuthMenuInfoBo.class);
        DycAuthGetMenuListRspBo rspBo = new DycAuthGetMenuListRspBo();
        if (menuInfos.size() > 0) {
            List<AuthMenuInfoBo> buildByRecursive = this.buildByRecursive(menuInfos);
            rspBo.setMenuInfoBoList(JUtil.jsl(buildByRecursive, DycAuthMenuInfoBo.class));
        }
        return rspBo;
    }

    private void validateArg(DycAuthGetMenuListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[DycAuthGetMenuListReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getApplicationCode())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[ApplicationCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<AuthMenuInfoBo> buildByRecursive(List<AuthMenuInfoBo> treeNodes) {
        Collections.sort(treeNodes);
        ArrayList<AuthMenuInfoBo> trees = new ArrayList<AuthMenuInfoBo>();
        for (AuthMenuInfoBo treeNode : treeNodes) {
            if (treeNode.getParentId() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        Collections.sort(trees);
        return trees;
    }

    private AuthMenuInfoBo findChildren(AuthMenuInfoBo root, List<AuthMenuInfoBo> allMenus) {
        for (AuthMenuInfoBo it : allMenus) {
            if (!root.getMenuId().equals(it.getParentId())) continue;
            if (root.getChildren() == null) {
                root.setChildren(new ArrayList());
            }
            root.getChildren().add(this.findChildren(it, allMenus));
        }
        return root;
    }
}

