/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.estore.api.DycUocEstoreAfterOrderApplyFunction;
import com.tydic.dyc.atom.estore.bo.DycComUocAddressFuncBO;
import com.tydic.dyc.atom.estore.bo.DycComUocAfterOrderItemFuncBO;
import com.tydic.dyc.atom.estore.bo.DycComUocAttachFuncBO;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreAfterOrderApplyFuncReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreAfterOrderApplyFuncRspBO;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfsApplyInfoItem;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfsCustomerInfo;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfsPickupWareInfo;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfsReturnWareInfo;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfterOrderEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.CustomerEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.DetailEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.JDAfterOrderEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.PickwareEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.WareDescInfo;
import com.tydic.dyc.atom.estore.bo.afterOrder.WareDetailInfo;
import com.tydic.dyc.oc.service.domainservice.UocGetAfOrderDetailService;
import com.tydic.dyc.oc.service.domainservice.UocQryShipOrderDetailsService;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspDetailItemBo;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycUocEstoreAfterOrderApplyFunctionImpl
implements DycUocEstoreAfterOrderApplyFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocEstoreAfterOrderApplyFunctionImpl.class);
    @Autowired
    private UocGetAfOrderDetailService uocGetAfOrderDetailService;
    @Autowired
    private UocGetSaleOrderDetailService uocGetSaleOrderDetailService;
    @Autowired
    private UocQryShipOrderDetailsService uocQryShipOrderDetailsService;
    @Value(value="${ESB_JD_TRANS_URL}")
    private String transUrl;

    @Override
    public DycUocEstoreAfterOrderApplyFuncRspBO createEstoreAfterOrder(DycUocEstoreAfterOrderApplyFuncReqBO reqBo) {
        DycUocEstoreAfterOrderApplyFuncRspBO rsp = new DycUocEstoreAfterOrderApplyFuncRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        this.validateArg(reqBo);
        UocQryShipOrderDetailsReqBo uocQryShipOrderDetailsReqBo = new UocQryShipOrderDetailsReqBo();
        uocQryShipOrderDetailsReqBo.setOrderId(reqBo.getOrderId());
        uocQryShipOrderDetailsReqBo.setShipOrderId(reqBo.getShipOrderId());
        UocQryShipOrderDetailsRspBo uocQryShipOrderDetailsRspBo = this.uocQryShipOrderDetailsService.qryShipOrderDetails(uocQryShipOrderDetailsReqBo);
        if (!"0000".equals(uocQryShipOrderDetailsRspBo.getRespCode())) {
            throw new ZTBusinessException("\u53d1\u8d27\u5355\u67e5\u8be2\u5f02\u5e38,\u5f02\u5e38\u7f16\u7801\u3010" + uocQryShipOrderDetailsRspBo.getRespCode() + "\u3011," + uocQryShipOrderDetailsRspBo.getRespDesc());
        }
        UocGetSaleOrderDetailServiceReqBo uocGetSaleOrderDetailServiceReqBo = new UocGetSaleOrderDetailServiceReqBo();
        uocGetSaleOrderDetailServiceReqBo.setOrderId(reqBo.getOrderId());
        uocGetSaleOrderDetailServiceReqBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocGetSaleOrderDetailServiceRspBo saleOrderDetail = this.uocGetSaleOrderDetailService.getSaleOrderDetail(uocGetSaleOrderDetailServiceReqBo);
        if (!"0000".equals(saleOrderDetail.getRespCode())) {
            throw new ZTBusinessException("\u8ba2\u5355\u67e5\u8be2\u5f02\u5e38,\u5f02\u5e38\u7f16\u7801\u3010" + saleOrderDetail.getRespCode() + "\u3011," + saleOrderDetail.getRespDesc());
        }
        AfterOrderEntity afterOrderEntity = this.buildAfterOrderEntity(uocQryShipOrderDetailsRspBo, saleOrderDetail, reqBo);
        String hsn = DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + saleOrderDetail.getSupId()));
        if (saleOrderDetail.getSupId().equals(DycPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID"))) {
            this.transJdAdd(reqBo.getAddress(), hsn, reqBo.getReturnAddress(), reqBo.getJdOrgId());
            this.transJdAdd(reqBo.getAddress(), hsn, reqBo.getTakeAddress(), reqBo.getJdOrgId());
            JDAfterOrderEntity jdAfterOrderEntity = this.buildJDAfterOrderEntity(uocQryShipOrderDetailsRspBo, saleOrderDetail, reqBo);
            JSONObject jdParam = new JSONObject();
            jdParam.put("param", (Object)jdAfterOrderEntity);
            log.info("\u4eac\u4e1c\u552e\u540e\u53d1\u8d77httpReqStr: {}", (Object)JSONObject.toJSONString((Object)jdParam));
            try {
                String httpRspStr = DycEsbUtil.doPostReuest((String)reqBo.getRequestUrl(), (String)JSONObject.toJSONString((Object)jdParam), (String)hsn);
                log.info("\u4eac\u4e1c\u552e\u540e\u53d1\u8d77httpRspStr: {}", (Object)httpRspStr);
                JSONObject rspJsonObject = JSONObject.parseObject((String)httpRspStr);
                if (!rspJsonObject.getBoolean("success").booleanValue()) {
                    throw new ZTBusinessException("\u552e\u540e\u8c03\u7528\u7535\u5546\u5f02\u5e38");
                }
                rsp.setServiceId(jdAfterOrderEntity.getThirdApplyId());
                rsp.setThirdApplyId(jdAfterOrderEntity.getThirdApplyId());
            }
            catch (Exception e) {
                throw new ZTBusinessException(e.getMessage());
            }
        }
        try {
            log.info("\u552e\u540e\u53d1\u8d77httpReqStr: {}", (Object)JSONObject.toJSONString((Object)afterOrderEntity));
            String httpRspStr = DycEsbUtil.doPostReuest((String)reqBo.getRequestUrl(), (String)JSONObject.toJSONString((Object)afterOrderEntity), (String)hsn);
            log.info("\u552e\u540e\u53d1\u8d77httpRspStr: {}", (Object)httpRspStr);
            this.resolveRsp(httpRspStr, rsp);
        }
        catch (ZTBusinessException e) {
            throw new ZTBusinessException(e.getMessage());
        }
        return rsp;
    }

    private void transJdAdd(String address, String hsn, DycComUocAddressFuncBO addressBO, String orgId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("address", address);
        map.put("orgId", orgId);
        String httpRspStr = DycEsbUtil.doPostReuest((String)this.transUrl, (String)JSONObject.toJSONString(map), (String)hsn);
        log.info("\u4eac\u4e1c\u5730\u5740\u8f6c\u6362httpRspStr: {}", (Object)httpRspStr);
        JSONObject rspJsonObject = JSONObject.parseObject((String)httpRspStr);
        if (rspJsonObject.getBoolean("success").booleanValue() && rspJsonObject.get((Object)"resultCode").equals("0000")) {
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            addressBO.setContactProvinceId(String.valueOf(jsonObject.get((Object)"provinceId")) == null ? "0" : String.valueOf(jsonObject.get((Object)"provinceId")));
            addressBO.setContactCityId(String.valueOf(jsonObject.get((Object)"cityId")) == null ? "0" : String.valueOf(jsonObject.get((Object)"cityId")));
            addressBO.setContactCountryId(String.valueOf(jsonObject.get((Object)"countyId")) == null ? "0" : String.valueOf(jsonObject.get((Object)"countyId")));
            addressBO.setContactTownId(String.valueOf(jsonObject.get((Object)"townId")) == null ? "0" : String.valueOf(jsonObject.get((Object)"townId")));
        }
    }

    private void resolveRsp(String httpRspStr, DycUocEstoreAfterOrderApplyFuncRspBO rsp) {
        JSONObject rspJsonObject = JSONObject.parseObject((String)httpRspStr);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            String defineAfsOrderIdName;
            JSONObject jsonObject;
            if (rspJsonObject.get((Object)"result") != null && (jsonObject = (JSONObject)rspJsonObject.get((Object)"result")).get((Object)(defineAfsOrderIdName = "serviceId")) != null) {
                rsp.setServiceId(String.valueOf(jsonObject.get((Object)"serviceId")));
            }
        } else {
            throw new ZTBusinessException("\u552e\u540e\u8c03\u7528\u7535\u5546\u5f02\u5e38");
        }
    }

    private AfterOrderEntity buildAfterOrderEntity(UocQryShipOrderDetailsRspBo uocQryShipOrderDetailsRspBo, UocGetSaleOrderDetailServiceRspBo orderAllDetail, DycUocEstoreAfterOrderApplyFuncReqBO reqBO) {
        AfterOrderEntity afterOrderEntity = new AfterOrderEntity();
        afterOrderEntity.setOrgId(orderAllDetail.getPurOrgId());
        String orderNoExt = orderAllDetail.getSaleOrderNoExt();
        List saleOrderDetailServiceRspItemBoList = orderAllDetail.getSaleOrderDetailServiceRspItemBoList();
        Map<String, UocGetSaleOrderDetailServiceRspItemBo> saleItemMaps = saleOrderDetailServiceRspItemBoList.stream().collect(Collectors.toMap(UocGetSaleOrderDetailServiceRspItemBo::getSkuId, o -> o));
        afterOrderEntity.setOrderId(orderNoExt);
        String shipOrderNoExt = uocQryShipOrderDetailsRspBo.getShipOrderInfo().getShipOrderNoExt();
        List shipOrderItemBoList = uocQryShipOrderDetailsRspBo.getShipOrderInfo().getShipOrderItemBoList();
        Map<Long, UocQryShipOrderDetailsRspDetailItemBo> shipOrderItemMaps = shipOrderItemBoList.stream().collect(Collectors.toMap(UocQryShipOrderDetailsRspDetailItemBo::getShipOrderItemId, o -> o));
        afterOrderEntity.setPackageId(shipOrderNoExt);
        CustomerEntity customerEntity = new CustomerEntity();
        PickwareEntity pickwareEntity = new PickwareEntity();
        if (ObjectUtil.isNotEmpty((Object)((Object)reqBO))) {
            afterOrderEntity.setServiceType(reqBO.getServType());
            afterOrderEntity.setQuestionDesc(reqBO.getQuestionDesc());
            List<DycComUocAttachFuncBO> orderAccessoryBoList = reqBO.getOrderAccessoryBoList();
            if (CollectionUtil.isNotEmpty(orderAccessoryBoList)) {
                afterOrderEntity.setQuestionPic(orderAccessoryBoList.stream().map(x -> x.getAccessoryUrl()).collect(Collectors.joining(",")));
            }
            customerEntity.setCustomerContactName(reqBO.getName());
            customerEntity.setCustomerMobilePhone(reqBO.getCellphone());
            pickwareEntity.setPickwareType(reqBO.getPickwareType());
            DycComUocAddressFuncBO takeAddress = reqBO.getTakeAddress();
            if (ObjectUtil.isNotEmpty((Object)takeAddress)) {
                pickwareEntity.setPickwareProvince(ObjectUtil.isEmpty((Object)takeAddress.getContactProvinceId()) ? null : Integer.valueOf(takeAddress.getContactProvinceId()));
                pickwareEntity.setPickwareCity(ObjectUtil.isEmpty((Object)takeAddress.getContactCityId()) ? null : Integer.valueOf(takeAddress.getContactCityId()));
                pickwareEntity.setPickwareCounty(ObjectUtil.isEmpty((Object)takeAddress.getContactCountyId()) ? null : Integer.valueOf(takeAddress.getContactCountyId()));
                pickwareEntity.setPickwareVillage(ObjectUtil.isEmpty((Object)takeAddress.getContactTownId()) ? null : Integer.valueOf(takeAddress.getContactTownId()));
                pickwareEntity.setPickwareAddress(takeAddress.getContactAddress());
            }
        }
        afterOrderEntity.setCustomer(customerEntity);
        afterOrderEntity.setPickware(pickwareEntity);
        ArrayList<DetailEntity> detailEntities = new ArrayList<DetailEntity>();
        List<DycComUocAfterOrderItemFuncBO> shipItemList = reqBO.getShipItemList();
        if (CollectionUtil.isNotEmpty(shipItemList)) {
            for (DycComUocAfterOrderItemFuncBO dycComUocAfterOrderItemFuncBO : shipItemList) {
                UocQryShipOrderDetailsRspDetailItemBo shipItem = shipOrderItemMaps.get(dycComUocAfterOrderItemFuncBO.getShipOrderItemId());
                String skuExtSkuId = saleItemMaps.get(shipItem.getSkuId()).getSkuExtSkuId();
                DetailEntity detailEntity = new DetailEntity();
                detailEntity.setSkuId(skuExtSkuId);
                detailEntity.setSkuNum(dycComUocAfterOrderItemFuncBO.getReturnCount().toPlainString());
                detailEntities.add(detailEntity);
            }
        }
        afterOrderEntity.setDetail(detailEntities);
        return afterOrderEntity;
    }

    private JDAfterOrderEntity buildJDAfterOrderEntity(UocQryShipOrderDetailsRspBo uocQryShipOrderDetailsRspBo, UocGetSaleOrderDetailServiceRspBo orderAllDetail, DycUocEstoreAfterOrderApplyFuncReqBO reqBO) {
        List<DycComUocAfterOrderItemFuncBO> shipItemList;
        JDAfterOrderEntity afterOrderEntity = new JDAfterOrderEntity();
        List saleOrderDetailServiceRspItemBoList = orderAllDetail.getSaleOrderDetailServiceRspItemBoList();
        Map<String, UocGetSaleOrderDetailServiceRspItemBo> saleItemMaps = saleOrderDetailServiceRspItemBoList.stream().collect(Collectors.toMap(UocGetSaleOrderDetailServiceRspItemBo::getSkuId, o -> o));
        String orderNoExt = orderAllDetail.getSaleOrderNoExt();
        afterOrderEntity.setOrderId(orderNoExt);
        afterOrderEntity.setOrgId(orderAllDetail.getPurOrgId());
        afterOrderEntity.setThirdApplyId(String.valueOf(System.currentTimeMillis()));
        List shipOrderItemBoList = uocQryShipOrderDetailsRspBo.getShipOrderInfo().getShipOrderItemBoList();
        Map<Long, UocQryShipOrderDetailsRspDetailItemBo> shipOrderItemMaps = shipOrderItemBoList.stream().collect(Collectors.toMap(UocQryShipOrderDetailsRspDetailItemBo::getShipOrderItemId, o -> o));
        if (ObjectUtil.isNotEmpty((Object)((Object)reqBO))) {
            DycComUocAddressFuncBO returnAddress;
            AfsCustomerInfo customerInfo = new AfsCustomerInfo();
            customerInfo.setCustomerName(reqBO.getUsername());
            customerInfo.setCustomerContactName(ObjectUtil.isNotEmpty((Object)reqBO.getTakeAddress()) ? reqBO.getTakeAddress().getContactName() : reqBO.getReturnAddress().getContactName());
            customerInfo.setCustomerMobilePhone(ObjectUtil.isNotEmpty((Object)reqBO.getTakeAddress()) ? reqBO.getTakeAddress().getContactMobile() : reqBO.getReturnAddress().getContactMobile());
            afterOrderEntity.setCustomerInfo(customerInfo);
            DycComUocAddressFuncBO takeAddress = reqBO.getTakeAddress();
            if (ObjectUtil.isNotEmpty((Object)takeAddress)) {
                AfsPickupWareInfo pickwareInfo = new AfsPickupWareInfo();
                pickwareInfo.setPickwareType(reqBO.getPickwareType());
                pickwareInfo.setPickWareProvince(ObjectUtil.isEmpty((Object)takeAddress) ? null : Integer.valueOf(takeAddress.getContactProvinceId()));
                pickwareInfo.setPickWareCity(ObjectUtil.isEmpty((Object)takeAddress.getContactCityId()) ? null : Integer.valueOf(takeAddress.getContactCityId()));
                pickwareInfo.setPickWareCounty(ObjectUtil.isEmpty((Object)takeAddress.getContactCountyId()) ? null : Integer.valueOf(takeAddress.getContactCountyId()));
                pickwareInfo.setPickWareVillage(ObjectUtil.isEmpty((Object)takeAddress.getContactTownId()) ? 0 : Integer.valueOf(takeAddress.getContactTownId()));
                pickwareInfo.setPickWareAddress(ObjectUtil.isEmpty((Object)takeAddress.getContactAddress()) ? null : takeAddress.getContactAddress());
                afterOrderEntity.setPickwareInfo(pickwareInfo);
            }
            if (ObjectUtil.isNotEmpty((Object)(returnAddress = reqBO.getReturnAddress()))) {
                AfsReturnWareInfo returnWareInfo = new AfsReturnWareInfo();
                returnWareInfo.setReturnWareType(10);
                returnWareInfo.setReturnWareProvince(ObjectUtil.isEmpty((Object)returnAddress.getContactProvinceId()) ? null : Integer.valueOf(returnAddress.getContactProvinceId()));
                returnWareInfo.setReturnWareCity(ObjectUtil.isEmpty((Object)returnAddress.getContactCityId()) ? null : Integer.valueOf(returnAddress.getContactCityId()));
                returnWareInfo.setReturnWareCountry(ObjectUtil.isEmpty((Object)returnAddress.getContactCityId()) ? null : Integer.valueOf(returnAddress.getContactCityId()));
                returnWareInfo.setReturnWareVillage(ObjectUtil.isEmpty((Object)returnAddress.getContactTownId()) ? 0 : Integer.parseInt(returnAddress.getContactTownId()));
                returnWareInfo.setReturnWareAddress(ObjectUtil.isEmpty((Object)returnAddress.getContactAddress()) ? null : returnAddress.getContactAddress());
                afterOrderEntity.setReturnWareInfo(returnWareInfo);
            }
        }
        if (CollectionUtil.isNotEmpty(shipItemList = reqBO.getShipItemList())) {
            ArrayList<AfsApplyInfoItem> afsApplyInfoItemList = new ArrayList<AfsApplyInfoItem>();
            for (DycComUocAfterOrderItemFuncBO dycComUocAfterOrderItemFuncBO : shipItemList) {
                UocQryShipOrderDetailsRspDetailItemBo shipItem = shipOrderItemMaps.get(dycComUocAfterOrderItemFuncBO.getShipOrderItemId());
                String skuExtSkuId = saleItemMaps.get(shipItem.getSkuId()).getSkuExtSkuId();
                AfsApplyInfoItem afsApplyInfoItem = new AfsApplyInfoItem();
                afsApplyInfoItem.setCustomerExpect(reqBO.getServType());
                WareDescInfo wareDescInfo = new WareDescInfo();
                List<DycComUocAttachFuncBO> orderAccessoryBoList = reqBO.getOrderAccessoryBoList();
                if (CollectionUtil.isNotEmpty(orderAccessoryBoList)) {
                    wareDescInfo.setQuestionPic(orderAccessoryBoList.stream().map(x -> x.getAccessoryUrl()).collect(Collectors.joining(",")));
                }
                wareDescInfo.setQuestionDesc(reqBO.getQuestionDesc());
                afsApplyInfoItem.setWareDescInfo(wareDescInfo);
                WareDetailInfo wareDetailInfo = new WareDetailInfo();
                wareDetailInfo.setWareId(Long.valueOf(skuExtSkuId));
                wareDetailInfo.setMainWareId(Long.valueOf(skuExtSkuId));
                wareDetailInfo.setWareName(saleItemMaps.get(shipItem.getSkuId()).getSkuName());
                wareDetailInfo.setWareNum(Integer.valueOf(dycComUocAfterOrderItemFuncBO.getReturnCount().toPlainString()));
                wareDetailInfo.setWareType(10);
                afsApplyInfoItem.setWareDetailInfo(wareDetailInfo);
                afsApplyInfoItemList.add(afsApplyInfoItem);
            }
            afterOrderEntity.setAfsApplyInfoItemList(afsApplyInfoItemList);
        }
        return afterOrderEntity;
    }

    private void validateArg(DycUocEstoreAfterOrderApplyFuncReqBO reqBo) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBo))) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new ZTBusinessException("\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getShipOrderId())) {
            throw new ZTBusinessException("\u53d1\u8d27\u5355shipOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getTakeAddress()) && !Pattern.matches("^(13[0-9]|14[01456879]|15[0-35-9]|16[2567]|17[0-8]|18[0-9]|19[0-35-9])\\d{8}$", reqBo.getTakeAddress().getContactMobile())) {
            throw new ZTBusinessException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
        }
    }
}

